/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.ModelManager;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorCCDynamicTree;
import com.sun.enterprise.tools.guiframework.view.descriptors.BasicTree;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.web.ui.model.CCNavNode;
import com.sun.web.ui.model.CCNavNodeInterface;
import com.sun.web.ui.model.CCTreeModel;
import com.sun.web.ui.model.CCTreeModelInterface;
import java.util.ArrayList;
import java.util.List;

public class CCDynamicTreeDescriptor
extends ViewDescriptor {
    public CCDynamicTreeDescriptor(String name) {
        super(name);
    }

    public View getInstance(RequestContext ctx, ContainerView container, String name) {
        CCTreeModelInterface model = this.getModel(ctx, (String)this.getParameter("treeIteratorClass"), container);
        return new DescriptorCCDynamicTree(ctx, container, name, this, model);
    }

    public CCTreeModelInterface getModel(RequestContext ctx, String treeIteratorClassName, ContainerView container) {
        boolean fromSession = this.shouldGetModelFromSession();
        boolean toSession = this.shouldPutModelToSession();
        String instanceName = this.getModelInstanceName();
        ModelManager mgr = RequestManager.getRequestContext().getModelManager();
        CCTreeModel model = (CCTreeModel)mgr.getModel(CCTreeModelInterface.class, instanceName, fromSession, toSession);
        List list = model.getNodes();
        if (list == null || list.size() == 0) {
            try {
                Class<?> cls = Class.forName(treeIteratorClassName);
                BasicTree obj = (BasicTree)cls.newInstance();
                obj.init(this, ctx);
                Object root = obj.getRoot();
                String displayName = obj.getDisplayName(root);
                CCNavNode rootNode = new CCNavNode(0, displayName, "", "");
                rootNode.setAsRoot();
                rootNode.setValue(obj.getURL() + obj.getKey(null));
                model.addNode((CCNavNodeInterface)rootNode);
                this.createSubTree(obj, root, rootNode, 1);
            }
            catch (ClassNotFoundException ex) {
                throw new FrameworkException("Cannot find the class " + treeIteratorClassName + " specified by the param 'modelClass'", (Throwable)ex, this, (View)container);
            }
            catch (Exception ex1) {
                throw new FrameworkException("Cannot build the tree model ", (Throwable)ex1, this, (View)container);
            }
        }
        return model;
    }

    private int createSubTree(BasicTree obj, Object parent, CCNavNode parentNode, int id) {
        if (!obj.hasChildren(parent)) {
            parentNode.setAcceptsChildren(false);
            return id;
        }
        ArrayList list = obj.getChildren(parent);
        for (int i = 0; i < list.size(); ++i) {
            Object data = list.get(i);
            String nm = obj.getDisplayName(data);
            CCNavNode node = new CCNavNode(id++, nm, "", "");
            node.setValue(obj.getURL() + obj.getKey(data));
            parentNode.addChild((CCNavNodeInterface)node);
            id = this.createSubTree(obj, data, node, id);
        }
        return id;
    }
}

