/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.sequencing.NativeSequence;
import oracle.toplink.essentials.tools.schemaframework.SequenceDefinition;

public class OracleSequenceDefinition
extends SequenceDefinition {
    protected int increment;
    protected int start = 1;

    public OracleSequenceDefinition(String name, int preallocationSize) {
        super(name);
        this.setIncrement(preallocationSize);
    }

    public OracleSequenceDefinition(String name, int preallocationSize, int start) {
        super(name);
        if (start <= 0) {
            start = 1;
        }
        this.setIncrement(preallocationSize);
        this.setStart(start);
    }

    public OracleSequenceDefinition(String name) {
        this(name, 1);
    }

    public OracleSequenceDefinition(NativeSequence sequence) {
        this(sequence.getName(), sequence.getPreallocationSize(), sequence.getInitialValue());
    }

    public Writer buildCreationWriter(AbstractSession session, Writer writer) {
        try {
            writer.write("CREATE SEQUENCE ");
            writer.write(this.getFullName());
            if (this.getIncrement() != 1) {
                writer.write(" INCREMENT BY " + this.getIncrement());
            }
            int startWith = this.getStart() + this.getIncrement() - 1;
            writer.write(" START WITH " + startWith);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession session, Writer writer) {
        try {
            writer.write("DROP SEQUENCE ");
            writer.write(this.getFullName());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public Writer buildAlterIncrementWriter(AbstractSession session, Writer writer) {
        try {
            writer.write("ALTER SEQUENCE ");
            writer.write(this.getFullName());
            writer.write(" INCREMENT BY " + this.getIncrement());
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
        return writer;
    }

    public boolean checkIfExist(AbstractSession session) throws DatabaseException {
        try {
            session.executeSelectingCall(new SQLCall("SELECT " + this.getName() + ".NEXTVAL FROM DUAL"));
        }
        catch (DatabaseException exception) {
            return false;
        }
        return true;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setStartAndIncrement(int value) {
        this.setStart(1);
        this.setIncrement(value);
    }

    public boolean isAlterSupported() {
        return true;
    }

    public void alterOnDatabase(AbstractSession session) throws TopLinkException {
        try {
            session.executeNonSelectingCall(new SQLCall(this.buildAlterIncrementWriter(session, new StringWriter()).toString()));
        }
        catch (DatabaseException exception) {
            this.createOnDatabase(session);
        }
    }

    public void alterIncrement(AbstractSession session, Writer schemaWriter) throws ValidationException {
        if (schemaWriter == null) {
            this.alterOnDatabase(session);
        } else {
            this.buildAlterIncrementWriter(session, schemaWriter);
        }
    }
}

