/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.InheritancePolicy;
import oracle.toplink.essentials.exceptions.ConversionException;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteObjectQuery;
import oracle.toplink.essentials.queryframework.DoesExistQuery;
import oracle.toplink.essentials.queryframework.InsertObjectQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.UpdateObjectQuery;
import oracle.toplink.essentials.queryframework.WriteObjectQuery;
import oracle.toplink.essentials.sessions.DatabaseRecord;

public class DescriptorQueryManager
implements Cloneable,
Serializable {
    protected transient InsertObjectQuery insertQuery;
    protected transient UpdateObjectQuery updateQuery;
    protected transient ReadObjectQuery readObjectQuery;
    protected transient ReadAllQuery readAllQuery;
    protected transient DeleteObjectQuery deleteQuery;
    protected DoesExistQuery doesExistQuery;
    protected ClassDescriptor descriptor;
    protected boolean hasCustomMultipleTableJoinExpression;
    protected transient Expression additionalJoinExpression;
    protected transient Expression multipleTableJoinExpression;
    protected transient Map queries = new HashMap(5);
    protected transient Map tablesJoinExpressions;

    public DescriptorQueryManager() {
        this.setDoesExistQuery(new DoesExistQuery());
    }

    public void addQuery(String name, DatabaseQuery query) {
        query.setName(name);
        this.addQuery(query);
    }

    public synchronized void addQuery(DatabaseQuery query) {
        Vector queriesByName;
        if (query instanceof ObjectLevelReadQuery && ((ObjectLevelReadQuery)query).getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)query).setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                ((ObjectLevelReadQuery)query).setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException exception) {
                // empty catch block
            }
            query.setDescriptor(this.getDescriptor());
        }
        if ((queriesByName = (Vector)this.getQueries().get(query.getName())) == null) {
            queriesByName = NonSynchronizedVector.newInstance();
            this.getQueries().put(query.getName(), queriesByName);
        } else {
            int i;
            int argumentTypesSize = 0;
            if (query.getArguments() != null) {
                argumentTypesSize = query.getArguments().size();
            }
            NonSynchronizedVector argumentTypes = NonSynchronizedVector.newInstance(argumentTypesSize);
            for (i = 0; i < argumentTypesSize; ++i) {
                ((Vector)argumentTypes).addElement(query.getArgumentTypeNames().elementAt(i));
            }
            for (i = 0; i < queriesByName.size(); ++i) {
                DatabaseQuery currentQuery = (DatabaseQuery)queriesByName.elementAt(i);
                if (!((Vector)argumentTypes).equals(currentQuery.getArgumentTypeNames())) continue;
                queriesByName.remove(i);
                queriesByName.add(i, query);
                return;
            }
        }
        queriesByName.add(query);
    }

    public void assumeExistenceForDoesExist() {
        this.getDoesExistQuery().assumeExistenceForDoesExist();
    }

    public void assumeNonExistenceForDoesExist() {
        this.getDoesExistQuery().assumeNonExistenceForDoesExist();
    }

    public void checkCacheForDoesExist() {
        this.getDoesExistQuery().checkCacheForDoesExist();
    }

    public void checkDatabaseForDoesExist() {
        this.getDoesExistQuery().checkDatabaseForDoesExist();
    }

    public Object clone() {
        DescriptorQueryManager manager = null;
        try {
            manager = (DescriptorQueryManager)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.setQueries(new Hashtable(this.getQueries().size()));
        Iterator iterator = this.queries.values().iterator();
        while (iterator.hasNext()) {
            for (DatabaseQuery initialQuery : (Vector)iterator.next()) {
                DatabaseQuery clonedQuery = (DatabaseQuery)initialQuery.clone();
                clonedQuery.setDescriptor(manager.getDescriptor());
                manager.addQuery(clonedQuery);
            }
        }
        manager.setDoesExistQuery((DoesExistQuery)this.getDoesExistQuery().clone());
        if (this.getReadAllQuery() != null) {
            manager.setReadAllQuery((ReadAllQuery)this.getReadAllQuery().clone());
        }
        if (this.getReadObjectQuery() != null) {
            manager.setReadObjectQuery((ReadObjectQuery)this.getReadObjectQuery().clone());
        }
        if (this.getUpdateQuery() != null) {
            manager.setUpdateQuery((UpdateObjectQuery)this.getUpdateQuery().clone());
        }
        if (this.getInsertQuery() != null) {
            manager.setInsertQuery((InsertObjectQuery)this.getInsertQuery().clone());
        }
        if (this.getDeleteQuery() != null) {
            manager.setDeleteQuery((DeleteObjectQuery)this.getDeleteQuery().clone());
        }
        return manager;
    }

    public boolean containsQuery(String queryName) {
        return this.queries.containsKey(queryName);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Iterator queryVectors = this.getQueries().values().iterator();
        while (queryVectors.hasNext()) {
            Iterator queries = ((Vector)queryVectors.next()).iterator();
            while (queries.hasNext()) {
                ((DatabaseQuery)queries.next()).convertClassNamesToClasses(classLoader);
            }
        }
    }

    public Expression getAdditionalJoinExpression() {
        return this.additionalJoinExpression;
    }

    public DeleteObjectQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    public String getDeleteSQLString() {
        if (this.getDeleteQuery() == null) {
            return null;
        }
        return this.getDeleteQuery().getSQLString();
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DoesExistQuery getDoesExistQuery() {
        return this.doesExistQuery;
    }

    public String getDoesExistSQLString() {
        if (this.getDoesExistQuery() == null) {
            return null;
        }
        return this.getDoesExistQuery().getSQLString();
    }

    public String getExistenceCheck() {
        if (this.getDoesExistQuery().shouldAssumeExistenceForDoesExist()) {
            return "Assume existence";
        }
        if (this.getDoesExistQuery().shouldAssumeNonExistenceForDoesExist()) {
            return "Assume non-existence";
        }
        if (this.getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            return "Check cache";
        }
        if (this.getDoesExistQuery().shouldCheckDatabaseForDoesExist()) {
            return "Check database";
        }
        return "Check cache";
    }

    public InsertObjectQuery getInsertQuery() {
        return this.insertQuery;
    }

    public String getInsertSQLString() {
        if (this.getInsertQuery() == null) {
            return null;
        }
        return this.getInsertQuery().getSQLString();
    }

    public Expression getMultipleTableJoinExpression() {
        return this.multipleTableJoinExpression;
    }

    public Map getQueries() {
        return this.queries;
    }

    public Vector getAllQueries() {
        Vector allQueries = new Vector();
        Iterator vectors = this.getQueries().values().iterator();
        while (vectors.hasNext()) {
            allQueries.addAll((Vector)vectors.next());
        }
        return allQueries;
    }

    public void setAllQueries(Vector vector) {
        Enumeration enumtr = vector.elements();
        while (enumtr.hasMoreElements()) {
            this.addQuery((DatabaseQuery)enumtr.nextElement());
        }
    }

    public void setQueries(Map hashtable) {
        this.queries = hashtable;
    }

    public DatabaseQuery getQuery(String queryName) {
        return this.getQuery(queryName, null);
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        DatabaseQuery query = this.getLocalQuery(name, arguments);
        if (query == null) {
            DatabaseQuery parentQuery = this.getQueryFromParent(name, arguments);
            if (parentQuery != null && parentQuery.isReadQuery()) {
                parentQuery = (DatabaseQuery)parentQuery.clone();
                ((ObjectLevelReadQuery)parentQuery).setReferenceClass(this.getDescriptor().getJavaClass());
                this.addQuery(name, parentQuery);
            }
            return parentQuery;
        }
        return query;
    }

    public DatabaseQuery getLocalQuery(String name, Vector arguments) {
        Vector queries = (Vector)this.getQueries().get(name);
        if (queries == null) {
            return null;
        }
        if (queries.size() == 1) {
            return (DatabaseQuery)queries.firstElement();
        }
        int argumentTypesSize = 0;
        if (arguments != null) {
            argumentTypesSize = arguments.size();
        }
        NonSynchronizedVector argumentTypes = NonSynchronizedVector.newInstance(argumentTypesSize);
        for (int i = 0; i < argumentTypesSize; ++i) {
            ((Vector)argumentTypes).addElement(arguments.elementAt(i).getClass());
        }
        Enumeration queriesEnum = queries.elements();
        while (queriesEnum.hasMoreElements()) {
            DatabaseQuery query = (DatabaseQuery)queriesEnum.nextElement();
            if (!Helper.areTypesAssignable(query.getArgumentTypes(), argumentTypes)) continue;
            return query;
        }
        return null;
    }

    protected DatabaseQuery getQueryFromParent(String name, Vector arguments) {
        InheritancePolicy inheritancePolicy;
        ClassDescriptor parent;
        ClassDescriptor descriptor = this.getDescriptor();
        if (descriptor.hasInheritance() && (parent = (inheritancePolicy = descriptor.getInheritancePolicy()).getParentDescriptor()) != null) {
            return parent.getQueryManager().getQuery(name, arguments);
        }
        return null;
    }

    public ReadAllQuery getReadAllQuery() {
        return this.readAllQuery;
    }

    public String getReadAllSQLString() {
        if (this.getReadAllQuery() == null) {
            return null;
        }
        return this.getReadAllQuery().getSQLString();
    }

    public ReadObjectQuery getReadObjectQuery() {
        return this.readObjectQuery;
    }

    public String getReadObjectSQLString() {
        if (this.getReadObjectQuery() == null) {
            return null;
        }
        return this.getReadObjectQuery().getSQLString();
    }

    public UpdateObjectQuery getUpdateQuery() {
        return this.updateQuery;
    }

    public String getUpdateSQLString() {
        if (this.getUpdateQuery() == null) {
            return null;
        }
        return this.getUpdateQuery().getSQLString();
    }

    public boolean hasCustomMultipleTableJoinExpression() {
        return this.hasCustomMultipleTableJoinExpression;
    }

    public boolean hasDeleteQuery() {
        return this.deleteQuery != null;
    }

    public boolean hasDoesExistQuery() {
        return this.doesExistQuery != null;
    }

    public boolean hasInsertQuery() {
        return this.insertQuery != null;
    }

    public boolean hasReadAllQuery() {
        return this.readAllQuery != null;
    }

    public boolean hasReadObjectQuery() {
        return this.readObjectQuery != null;
    }

    public boolean hasUpdateQuery() {
        return this.updateQuery != null;
    }

    private void populateQueries() {
        if (this.getInsertQuery() != null) {
            this.getInsertQuery().setDescriptor(this.descriptor);
        }
        if (this.getUpdateQuery() != null) {
            this.getUpdateQuery().setDescriptor(this.descriptor);
        }
        if (this.getReadObjectQuery() != null) {
            this.getReadObjectQuery().setReferenceClass(this.getDescriptor().getJavaClass());
            this.getReadObjectQuery().setDescriptor(this.descriptor);
        }
        if (this.getDeleteQuery() != null) {
            this.getDeleteQuery().setDescriptor(this.descriptor);
        }
        if (this.getReadAllQuery() != null) {
            this.getReadAllQuery().setReferenceClass(this.getDescriptor().getJavaClass());
            this.getReadAllQuery().setDescriptor(this.descriptor);
        }
        Iterator it = this.getAllQueries().iterator();
        while (it.hasNext()) {
            ((DatabaseQuery)it.next()).setDescriptor(this.descriptor);
        }
    }

    public void initialize(AbstractSession session) {
        if (this.getDescriptor().isAggregateDescriptor()) {
            return;
        }
        if (this.getMultipleTableJoinExpression() != null) {
            this.setAdditionalJoinExpression(this.getMultipleTableJoinExpression().and(this.getAdditionalJoinExpression()));
        }
        if (this.getDescriptor().isAggregateCollectionDescriptor()) {
            return;
        }
        if (!this.hasReadObjectQuery()) {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
            this.setReadObjectQuery(readObjectQuery);
        }
        if (!this.hasInsertQuery()) {
            this.setInsertQuery(new InsertObjectQuery());
        }
        this.getInsertQuery().setModifyRow(this.getDescriptor().getObjectBuilder().buildTemplateInsertRow(session));
        if (!this.hasDeleteQuery()) {
            this.setDeleteQuery(new DeleteObjectQuery());
        }
        this.getDeleteQuery().setModifyRow(new DatabaseRecord());
        if (this.hasUpdateQuery()) {
            this.getUpdateQuery().setModifyRow(this.getDescriptor().getObjectBuilder().buildTemplateUpdateRow(session));
        }
    }

    public DescriptorQueryManager getParentDescriptorQueryManager() {
        return this.getDescriptor().getInheritancePolicy().getParentDescriptor().getQueryManager();
    }

    public void postDelete(DeleteObjectQuery query) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).postDelete(query);
        }
    }

    public void postInsert(WriteObjectQuery query) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).postInsert(query);
        }
    }

    public void postUpdate(WriteObjectQuery query) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).postUpdate(query);
        }
    }

    public void preDelete(DeleteObjectQuery query) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).preDelete(query);
        }
    }

    public void preInitialize(AbstractSession session) {
        if (this.getDescriptor().isAggregateDescriptor()) {
            return;
        }
        if (this.getDescriptor().isChildDescriptor()) {
            DescriptorQueryManager parentQueryManager = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getQueryManager();
            if (!this.hasInsertQuery() && parentQueryManager.hasInsertQuery()) {
                this.setInsertQuery((InsertObjectQuery)parentQueryManager.getInsertQuery().clone());
            }
            if (!this.hasUpdateQuery() && parentQueryManager.hasUpdateQuery()) {
                this.setUpdateQuery((UpdateObjectQuery)parentQueryManager.getUpdateQuery().clone());
            }
            if (!this.hasDeleteQuery() && parentQueryManager.hasDeleteQuery()) {
                this.setDeleteQuery((DeleteObjectQuery)parentQueryManager.getDeleteQuery().clone());
            }
            if (!this.hasReadObjectQuery() && parentQueryManager.hasReadObjectQuery()) {
                this.setReadObjectQuery((ReadObjectQuery)parentQueryManager.getReadObjectQuery().clone());
            }
            if (!this.hasReadAllQuery() && parentQueryManager.hasReadAllQuery()) {
                this.setReadAllQuery((ReadAllQuery)parentQueryManager.getReadAllQuery().clone());
            }
            if (!this.getDoesExistQuery().isUserDefined() && this.getDoesExistQuery().shouldCheckCacheForDoesExist()) {
                this.setDoesExistQuery((DoesExistQuery)parentQueryManager.getDoesExistQuery().clone());
            }
        }
    }

    public void preInsert(WriteObjectQuery query) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).preInsert(query);
        }
    }

    public void preUpdate(WriteObjectQuery query) {
        Vector mappings = this.getDescriptor().getMappings();
        for (int index = 0; index < mappings.size(); ++index) {
            ((DatabaseMapping)mappings.get(index)).preUpdate(query);
        }
    }

    public void removeQuery(String queryName) {
        this.queries.remove(queryName);
    }

    public void removeQuery(String queryName, Vector argumentTypes) {
        Vector queries = (Vector)this.getQueries().get(queryName);
        if (queries == null) {
            return;
        }
        DatabaseQuery query = null;
        Enumeration enumtr = queries.elements();
        while (enumtr.hasMoreElements() && !Helper.areTypesAssignable(argumentTypes, (query = (DatabaseQuery)enumtr.nextElement()).getArgumentTypes())) {
        }
        if (query != null) {
            queries.remove(query);
        }
    }

    public void setAdditionalJoinExpression(Expression additionalJoinExpression) {
        this.additionalJoinExpression = additionalJoinExpression;
    }

    public void setDeleteQuery(DeleteObjectQuery query) {
        this.deleteQuery = query;
        if (query == null) {
            return;
        }
        this.deleteQuery.setIsUserDefined(true);
        this.deleteQuery.setDescriptor(this.getDescriptor());
    }

    public void setDeleteSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setSQLString(sqlString);
        this.setDeleteQuery(query);
    }

    public void setDeleteCall(Call call) {
        if (call == null) {
            return;
        }
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setCall(call);
        this.setDeleteQuery(query);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
        this.populateQueries();
    }

    public void setDoesExistQuery(DoesExistQuery query) {
        this.doesExistQuery = query;
        if (query == null) {
            return;
        }
        this.doesExistQuery.setIsUserDefined(true);
        this.doesExistQuery.setDescriptor(this.getDescriptor());
    }

    public void setDoesExistSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        this.getDoesExistQuery().setSQLString(sqlString);
        this.getDoesExistQuery().checkDatabaseForDoesExist();
    }

    public void setDoesExistCall(Call call) {
        if (call == null) {
            return;
        }
        this.getDoesExistQuery().setCall(call);
    }

    public void setExistenceCheck(String token) throws DescriptorException {
        if (token.equals("Check cache")) {
            this.checkCacheForDoesExist();
        } else if (token.equals("Check database")) {
            this.checkDatabaseForDoesExist();
        } else if (token.equals("Assume existence")) {
            this.assumeExistenceForDoesExist();
        } else if (token.equals("Assume non-existence")) {
            this.assumeNonExistenceForDoesExist();
        } else {
            throw DescriptorException.setExistenceCheckingNotUnderstood(token, this.getDescriptor());
        }
    }

    protected void setHasCustomMultipleTableJoinExpression(boolean hasCustomMultipleTableJoinExpression) {
        this.hasCustomMultipleTableJoinExpression = hasCustomMultipleTableJoinExpression;
    }

    public void setInsertQuery(InsertObjectQuery insertQuery) {
        this.insertQuery = insertQuery;
        if (insertQuery == null) {
            return;
        }
        this.insertQuery.setIsUserDefined(true);
        this.insertQuery.setDescriptor(this.getDescriptor());
    }

    public void setInsertCall(Call call) {
        if (call == null) {
            return;
        }
        InsertObjectQuery query = new InsertObjectQuery();
        query.setCall(call);
        this.setInsertQuery(query);
    }

    public void setInsertSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        InsertObjectQuery query = new InsertObjectQuery();
        query.setSQLString(sqlString);
        this.setInsertQuery(query);
    }

    public Call getInsertCall() {
        if (this.getInsertQuery() == null) {
            return null;
        }
        return this.getInsertQuery().getDatasourceCall();
    }

    public Call getUpdateCall() {
        if (this.getUpdateQuery() == null) {
            return null;
        }
        return this.getUpdateQuery().getDatasourceCall();
    }

    public Call getDeleteCall() {
        if (this.getDeleteQuery() == null) {
            return null;
        }
        return this.getDeleteQuery().getDatasourceCall();
    }

    public Call getReadObjectCall() {
        if (this.getReadObjectQuery() == null) {
            return null;
        }
        return this.getReadObjectQuery().getDatasourceCall();
    }

    public Call getReadAllCall() {
        if (this.getReadAllQuery() == null) {
            return null;
        }
        return this.getReadAllQuery().getDatasourceCall();
    }

    public Call getDoesExistCall() {
        if (this.getDoesExistQuery() == null) {
            return null;
        }
        return this.getDoesExistQuery().getDatasourceCall();
    }

    public Map getTablesJoinExpressions() {
        if (this.tablesJoinExpressions == null) {
            this.tablesJoinExpressions = new HashMap();
        }
        return this.tablesJoinExpressions;
    }

    public void setInternalMultipleTableJoinExpression(Expression multipleTableJoinExpression) {
        this.multipleTableJoinExpression = multipleTableJoinExpression;
    }

    public void setMultipleTableJoinExpression(Expression multipleTableJoinExpression) {
        this.multipleTableJoinExpression = multipleTableJoinExpression;
        this.setHasCustomMultipleTableJoinExpression(true);
    }

    public void setReadAllQuery(ReadAllQuery query) {
        this.readAllQuery = query;
        if (query == null) {
            return;
        }
        this.readAllQuery.setIsUserDefined(true);
        if (this.getDescriptor() != null) {
            this.readAllQuery.setDescriptor(this.getDescriptor());
            this.readAllQuery.setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                this.readAllQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    public void setReadAllSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        ReadAllQuery query = new ReadAllQuery();
        query.setSQLString(sqlString);
        this.setReadAllQuery(query);
    }

    public void setReadAllCall(Call call) {
        if (call == null) {
            return;
        }
        ReadAllQuery query = new ReadAllQuery();
        query.setCall(call);
        this.setReadAllQuery(query);
    }

    public void setReadObjectQuery(ReadObjectQuery query) {
        this.readObjectQuery = query;
        if (query == null) {
            return;
        }
        this.readObjectQuery.setIsUserDefined(true);
        if (this.getDescriptor() != null) {
            this.readObjectQuery.setDescriptor(this.getDescriptor());
            this.readObjectQuery.setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                this.readObjectQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    public void setReadObjectSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSQLString(sqlString);
        this.setReadObjectQuery(query);
    }

    public void setReadObjectCall(Call call) {
        if (call == null) {
            return;
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setCall(call);
        this.setReadObjectQuery(query);
    }

    public void setUpdateQuery(UpdateObjectQuery updateQuery) {
        this.updateQuery = updateQuery;
        if (updateQuery == null) {
            return;
        }
        this.updateQuery.setIsUserDefined(true);
        this.updateQuery.setDescriptor(this.getDescriptor());
    }

    public void setUpdateSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setSQLString(sqlString);
        this.setUpdateQuery(query);
    }

    public void setUpdateCall(Call call) {
        if (call == null) {
            return;
        }
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setCall(call);
        this.setUpdateQuery(query);
    }
}

