/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.view.ViewBase;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class CommandSourceTargetPair {
    public static final int SQL_OBJECT_TYPE = 1;
    public static final int SQL_WHERE_TYPE = 1;
    public static final int MODEL_FIELD_TYPE = 2;
    public static final int DISPLAY_FIELD_TYPE = 3;
    public static final int PAGE_SESSION_TYPE = 4;
    public static final int HTTP_SESSION_TYPE = 5;
    public static final int USER_SESSION_OBJECT_TYPE = 5;
    protected static final String INVALID_TYPE_MSG = "Illegal value [{0}] supplied for {1}";
    public static final String SOURCE_VALUE_NVP_NAME_PREFIX = "jato.AutoSource.";
    private int sourceType;
    private String qualifiedSourceName;
    private String[] sourcePath;
    private String[] targetPath;
    private Class sourceClass;
    private Class targetClass;
    private int targetType;
    private String qualifiedTargetName;

    public CommandSourceTargetPair(int sourceType, Class sourceClass, String qualifiedSourceName, int targetType, Class targetClass, String qualifiedTargetName) throws IllegalArgumentException {
        if (!this.checkType(sourceType)) {
            String msg = MessageFormat.format(INVALID_TYPE_MSG, new Integer(sourceType), "sourceType");
            throw new IllegalArgumentException(msg);
        }
        if (!this.checkType(targetType)) {
            String msg = MessageFormat.format(INVALID_TYPE_MSG, new Integer(targetType), "targetType");
            throw new IllegalArgumentException(msg);
        }
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.qualifiedSourceName = qualifiedSourceName;
        this.qualifiedTargetName = qualifiedTargetName;
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.sourcePath = this.parsePath(qualifiedSourceName);
        this.targetPath = this.parsePath(qualifiedTargetName);
    }

    private String[] parsePath(String qualifiedName) {
        ArrayList<String> path = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(qualifiedName, ViewBase.getQualifiedViewNameSeparator() + "/", false);
        while (tok.hasMoreTokens()) {
            String nextVal = tok.nextToken().trim();
            path.add(nextVal);
        }
        return path.toArray(new String[0]);
    }

    protected boolean checkType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public int getSourceType() {
        return this.sourceType;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public String getQualifiedSourceName() {
        return this.qualifiedSourceName;
    }

    public String getQualifiedTargetName() {
        return this.qualifiedTargetName;
    }

    public String[] getSourcePath() {
        return this.sourcePath;
    }

    public String[] getTargetPath() {
        return this.targetPath;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    static {
        SQL_OBJECT_TYPE = 1;
        SQL_WHERE_TYPE = 1;
        MODEL_FIELD_TYPE = 2;
        DISPLAY_FIELD_TYPE = 3;
        PAGE_SESSION_TYPE = 4;
        HTTP_SESSION_TYPE = 5;
        USER_SESSION_OBJECT_TYPE = 5;
        INVALID_TYPE_MSG = INVALID_TYPE_MSG;
        SOURCE_VALUE_NVP_NAME_PREFIX = SOURCE_VALUE_NVP_NAME_PREFIX;
    }
}

