/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.tree.html;

import com.iplanet.jato.ClientSession;
import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.taglib.tree.TreeTagBase;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.TreeView;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class TreeNodeHandleTag
extends TreeTagBase
implements BodyTag {
    private BodyContent bodyContent = null;
    private NonSyncStringBuffer buffer = null;
    private CompleteRequestException abortedException;

    public void reset() {
        super.reset();
        this.bodyContent = null;
        this.buffer = null;
        this.abortedException = null;
    }

    public int doStartTag() throws JspException {
        this.reset();
        try {
            ViewBean viewBean = this.getParentViewBean();
            TreeView treeView = this.getParentTreeView();
            Object value = treeView.getTreeHandleChildValue();
            if (value == null) {
                value = "";
            }
            this.buffer = new NonSyncStringBuffer("<a href=\"", 256);
            this.buffer.append(((HttpServletResponse)this.pageContext.getResponse()).encodeURL(viewBean.getModuleURL() + "/" + viewBean.getRequestInvocationName()));
            this.buffer.append("?").append(treeView.getTreeHandleChildName()).append("=").append(URLEncoder.encode(value.toString()));
            this.buffer.append("&").append(treeView.getTreeHandleStateParameterName()).append("=").append(new Boolean(!treeView.isNodeExpanded()));
            this.appendQueryParams(this.buffer);
            this.buffer.append("&").append("jato.pageSession").append("=").append(viewBean.getPageSessionAttributeString(false));
            try {
                ClientSession clientSession = viewBean.getRequestContext().getClientSession();
                if (clientSession.hasAttributes()) {
                    this.buffer.append("&").append("jato.clientSession").append("=").append(clientSession.getEncodedString());
                }
            }
            catch (IOException e) {
                throw new JspException("Error serializing client session", (Throwable)e);
            }
            this.buffer.append("\"");
            if (this.getTitle() != null) {
                this.buffer.append(" title=\"").append(this.getTitle()).append("\"");
            }
            this.appendCommonHtmlAttributes(this.buffer);
            this.appendJavaScriptAttributes(this.buffer);
            this.appendStyleAttributes(this.buffer);
            if (this.getExtraHtml() != null) {
                this.buffer.append(" ").append(this.getExtraHtml());
            }
            this.buffer.append(">");
        }
        catch (CompleteRequestException e) {
            this.abortedException = e;
            return 0;
        }
        return 2;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.abortedException != null) {
                throw this.abortedException;
            }
            BodyContent bodyContent = this.getBodyContent();
            if (bodyContent != null) {
                if (this.getTrim() == null || this.isTrue(this.getTrim())) {
                    this.buffer.append(bodyContent.getString().trim());
                } else {
                    this.buffer.append(bodyContent.getString());
                }
            }
            this.buffer.append("</a>");
            this.writeOutput(this.buffer.toString());
        }
        catch (CompleteRequestException e) {
            this.getRequestContext().getRequest().setAttribute(ViewBeanBase.DISPLAY_EVENT_COMPLETED_REQUEST_ATTRIBUTE_NAME, (Object)e);
            return 5;
        }
        return 6;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }

    protected void appendQueryParams(NonSyncStringBuffer buffer) throws JspException {
        String nvPairs = this.getQueryParams();
        if (nvPairs != null && nvPairs.length() > 0) {
            buffer.append("&");
            buffer.append(nvPairs);
        }
    }

    public String getTitle() {
        return (String)this.getValue("title");
    }

    public void setTitle(String value) {
        this.setValue("title", value);
    }

    public String getQueryParams() {
        return (String)this.getValue("queryParams");
    }

    public void setQueryParams(String value) {
        this.setValue("queryParams", value);
    }

    public String getTrim() {
        return (String)this.getValue("trim");
    }

    public void setTrim(String value) {
        this.setValue("trim", value);
    }
}

