/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.tree;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.taglib.JspWrapperException;
import com.iplanet.jato.taglib.tree.TreeTagBase;
import com.iplanet.jato.util.StringTokenizer2;
import com.iplanet.jato.view.TreeView;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class TreeNodeTag
extends TreeTagBase
implements BodyTag {
    private BodyContent bodyContent = null;
    private boolean displayed = false;

    public void reset() {
        super.reset();
        this.bodyContent = null;
        this.displayed = false;
    }

    public int doStartTag() throws JspException {
        this.reset();
        try {
            this.displayed = this.matchNode();
        }
        catch (ModelControlException e) {
            throw new JspWrapperException("Exception during doStartTag() for node \"" + this.getNodeName() + "\"", e);
        }
        if (this.displayed) {
            return 2;
        }
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        String html;
        BodyContent bodyContent;
        if (this.displayed && (bodyContent = this.getBodyContent()) != null && (html = bodyContent.getString()) != null) {
            this.writeOutput(html);
        }
        return 6;
    }

    protected boolean matchNode() throws JspException, ModelControlException {
        boolean isMatch = false;
        TreeView tv = this.getParentTreeView();
        isMatch = this.matchNodeName(tv);
        if (isMatch && (isMatch = this.matchNodeType(tv)) && (isMatch = this.matchHasChildren(tv))) {
            isMatch = this.matchIsExpanded(tv);
        }
        return isMatch;
    }

    protected boolean matchNodeName(TreeView tv) throws JspException, ModelControlException {
        boolean isMatch = false;
        if (this.getNodeName() != null) {
            String actualName = tv.getNodeName();
            String[] matchNames = StringTokenizer2.tokenize(this.getNodeName(), ",");
            int i = 0;
            while (i < matchNames.length && !isMatch) {
                if (!matchNames[i++].equals(actualName)) continue;
                isMatch = true;
            }
        } else {
            isMatch = true;
        }
        return isMatch;
    }

    protected boolean matchNodeType(TreeView tv) throws JspException, ModelControlException {
        boolean isMatch = false;
        if (this.getNodeType() != null) {
            String actualType = tv.getNodeType();
            String[] matchTypes = StringTokenizer2.tokenize(this.getNodeType(), ",");
            int i = 0;
            while (i < matchTypes.length && !isMatch) {
                if (!matchTypes[i++].equals(actualType)) continue;
                isMatch = true;
            }
        } else {
            isMatch = true;
        }
        return isMatch;
    }

    protected boolean matchHasChildren(TreeView tv) throws JspException {
        boolean isMatch = true;
        if (this.getHasChildren() != null) {
            isMatch = this.isTrue(this.getHasChildren()) == tv.isParentNode();
        }
        return isMatch;
    }

    protected boolean matchIsExpanded(TreeView tv) throws JspException {
        if (this.getIsExpanded() != null) {
            return this.isTrue(this.getIsExpanded()) == tv.isNodeExpanded();
        }
        return true;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }

    public String getNodeName() {
        return (String)this.getValue("nodeName");
    }

    public void setNodeName(String value) {
        this.setValue("nodeName", value);
    }

    public String getNodeType() {
        return (String)this.getValue("nodeType");
    }

    public void setNodeType(String value) {
        this.setValue("nodeType", value);
    }

    public String getHasChildren() {
        return (String)this.getValue("hasChildren");
    }

    public void setHasChildren(String value) {
        this.setValue("hasChildren", value);
    }

    public String getIsExpanded() {
        return (String)this.getValue("isExpanded");
    }

    public void setIsExpanded(String value) {
        this.setValue("isExpanded", value);
    }
}

