/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.taglib.JspWrapperException;
import com.iplanet.jato.taglib.TagBase;
import com.iplanet.jato.util.StringTokenizer2;
import com.iplanet.jato.view.ViewBeanBase;
import com.iplanet.jato.view.event.JspBeginChildDisplayEvent;
import com.iplanet.jato.view.event.JspEndChildDisplayEvent;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public class ContentTag
extends TagBase
implements BodyTag {
    public static final String ATTR_ROLES = "roles";
    public static final String ATTR_NEGATE = "negate";
    private BodyContent bodyContent = null;
    private boolean displayed = false;
    private CompleteRequestException abortedException;

    public void reset() {
        super.reset();
        this.bodyContent = null;
        this.displayed = false;
        this.abortedException = null;
    }

    public int doStartTag() throws JspException {
        this.reset();
        try {
            if (this.getRoles() != null) {
                if (this.getRoles().trim().length() == 0) {
                    throw new JspException("At least one role must be specified for the \"roles\" attribute");
                }
                StringTokenizer2 tok = new StringTokenizer2(this.getRoles(), ",");
                while (tok.hasMoreTokens()) {
                    if (!this.getRequestContext().getRequest().isUserInRole(tok.nextToken().trim())) continue;
                    this.displayed = true;
                    break;
                }
            } else {
                this.displayed = this.getParentContainerView().beginChildDisplay(new JspBeginChildDisplayEvent((Tag)this, this.pageContext, this.getName()));
            }
            if (this.isTrue(this.isNegate())) {
                this.displayed = !this.displayed;
            }
        }
        catch (ModelControlException e) {
            throw new JspWrapperException("Exception during beginDisplay() event for content \"" + this.getName() + "\"", e);
        }
        catch (CompleteRequestException e) {
            this.abortedException = e;
            return 0;
        }
        if (this.displayed) {
            return 2;
        }
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.abortedException != null) {
                throw this.abortedException;
            }
            if (this.displayed) {
                String html = null;
                BodyContent bodyContent = this.getBodyContent();
                if (bodyContent != null) {
                    html = bodyContent.getString();
                }
                if ((html = this.getParentContainerView().endChildDisplay(new JspEndChildDisplayEvent((Tag)this, this.pageContext, this.getName(), html))) != null) {
                    this.writeOutput(html);
                }
            }
        }
        catch (ModelControlException e) {
            throw new JspWrapperException("Exception during endDisplay() event for content \"" + this.getName() + "\"", e);
        }
        catch (CompleteRequestException e) {
            this.getRequestContext().getRequest().setAttribute(ViewBeanBase.DISPLAY_EVENT_COMPLETED_REQUEST_ATTRIBUTE_NAME, (Object)e);
            return 5;
        }
        return 6;
    }

    public String getRoles() {
        return (String)this.getValue(ATTR_ROLES);
    }

    public void setRoles(String value) {
        this.setValue(ATTR_ROLES, value);
    }

    public String isNegate() {
        return (String)this.getValue(ATTR_NEGATE);
    }

    public void setNegate(String value) {
        this.setValue(ATTR_NEGATE, value);
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }

    static {
        ATTR_ROLES = ATTR_ROLES;
        ATTR_NEGATE = ATTR_NEGATE;
    }
}

