/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ModelComponentInfoSupport {
    public static final String PROPERTY_KEY_PREFIX = "PROP";
    public static final String LABEL_KEY_PREFIX = "LBL";
    public static final String VISUAL_CONTROL_KEY_PREFIX = "CTL";
    public static final String TEXT_KEY_PREFIX = "TXT";
    public static final String MESSAGE_KEY_PREFIX = "MSG";
    public static final String HINT_KEY_PREFIX = "HINT";
    public static final String RESOURCE_KEY_PREFIX = "RES";
    public static final String RESOURCE_KEY_DELIMITER = "_";

    protected ModelComponentInfoSupport() {
    }

    protected static String sourceTemplateResourceName(Class clazz) {
        return ModelComponentInfoSupport.resourceValue(clazz, "SOURCE_TEMPLATE", null);
    }

    protected static String sourceTemplateEncoding(Class clazz) {
        return ModelComponentInfoSupport.propertyValue(clazz, "SOURCE_TEMPLATE_ENCODING", null);
    }

    protected static InputStream sourceTemplateRawStream(Class clazz, String resourceName) {
        return clazz.getClassLoader().getResourceAsStream(resourceName);
    }

    public static ResourceBundle getBundle(Class clazz) {
        return ResourceBundle.getBundle(clazz.getPackage().getName() + ".Bundle", Locale.getDefault(), clazz.getClassLoader());
    }

    public static String shortClassName(Class clazz) {
        return clazz.getName().substring(clazz.getPackage().getName().length() + 1);
    }

    public static String bundleValue(Class clazz, String prefix, String key, String defaultValue) {
        String fullKey = ModelComponentInfoSupport.bundleKey(clazz, prefix, key);
        try {
            return ModelComponentInfoSupport.getBundle(clazz).getString(fullKey);
        }
        catch (MissingResourceException mre) {
            System.out.println("missing resource " + fullKey + " in package " + clazz.getPackage().getName());
            return defaultValue;
        }
    }

    public static String bundleKey(Class clazz, String prefix, String key) {
        if (null == clazz) {
            return prefix + RESOURCE_KEY_DELIMITER + key;
        }
        return prefix + RESOURCE_KEY_DELIMITER + ModelComponentInfoSupport.shortClassName(clazz) + RESOURCE_KEY_DELIMITER + key;
    }

    public static String propertyKey(Class clazz, String key) {
        return ModelComponentInfoSupport.bundleKey(clazz, PROPERTY_KEY_PREFIX, key);
    }

    public static String labelKey(Class clazz, String key) {
        return ModelComponentInfoSupport.bundleKey(clazz, LABEL_KEY_PREFIX, key);
    }

    public static String controlKey(Class clazz, String key) {
        return ModelComponentInfoSupport.bundleKey(clazz, VISUAL_CONTROL_KEY_PREFIX, key);
    }

    public static String textKey(Class clazz, String key) {
        return ModelComponentInfoSupport.bundleKey(clazz, TEXT_KEY_PREFIX, key);
    }

    public static String messageKey(Class clazz, String key) {
        return ModelComponentInfoSupport.bundleKey(clazz, MESSAGE_KEY_PREFIX, key);
    }

    public static String hintKey(Class clazz, String key) {
        return ModelComponentInfoSupport.bundleKey(clazz, MESSAGE_KEY_PREFIX, key);
    }

    public static String resourceKey(Class clazz, String key) {
        return ModelComponentInfoSupport.bundleKey(clazz, RESOURCE_KEY_PREFIX, key);
    }

    public static String propertyValue(Class clazz, String key, String defaultValue) {
        return ModelComponentInfoSupport.bundleValue(clazz, PROPERTY_KEY_PREFIX, key, defaultValue);
    }

    public static String labelValue(Class clazz, String key, String defaultValue) {
        return ModelComponentInfoSupport.bundleValue(clazz, LABEL_KEY_PREFIX, key, defaultValue);
    }

    public static String controlValue(Class clazz, String key, String defaultValue) {
        return ModelComponentInfoSupport.bundleValue(clazz, VISUAL_CONTROL_KEY_PREFIX, key, defaultValue);
    }

    public static String textValue(Class clazz, String key, String defaultValue) {
        return ModelComponentInfoSupport.bundleValue(clazz, TEXT_KEY_PREFIX, key, defaultValue);
    }

    public static String messageValue(Class clazz, String key, String defaultValue) {
        return ModelComponentInfoSupport.bundleValue(clazz, MESSAGE_KEY_PREFIX, key, defaultValue);
    }

    public static String hintValue(Class clazz, String key, String defaultValue) {
        return ModelComponentInfoSupport.bundleValue(clazz, MESSAGE_KEY_PREFIX, key, defaultValue);
    }

    public static String resourceValue(Class clazz, String key, String defaultValue) {
        return ModelComponentInfoSupport.bundleValue(clazz, RESOURCE_KEY_PREFIX, key, defaultValue);
    }

    static {
        PROPERTY_KEY_PREFIX = PROPERTY_KEY_PREFIX;
        LABEL_KEY_PREFIX = LABEL_KEY_PREFIX;
        VISUAL_CONTROL_KEY_PREFIX = VISUAL_CONTROL_KEY_PREFIX;
        TEXT_KEY_PREFIX = TEXT_KEY_PREFIX;
        MESSAGE_KEY_PREFIX = MESSAGE_KEY_PREFIX;
        HINT_KEY_PREFIX = HINT_KEY_PREFIX;
        RESOURCE_KEY_PREFIX = RESOURCE_KEY_PREFIX;
        RESOURCE_KEY_DELIMITER = RESOURCE_KEY_DELIMITER;
    }
}

