/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.utility;

import com.sun.jdo.spi.persistence.support.sqlstore.utility.TickEventListener;

public class Timer
implements Runnable {
    private Thread runner;
    private boolean active;
    private boolean tickOnce;
    private long interval;
    private long ticks;
    private TickEventListener owner;
    private boolean isTerminated;
    public static int suspends = 0;
    public static int resumes = 0;

    public Timer(TickEventListener obj, long interval, boolean active) {
        this(obj, interval, active, false, null);
    }

    public Timer(TickEventListener obj, long interval, boolean active, boolean tickOnce, String name) {
        this.owner = obj;
        this.interval = interval;
        this.active = active;
        this.tickOnce = tickOnce;
        this.isTerminated = false;
        Thread thd = new Thread(this);
        thd.setDaemon(true);
        if (name != null) {
            thd.setName(name);
        } else {
            thd.setName("TimerThread" + System.identityHashCode(this));
        }
        thd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long interval) {
        Timer timer = this;
        synchronized (timer) {
            if (this.interval == interval) {
                return;
            }
            this.interval = interval;
            if (this.active) {
                this.runner.interrupt();
            }
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public long getTickCount() {
        return this.ticks;
    }

    public void setTickCount(long count) {
        this.ticks = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(boolean state) {
        Timer timer = this;
        synchronized (timer) {
            if (this.active == state) {
                return;
            }
            if (this.active) {
                this.runner.interrupt();
            } else {
                this.notify();
            }
            this.active = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Timer timer = this;
        synchronized (timer) {
            this.isTerminated = true;
            if (this.runner != null) {
                this.setState(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.runMe();
        }
        finally {
            this.cleanForGC();
        }
    }

    void runMe() {
    }

    private void cleanForGC() {
        this.owner = null;
        this.runner = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void destroy() {
        try {
            this.cleanForGC();
            Thread runThread = this.runner;
            if (runThread == null) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        this.destroy();
    }
}

