/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class AttributeVector {
    private ClassAttribute[] attributes = null;

    private ClassAttribute attrAt(int i) {
        return this.attributes[i];
    }

    public void addElement(ClassAttribute attr) {
        if (this.attributes == null) {
            this.attributes = new ClassAttribute[1];
        } else {
            ClassAttribute[] newAttributes = new ClassAttribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
            this.attributes = newAttributes;
        }
        this.attributes[this.attributes.length - 1] = attr;
    }

    public Enumeration elements() {
        class AttributeVectorEnumeration
        implements Enumeration {
            private ClassAttribute[] attributes;
            private int current = 0;

            AttributeVectorEnumeration(ClassAttribute[] attrs) {
                this.attributes = attrs;
            }

            public boolean hasMoreElements() {
                return this.attributes != null && this.current < this.attributes.length;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return this.attributes[this.current++];
            }
        }
        return new AttributeVectorEnumeration(this.attributes);
    }

    public ClassAttribute findAttribute(String attrName) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!attr.attrName().asString().equals(attrName)) continue;
            return attr;
        }
        return null;
    }

    static AttributeVector readAttributes(DataInputStream data, ConstantPool constantPool) throws IOException {
        AttributeVector attribs = new AttributeVector();
        int n_attrs = data.readUnsignedShort();
        while (n_attrs-- > 0) {
            attribs.addElement(ClassAttribute.read(data, constantPool));
        }
        return attribs;
    }

    static AttributeVector readAttributes(DataInputStream data, CodeEnv codeEnv) throws IOException {
        AttributeVector attribs = new AttributeVector();
        int n_attrs = data.readUnsignedShort();
        while (n_attrs-- > 0) {
            attribs.addElement(ClassAttribute.read(data, codeEnv));
        }
        return attribs;
    }

    void write(DataOutputStream out) throws IOException {
        if (this.attributes == null) {
            out.writeShort(0);
        } else {
            out.writeShort(this.attributes.length);
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].write(out);
            }
        }
    }

    void print(PrintStream out, int indent) {
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].print(out, indent);
            }
        }
    }

    void summarize() {
        System.out.println((this.attributes == null ? 0 : this.attributes.length) + " attributes");
    }
}

