/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class DomainInfo {
    private String domainName;
    private String domainPath;
    private List instanceNames;
    private Hashtable instancePathMapping;

    public DomainInfo(String dName, String dPath) {
        this.domainName = dName;
        this.domainPath = dPath;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainPath() {
        return this.domainPath;
    }

    public void setDomainPath(String domainPath) {
        this.domainPath = domainPath;
    }

    public List getInstanceNames() {
        if (this.instanceNames == null) {
            this.instanceNames = new ArrayList();
            this.instancePathMapping = new Hashtable();
            File domainDir = new File(this.domainPath);
            String[] instanceDirs = domainDir.list();
            for (int i = 0; i < instanceDirs.length; ++i) {
                this.instanceNames.add(instanceDirs[i]);
                String instancePath = this.domainPath + File.separator + instanceDirs[i];
                this.instancePathMapping.put(instanceDirs[i], instancePath);
            }
        }
        return this.instanceNames;
    }

    public String getInstancePath(String instanceName) {
        if (this.instancePathMapping == null) {
            this.getInstanceNames();
        }
        if (instanceName == null || "".equals(instanceName.trim())) {
            return this.domainPath;
        }
        return (String)this.instancePathMapping.get(instanceName);
    }

    public String getDomainApplicationRoot() {
        String configFileName = this.domainPath + File.separator + "config" + File.separator + "domain.xml";
        String applRoot = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document adminServerDoc = builder.parse(new File(configFileName));
            NodeList domainElements = adminServerDoc.getElementsByTagName("domain");
            Element domainElement = (Element)domainElements.item(0);
            if (domainElement != null) {
                String attrValue = domainElement.getAttribute("application-root");
                StringTokenizer attrTokens = new StringTokenizer(attrValue, "/");
                attrTokens.nextToken();
                applRoot = attrTokens.nextToken();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return applRoot;
    }
}

