/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.GSetUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetUtil {
    private SetUtil() {
    }

    public static <T> T getSingleton(Set<T> s) {
        if (s.size() != 1) {
            throw new IllegalArgumentException(s.toString());
        }
        return s.iterator().next();
    }

    public static <T> void addArray(Set<T> set, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
    }

    public static String[] toStringArray(Set set) {
        String[] strings = new String[set.size()];
        Iterator iter = set.iterator();
        int i = 0;
        while (iter.hasNext()) {
            strings[i] = iter.next().toString();
            ++i;
        }
        return strings;
    }

    public static Object[] toArray(Set<?> set) {
        Object[] names = new Object[set.size()];
        set.toArray(names);
        return names;
    }

    public static <T> Set<T> newSet(Collection<T> c) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(c);
        return set;
    }

    public static <T> Set<T> newSingletonSet(T m1) {
        HashSet<T> set = new HashSet<T>();
        set.add(m1);
        return set;
    }

    public static <T> HashSet<T> copySet(Set<T> s1) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(s1);
        return set;
    }

    public static <T> Set<T> newSet(Set<? extends T>[] sets) {
        HashSet<? extends T> s = new HashSet<T>();
        for (int i = 0; i < sets.length; ++i) {
            s.addAll(sets[i]);
        }
        return s;
    }

    public static <T> Set<T> newSet(Set<? extends T> s1, Set<? extends T> s2) {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(s1);
        result.addAll(s2);
        return result;
    }

    public static <T> Set<T> newSet(Set<? extends T> s1, Set<? extends T> s2, Set<? extends T> s3) {
        return SetUtil.newSet(SetUtil.newSet(s1, s2), s3);
    }

    public static <T> Set<T> newSet(Set<? extends T> s1, Set<? extends T> s2, Set<? extends T> s3, Set<? extends T> s4) {
        return SetUtil.newSet(SetUtil.newSet(s1, s2), SetUtil.newSet(s3, s4));
    }

    public static Set<String> newUnmodifiableSet(String[] objects) {
        return GSetUtil.newUnmodifiableStringSet(objects);
    }

    public static <T> Set<T> newSet(T ... objects) {
        return SetUtil.newSet(objects, 0, objects.length);
    }

    public static <T> Set<T> newSet(T[] objects, int startIndex, int numItems) {
        HashSet<T> set = new HashSet<T>();
        for (int i = 0; i < numItems; ++i) {
            set.add(objects[startIndex + i]);
        }
        return set;
    }

    public static <T> Set<T> intersectSets(Set<T> set1, Set<T> set2) {
        Set<T> result = SetUtil.newSet(set1);
        result.retainAll(set2);
        return result;
    }

    public static <T> Set<T> removeSet(Set<T> set1, Set<T> set2) {
        Set<T> result = SetUtil.newSet(set1);
        result.removeAll(set2);
        return result;
    }

    public static <T> Set<T> newNotCommonSet(Set<T> set1, Set<T> set2) {
        Set<T> result = SetUtil.newSet(set1, set2);
        Set<T> common = SetUtil.intersectSets(set1, set2);
        result.removeAll(common);
        return result;
    }
}

