/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.ArrayConversion;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IteratorUtil {
    private IteratorUtil() {
    }

    public static <T> Object[] toArray(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            T elem = iter.next();
            list.add(elem);
        }
        Object[] result = new Object[list.size()];
        list.toArray(result);
        return ArrayConversion.specializeArray(result);
    }

    public static Class getUniformClass(Iterator<?> iter) {
        Class<?> theClass = null;
        if (iter.hasNext()) {
            theClass = iter.next().getClass();
        }
        while (iter.hasNext()) {
            if (iter.next().getClass() == theClass) continue;
            theClass = null;
            break;
        }
        return theClass;
    }

    public static <T> boolean isUniformClass(Iterator iter, Class<T> theClass, boolean exactMatch) {
        boolean isUniform = true;
        while (iter.hasNext()) {
            Class<?> nextClass = iter.next().getClass();
            if (nextClass == theClass) continue;
            if (exactMatch) {
                isUniform = false;
                break;
            }
            if (theClass.isAssignableFrom(nextClass)) continue;
            isUniform = false;
            break;
        }
        return isUniform;
    }
}

