/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.jmx;

import com.sun.appserv.management.util.jmx.MBeanServerConnection_Hook;
import com.sun.appserv.management.util.misc.Output;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;

public class MBeanServerConnection_Perf
extends MBeanServerConnection_Hook {
    private final PerfHook mHook;
    private final Output mOutput;
    private boolean mPerfEnabled;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    public MBeanServerConnection_Perf(MBeanServerConnection impl, Output output) {
        super(impl);
        this.mOutput = output;
        this.mHook = new PerfHook();
        this.mPerfEnabled = true;
    }

    public final boolean getPerf() {
        return this.mPerfEnabled;
    }

    public final void setPerf(boolean perfEnabled) {
        this.mPerfEnabled = perfEnabled;
    }

    protected final MBeanServerConnection_Hook.Hook getHook() {
        return this.mHook;
    }

    private final class PerfHook
    extends MBeanServerConnection_Hook.HookImpl {
        private final Map<Long, Long> mTimers = Collections.synchronizedMap(new HashMap());

        private final void print(Object o) {
            if (MBeanServerConnection_Perf.this.getPerf()) {
                MBeanServerConnection_Perf.this.mOutput.printDebug(o);
            }
        }

        public long preHook(String methodName) {
            return this.preHook(methodName, EMPTY_ARRAY);
        }

        public long preHook(String methodName, Object[] args) {
            long id = super.preHook(methodName, args);
            Long start = new Long(System.currentTimeMillis());
            this.mTimers.put(new Long(id), start);
            return id;
        }

        private void printTime(long id, String methodName, Object[] args) {
            long curTime = System.currentTimeMillis();
            Long start = this.mTimers.remove(new Long(id));
            if (start != null) {
                MBeanServerConnection_Perf.this.mOutput.println(this.getInvocationString(methodName, args) + ": " + (curTime - start));
            }
        }

        public void postHook(long id, String methodName) {
            this.printTime(id, methodName, null);
        }

        public void postHook(long id, String methodName, Object[] args) {
            this.printTime(id, methodName, args);
        }

        public void postHook(long id, String methodName, Object[] args, Object result) {
            this.printTime(id, methodName, args);
        }
    }
}

