#pragma once

#include <stdint.h>
#include <stdbool.h>

enum // RADIOBUTTONS
{
	// HELP
	RB_HELP_FEATURES,
	RB_HELP_EFFECTS,
	RB_HELP_KEYBOARD,
	RB_HELP_HOW_TO_USE_FT2,
	RB_HELP_FAQ,
	RB_HELP_KNOWN_BUGS,

	// NIBBLES
	RB_NIBBLES_1PLAYER,
	RB_NIBBLES_2PLAYERS,
	RB_NIBBLES_NOVICE,
	RB_NIBBLES_AVERAGE,
	RB_NIBBLES_PRO,
	RB_NIBBLES_MANIAC,

	// SAMPLER
	RB_SAMPLE_NO_LOOP,
	RB_SAMPLE_FORWARD_LOOP,
	RB_SAMPLE_PINGPONG_LOOP,
	RB_SAMPLE_8BIT,
	RB_SAMPLE_16BIT,

	// INSTRUMENT EDITOR
	RB_INST_WAVE_SINE,
	RB_INST_WAVE_SQUARE,
	RB_INST_WAVE_RAMP_DOWN,
	RB_INST_WAVE_RAMP_UP,

	// CONFIG SELECT
	RB_CONFIG_IO_DEVICES,
	RB_CONFIG_LAYOUT,
	RB_CONFIG_MISCELLANEOUS,
	RB_CONFIG_MIDI_INPUT,

	// CONFIG AUDIO

	// SOUND BUFFER SIZE
	RB_CONFIG_SBS_512,
	RB_CONFIG_SBS_1024,
	RB_CONFIG_SBS_2048,
	RB_CONFIG_SBS_4096,

	// SOUND BIT DEPTH
	RB_CONFIG_AUDIO_16BIT,
	RB_CONFIG_AUDIO_24BIT,

	// SOUND FREQUENCY
	RB_CONFIG_AUDIO_44KHZ,
	RB_CONFIG_AUDIO_48KHZ,
	RB_CONFIG_AUDIO_96KHZ,

	// FREQUENCY TABLE
	RB_CONFIG_FREQ_AMIGA,
	RB_CONFIG_FREQ_LINEAR,

	// CONFIG LAYOUT

	// MOUSE SHAPE
	RB_CONFIG_MOUSE_NICE,
	RB_CONFIG_MOUSE_UGLY,
	RB_CONFIG_MOUSE_AWFUL,
	RB_CONFIG_MOUSE_USEABLE,

	// MOUSE BUSY SHAPE
	RB_CONFIG_MOUSE_BUSY_GLASS,
	RB_CONFIG_MOUSE_BUSY_CLOCK,

	// SCOPE STYLE
	RB_CONFIG_SCOPE_NORMAL,
	RB_CONFIG_SCOPE_LINED,

	// PATTERN CHANNELS
	RB_CONFIG_MAXCHAN_4,
	RB_CONFIG_MAXCHAN_6,
	RB_CONFIG_MAXCHAN_8,
	RB_CONFIG_MAXCHAN_12,

	// PATTERN FONT
	RB_CONFIG_FONT_CAPITALS,
	RB_CONFIG_FONT_LOWERCASE,
	RB_CONFIG_FONT_FUTURE,
	RB_CONFIG_FONT_BOLD,

	// PALETTE ENTRIES
	RB_CONFIG_PAL_PATTERNTEXT,
	RB_CONFIG_PAL_BLOCKMARK,
	RB_CONFIG_PAL_TEXTONBLOCK,
	RB_CONFIG_PAL_MOUSE,
	RB_CONFIG_PAL_DESKTOP,
	RB_CONFIG_PAL_BUTTONS,

	// PALETTE PRESETS
	RB_CONFIG_PAL_ARCTIC,
	RB_CONFIG_PAL_LITHE_DARK,
	RB_CONFIG_PAL_AURORA_BOREALIS,
	RB_CONFIG_PAL_ROSE,
	RB_CONFIG_PAL_BLUES,
	RB_CONFIG_PAL_SPACE_PIGS,
	RB_CONFIG_PAL_GOLD,
	RB_CONFIG_PAL_VIOLENT,
	RB_CONFIG_PAL_HEAVY_METAL,
	RB_CONFIG_PAL_WHY_COLORS,
	RB_CONFIG_PAL_JUNGLE,
	RB_CONFIG_PAL_USER_DEFINED,

	// FILE SORTING
	RB_CONFIG_FILESORT_EXT,
	RB_CONFIG_FILESORT_NAME,

	// WINDOW SIZE
	RB_CONFIG_WIN_SIZE_AUTO,
	RB_CONFIG_WIN_SIZE_1X,
	RB_CONFIG_WIN_SIZE_3X,
	RB_CONFIG_WIN_SIZE_2X,
	RB_CONFIG_WIN_SIZE_4X,

	// DISK OP
	RB_DISKOP_MODULE,
	RB_DISKOP_INSTR,
	RB_DISKOP_SAMPLE,
	RB_DISKOP_PATTERN,
	RB_DISKOP_TRACK,

	RB_DISKOP_MOD_SAVEAS_MOD,
	RB_DISKOP_MOD_SAVEAS_XM,
	RB_DISKOP_MOD_SAVEAS_WAV,
	RB_DISKOP_INS_SAVEAS_XI,
	RB_DISKOP_SMP_SAVEAS_RAW,
	RB_DISKOP_SMP_SAVEAS_IFF,
	RB_DISKOP_SMP_SAVEAS_WAV,
	RB_DISKOP_PAT_SAVEAS_XP,
	RB_DISKOP_TRK_SAVEAS_XT,

	RB_WAV_RENDER_BITDEPTH16,
	RB_WAV_RENDER_BITDEPTH32,

	NUM_RADIOBUTTONS,

	// groups (must be *after* NUM_RADIOBUTTONS)

	RB_GROUP_HELP,

	RB_GROUP_NIBBLES_PLAYERS,
	RB_GROUP_NIBBLES_DIFFICULTY,

	RB_GROUP_SAMPLE_LOOP,
	RB_GROUP_SAMPLE_DEPTH,
	RB_GROUP_INST_WAVEFORM,

	RB_GROUP_CONFIG_SELECT,
	RB_GROUP_CONFIG_SOUND_BUFF_SIZE,
	RB_GROUP_CONFIG_AUDIO_BIT_DEPTH,
	RB_GROUP_CONFIG_AUDIO_FREQ,
	RB_GROUP_CONFIG_FREQ_TABLE,

	RB_GROUP_CONFIG_MOUSE,
	RB_GROUP_CONFIG_MOUSE_BUSY,
	RB_GROUP_CONFIG_SCOPE,
	RB_GROUP_CONFIG_PATTERN_CHANS,
	RB_GROUP_CONFIG_FONT,
	RB_GROUP_CONFIG_PAL_ENTRIES,
	RB_GROUP_CONFIG_PAL_PRESET,

	RB_GROUP_CONFIG_FILESORT,
	RB_GROUP_CONFIG_WIN_SIZE,

	RB_GROUP_DISKOP_ITEM,

	RB_GROUP_DISKOP_MOD_SAVEAS,
	RB_GROUP_DISKOP_INS_SAVEAS,
	RB_GROUP_DISKOP_SMP_SAVEAS,
	RB_GROUP_DISKOP_PAT_SAVEAS,
	RB_GROUP_DISKOP_TRK_SAVEAS,

	RB_GROUP_WAV_RENDER_BITDEPTH,
};

enum
{
	RADIOBUTTON_UNCHECKED = 0,
	RADIOBUTTON_CHECKED = 1,
	RADIOBUTTON_PRESSED = 2
};

#define RADIOBUTTON_W 11
#define RADIOBUTTON_H 11
#define RADIOBUTTON_STATES 3

typedef struct radioButton_t // DO NOT TOUCH!
{
	uint16_t x, y, clickAreaWidth;
	uint16_t group;
	void (*callbackFunc)(void);

	uint8_t state;
	bool visible;
} radioButton_t;

void drawRadioButton(uint16_t radioButtonID);
void showRadioButton(uint16_t radioButtonID);
void hideRadioButton(uint16_t radioButtonID);
void checkRadioButton(uint16_t radioButtonID);
void uncheckRadioButtonGroup(uint16_t radioButtonGroup);
void showRadioButtonGroup(uint16_t radioButtonGroup);
void hideRadioButtonGroup(uint16_t radioButtonGroup);
void handleRadioButtonsWhileMouseDown(void);
bool testRadioButtonMouseDown(void);
void testRadioButtonMouseRelease(void);
