import os
import subprocess
from subprocess import PIPE, Popen
import re
import sys
import shutil

class SystemInfo:
    systemVersion = None
    systemArch = None
    supported = False
    problem = None
    supportedArchs = ['x86', 'x86_64']
    
    def __init__(self, version=8.10):
        self.version = version#8.10
        
        
    def getSystemVersion(self):
        """
        Get system System Version such as 8.10, etc.
        and returns it as a float
        """
        p1 = Popen(['lsb_release', '-r'], stdout=PIPE)
        p = p1.communicate()[0]
        try:
            sysVer = p.strip()
            tokens = sysVer.split("\t")
        except AttributeError:
            print >> sys.stderr, 'ERROR: please install lsb-release'
            sys.exit()
        sysVer = tokens[-1].lower()
        
        sysVer = float(sysVer)
        self.systemVersion = sysVer


    def getSystemArch(self):
        """
        Detect whether the architecture is x86/ppc/amd64 
        """
        arch = os.uname()[-1]
        if arch in ('ppc', 'ppc64'):
            arch = 'powerpc'
        elif arch =='x86_64':
            arch = 'x86_64'
        elif arch in ('i386','i686','i586','k7'):
            arch = 'x86'
        self.systemArch = arch
    
    def isSupported(self):
        if self.systemVersion < self.version:#older than, say, 8.10
            self.supported = False
            #translators: "%.02f" is a floating point number, do not translate it
            self.problem = 'Ubuntu %.02f is not supported by EnvyNG' % (self.systemVersion)
        
        elif self.systemArch not in selfsupportedArchs:
            self.supported = False
            #translators: "%s" is a string, do not translate it
            self.problem = 'Ubuntu %s is not supported by EnvyNG' % (self.systemArch)
        
        else:
            self.supported = True
    
    def hasXenKernel(self):
        config = os.popen('grep _XEN /boot/config-$(uname -r) | grep =y')
        hasXen = len(config.readlines()) > 0
        
        return hasXen





class OsUtils:
    def isStr(self, elem):
        return isinstance(elem, type('')) or isinstance(elem, type(u''))
    
    def isLst(self, elem):
        return isinstance(elem, type(())) or isinstance(elem, type([]))
    
    def splitList(self, files, action):
        '''
        method used by removeDirs, copyFiles, etc.
        to execute a command.
        It supports UNIX filename expansion therefore:
        "/home/alberto/*finalpart" will be expanded
        
        Remove
        1) 'toremove'
        2) ['toremove1', 'toremove2', 'toremove3']
        
        Copy
        1) [['src1', 'dst1'], ['src2', 'dst2']]
        '''
        
        fileslist = []
        if self.isStr(files) == True:#if it is a string
            fileslist.append(files)
        else:#if it is a list, tuple, etc.
            for elem in files:
                fileslist.append(elem)
        
        if action == 'rm':
            for file in fileslist:
                '''
                explanation:
                ['toremove1', 'toremove2', 'toremove3']
                file = 'toremove1'
                '''
                myfile = glob.glob(file)
                for rmfile in myfile:
                    try:
                        self.command(rmfile)
                    except:
                        pass
        
        elif action == 'cp':#used for copy* and move*
            for file in fileslist:
                if len(file) % 2 != 0:
                    print file
                    raise OSError, 'incomplete command arguments'
                else:
                    source = glob.glob(file[0])
                    destination = glob.glob(file[1])
                    '''
                    at this point everything is a list
                    because of glob
                    
                    NOTE1: glob checks the existence of a file or path
                    therefore if such file or path does not exist we
                    set dst to file[1]
                    If source does not exist the program will fail
                    
                    NOTE2: obviously only 1 destination is admitted
                    '''
                    if len(destination) > 1:
                        raise OSError, 'There can\'t be more than one destination'
                        sys.exit()
                    else:
                        if len(destination) != 0:#destination is an existing path or file
                            dst = destination[0]
                        else:
                            dst = file[1]#destination is not an existing path or file
                    
                    sources = []
                    
                    if len(source) > 1:#more than one source thanks to filename expansion
                        for subsource in source:
                            sources.append(subsource)
                        
                    else:#only one source despite filename expansion
                        if len(source) != 0:#source is an existing path or file
                            #src = source[0]
                            sources.append(source[0])
                        else:
                            raise OSError, 'No existing source file or path found'
                            sys.exit()
                    
                    for src in sources:#execute the command
                        try:
                            self.command(src, dst)
                        except OSError, e:
                            print e
                            pass
    
    def removeDirs(self, files):#pass noverbose
        '''
        Removes dirs recursively
        USAGE:
            * pass the path to the dir or a list of paths
            e.g. removeDirs([dir1, dir2, etc.])
        '''
        self.command = shutil.rmtree
        self.splitList(files, 'rm')

    def removeFiles(self, files):
        '''
        Removes files
        USAGE:
            * pass the path to the file or a list of files
            e.g. removeDirs([file1, file2, etc.])
        '''
        self.command = os.remove
        self.splitList(files, 'rm')
        
    def copyDirs(self, files):
        '''
        Copy dirs recursively
        USAGE:
            * pass a list containing one or more lists of 2 files [src, dst]
            [['/home/username/hello', '/home/username/hello1'], [..., ...] ]
        '''
        '''
        the destination must not already exist therefore, if it does,
        we make sure that the destination is a new dir with the same
        name as the source.
        e.g. let's suppose we need to copy '/home/username/hello' to
        '/home/username/hellos' (they are both dirs)
        hellos always exists therefore the destination will be:
        '/home/username/hellos/hello'
        
        HOW TO CALL IT:
        copyDirs([['/home/username/hello', '/home/username/hellos'], [..., ...] ])
        '''
        for file in files:
            if os.path.isdir(file[1]):
                file[1] = file[1] + '/' + file[0].split('/')[-1]
        self.command = shutil.copytree
        self.splitList(files, 'cp')
        
    def copyFiles(self, files):
        '''
        Copy files
        USAGE:
            * pass a list containing one or more lists of 2 files [src, dst]
            [['/home/username/hello', '/home/username/hello1'], [..., ...] ]
            or simply:
            ['/home/username/hello', '/home/username/hello1']
        '''
        self.command = shutil.copy
        self.splitList(files, 'cp')
        
    def moveFiles(self, files):
        '''
        Move files
        USAGE:
            * pass a list containing one or more lists of 2 files [src, dst]
            [['/home/username/hello', '/home/username/hello1'], [..., ...] ]
            or simply:
            ['/home/username/hello', '/home/username/hello1']
        '''
        self.command = shutil.move
        self.splitList(files, 'cp')
    
    def cmdOutput(self, command, verbose=None):
        '''
        USAGE: 
        * the command must be a string
        * you can pass 'noverbose' in order to make sure that stderr > /dev/null
        '''
        from subprocess import STDOUT
        if verbose == 'noverbose':
            NULL = open('/dev/null', 'w')
            comnd = Popen(command, shell=True, stdout=PIPE, stderr=NULL)
            sts = os.waitpid(comnd.pid, 0)
            NULL.close()
        else:
            comnd = Popen(command + ' 2>&1', shell=True)# stdout=PIPE)
            sts = os.waitpid(comnd.pid, 0)

    def stopDm(self):
        hasX = len(os.popen('ps aux | grep X').readlines()) > 0
        hasGdm = len(os.popen('ps aux | grep /usr/sbin/gdm').readlines()) > 0
        hasKdm = len(os.popen('ps aux | grep /usr/sbin/kdm').readlines()) > 0
        
        if hasX:#X is in use
            if hasGdm:
                print >> sys.stderr, 'Stopping GDM...'
                self.cmdOutput('sudo /etc/init.d/gdm stop', 'noverbose')
            elif hasKdm:
                print >> sys.stderr, 'Stopping KDM...'
                self.cmdOutput('sudo /etc/init.d/kdm stop', 'noverbose')
            else:
                print >> sys.stderr, 'No known desktop manager was found.\nPlease stop the xserver manually'
                sys.exit()

    def restartSystem(self):
        self.cmdOutput('sudo reboot')
        sys.exit()

    def restartX(self):
        try:
            dm = open('/etc/X11/default-display-manager', 'r')
            whichDm = dm.read()
            gdm = 'gdm' in whichDm
            kdm = 'kdm' in whichDm
            dm.close()
        except (IOError, OSError):
            gdm = False
            kdm = False

        if gdm:
            print >> sys.stderr, 'GDM detected'
            self.cmdOutput('sudo /etc/init.d/gdm restart', 'noverbose')
        elif kdm:
            print >> sys.stderr, 'KDM detected'
            self.cmdOutput('sudo /etc/init.d/kdm restart', 'noverbose')
        else:
            print >> sys.stderr, 'No known desktop manager was found.\nPlease restart the xserver manually'
        sys.exit()

    
    def depMod(self):
        self.cmdOutput('sudo depmod -ae', 'noverbose')

