import os
import thread

import detection
import packagemanager
from packagemanager import HeadersException
import network
import ui
import system
import xorg

class LockException(Exception):
    '''
    Raise if the lock can't be taken
    '''
    pass

class HeadersException(Exception):
    '''
    Raise if the lock can't be taken
    '''
    pass

class PackageException(Exception):
    '''
    Raise if the lock can't be taken
    '''
    pass

class Abstraction:
    def __init__(self, widget=None, text=None):
        self.strings = ui.AbstractUI()
        self.isText = text
        self.widget = widget
        self.hardware = detection.HardwareDetection()
        self.osControl = system.OsUtils()
        self.ids = self.hardware.cards
        self.xorg = xorg.XorgSetup()
        self.driverDetails = self.hardware.selectDriver()
        
        '''
        self.driverDetails[driver][it]['name']
        self.driverDetails[driver][it]['compatible']
        self.driverDetails[driver][it]['recommended']
        '''
        self.uiDetails = self.driverDetails
        
        self.refreshPkg()
#        self.pkg = packagemanager.PkgManager(widget, self.isText)
        
        for driver in self.driverDetails:
            for item in self.driverDetails[driver]:
                drv = self.driverDetails[driver][item]['name']
                installed, candidate = self.pkg.getPkgInfo(drv)
                #remove epoch
                if installed and ':' in installed:
                    installed = installed[installed.find(':')+1:]
                if candidate and ':' in candidate:
                    candidate = candidate[candidate.find(':')+1:]
                
                self.uiDetails[driver][item]['installed'], self.uiDetails[driver][item]['candidate'] = installed, candidate
        
        '''
        The different UIs have access to self.uiDetails which may look like the following:
        
            {
             'fglrx': {
                       0: {
                           'compatible': False,
                           'recommended': False,
                           'name': 'xorg-driver-fglrx',
                           'candidate': '8.512-0ubuntu1',
                           'installed': None
                           }
                       },
             'nvidia': {
                        0: {
                            'compatible': True,
                            'recommended': False,
                            'name': 'nvidia-glx-177',
                            'candidate': '177.13-0ubuntu8',
                            'installed': None
                            },
                        1: {
                            'compatible': True,
                            'recommended': True,
                            'name': 'nvidia-glx-173',
                            'candidate': '173.14.12-0ubuntu3',
                            'installed': '173.14.12-0ubuntu3'
                            },
                        2: {
                            'compatible': True,
                            'recommended': False,
                            'name': 'nvidia-glx-96',
                            'candidate': '96.43.05-0ubuntu8',
                            'installed': None
                            },
                        3: {
                            'compatible': False,
                            'recommended': False,
                            'name': 'nvidia-glx-71',
                            'candidate': '71.86.04-0ubuntu8',
                            'installed': None
                            }
                        }
            }
        '''
    
    def refreshPkg(self):
        self.pkg = packagemanager.PkgManager(self.widget, self.isText)
    
    def install(self, package):
        '''
        use self.progressBar
        '''
        if not self.pkg.isLockAvailable():
            raise LockException(self.strings.string_apt_in_use)
        
        try:
            b = package + ' '
        except TypeError:
            package = package[0]
            
        '''
        Make sure that any other driver is uninstalled
        '''
#        self.uninstallAll()
        
        packages = [package]
        
        
        if 'nvidia' in package:
            '''
            Reinstall xserver-xorg-core libgl1-mesa-glx since the
            NVIDIA installer might have overwritten their files
            '''
#            self.pkg.fixNvidiaInstaller(self.widget)
            pass
        
        '''
        Make sure that the kernel headers for the kernel in use
        are installed.
        '''
        try:
            headers = self.pkg.checkHeaders()
            if not headers:
                headers = self.pkg.getHeadersName()
                metaHeaders = self.pkg.getHeadersMetaName()
                packages = [headers, metaHeaders] + packages
                if not self.pkg.isDownloadable(headers):
                    raise HeadersException(self.strings.string_headers_missing)
        except packagemanager.HeadersException:
            raise HeadersException(self.strings.string_headers_missing)
        
        self.pkg.install(packages, self.widget)
        
        self.osControl.depMod()
#        return self.pkg.install(packages, self.widget)
    
    def uninstall(self, package):
        '''
        use self.progressBar
        '''
#        if not self.pkg.isLockAvailable():
#            raise LockException(self.strings.string_apt_in_use)
        
        packages = [package]
        
        '''
        Make sure that the various fglrx-kernel-source and
        nvidia-VER-kernel-source are not installed.
        '''
        kernelSource = None
        dependencies = self.pkg.getDependencies(package)
        if dependencies:
            for dependency in dependencies:
                if 'kernel-source' in dependency:
                    kernelSource = dependency
        
        if kernelSource:
            packages.append(kernelSource)
        
#        if not self.pkg.uninstall(packages, self.widget):
#            raise PackageException
        self.pkg.uninstall(packages, self.widget)
        
        
        clean = True
        if clean == None:
            '''
            Set up X here
            '''
            pass
    
    def uninstallDriverType(self, driver):
        '''
        driver is either "nvidia" or "fglrx"
        '''
        packages = []
        
        #print driver
        
        try:
            b = self.driverDetails[driver]
        except KeyError:
            driver = driver[0]
        
        for item in self.driverDetails[driver]:
            drv = self.driverDetails[driver][item]['name']
            packages.append(drv)
#            dependencies = self.pkg.getDependencies(drv)
#            if dependencies:
#                for dependency in dependencies:
#                    if 'kernel-source' in dependency:
#                        packages.append(dependency)
        #print packages
        
        for package in packages:
            self.uninstall(package)
    
    def uninstallAll(self):
        '''
        use self.progressBar
        '''
        if not self.pkg.isLockAvailable():
            raise LockException(self.strings.string_apt_in_use)
        
        packages = []
        
        for driver in self.driverDetails:
            for item in self.driverDetails[driver]:
                drv = self.driverDetails[driver][item]['name']
                packages.append(drv)
                dependencies = self.pkg.getDependencies(drv)
                if dependencies:
                    for dependency in dependencies:
                        if 'kernel-source' in dependency:
                            packages.append(dependency)
        
        
        self.pkg.uninstall(packages, self.widget)
        
    
    def download(self, package, directory, updatestatus, callback):
        '''
        use self.progressBar
        
        NOTE: if text is True multithreading won't be used
        
        '''
        self.net = network.Network()
        if self.net.isConnected():
            files = []
            urls = []
            
            packages = []
            
            
            packages.append(package)
            dependencies = self.pkg.getDependencies(package)
            #print dependencies
            if dependencies:
                packages += dependencies
#                for dependency in dependencies:
#                    if 'kernel-source' in dependency:
#                        packages.append(dependency)
            
            for package in packages:
                url = self.pkg.getUrl(package).strip()
                urls.append(url)
                
                file = url[url.rfind('/')+1:].strip()
                files.append(file)#[file] = url
            
            
            
#            for file in files:
#                print 'File:', file, 'url:', files[file], '\n'
            
            if not self.isText:
                lock = thread.allocate_lock()
                lock.acquire()
    #            try:
                t=thread.start_new_thread(self.net.download, (files, urls, directory, updatestatus, callback))
                
            else:
                self.net.download(files, urls, directory, updatestatus, callback)
            return True
#            except IOError:
#                raise IOError(self.strings.string_download_error)
    def setupX(self, operation, package=None):
        '''
        operation can be:
            * install
            * remove
        package is none only when the EnvyNG is launched with --uninstall-all
        '''
        #print 'ABSTRACTION: setting up X with', operation, str(package)
        ids = self.hardware.driversForCards
        self.xorg.configureX(operation, package=package, ids=ids)
    
    def restartX(self):
        self.osControl.restartX()
        
    def restartSystem(self):
        self.osControl.restartSystem()
    
if __name__ == '__main__':
    a = Abstraction()
    print a.uiDetails
