/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.vmconversion;

import com.amazon.aes.webservices.client.vmconversion.AsciiProgressBar;
import com.amazon.aes.webservices.client.vmconversion.ImageFormatVerifier;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversion.VerifierFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DiskImageVerifier {
    static final long ONE_GIG = 0x40000000L;
    static final int READ_CHUNK_SIZE = 65536;
    File diskImage;
    PrintStream out;

    public DiskImageVerifier(File diskImage_) {
        this(diskImage_, System.out);
    }

    public DiskImageVerifier(File diskImage_, PrintStream out_) {
        this.diskImage = diskImage_;
        this.out = out_;
    }

    private String humanReadableSize(long size) {
        return String.format("%d bytes (%.02f GiB)", size, (double)size / 1.073741824E9);
    }

    public void validateFileLength(long expectedSize) throws VerificationException {
        long actualSize = this.diskImage.length();
        this.out.format("Disk image size: %s\n", this.humanReadableSize(actualSize));
        if (actualSize != expectedSize) {
            throw new VerificationException("The file size of " + this.diskImage + " is " + actualSize + ".  The expected file size for this task is " + expectedSize);
        }
    }

    protected boolean equalStrings(String s1, String s2) {
        return String.CASE_INSENSITIVE_ORDER.compare(s1, s2) == 0;
    }

    public void verifyChecksum(String expectedChecksum) throws VerificationException {
        String actualChecksum;
        try {
            actualChecksum = this.calculateImageChecksum(false);
        }
        catch (IOException e) {
            throw new VerificationException("Unable to read from " + this.diskImage + " to verify its checksum: " + e.getMessage());
        }
        this.out.println("Disk image checksum: " + actualChecksum);
        if (!this.equalStrings(expectedChecksum, actualChecksum)) {
            throw new VerificationException("The SHA1 checksum of " + this.diskImage + " is " + actualChecksum + ".  The expected checksum for this task is " + expectedChecksum);
        }
    }

    public void validateImageFormat(String formatType, int ebsGigs) throws VerificationException {
        VerifierFactory factory = new VerifierFactory(formatType);
        ImageFormatVerifier verifier = factory.getVerifier(this.diskImage);
        long actualConvertedSize = verifier.convertedSize();
        this.out.format("Disk image format: %s\n", verifier.descriptiveFormatName());
        this.out.format("Converted volume size: %s\n", this.humanReadableSize(actualConvertedSize));
        long expectedConvertedSize = (long)ebsGigs * 0x40000000L;
        this.out.format("Requested EBS volume size: %s\n", this.humanReadableSize(expectedConvertedSize));
        if (actualConvertedSize > expectedConvertedSize) {
            throw new VerificationException("You don't have a large enough volume for this disk image.\nThis file will expand to " + actualConvertedSize + " bytes, yet your " + ebsGigs + " GiB EBS volume can only store " + expectedConvertedSize + " bytes.");
        }
    }

    public String calculateImageChecksum(boolean noStatus) throws IOException {
        MessageDigest sha1;
        FileInputStream in = new FileInputStream(this.diskImage);
        byte[] buf = new byte[65536];
        int actualread = 0;
        try {
            sha1 = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InternalException("Internal exception: unable to locate SHA1 library.");
        }
        AsciiProgressBar progress = new AsciiProgressBar(this.diskImage.length(), this.out);
        if (!noStatus) {
            this.out.println("Calculating image checksum, this may take several minutes.");
            progress.preamble();
        }
        while ((actualread = in.read(buf, 0, 65536)) != -1) {
            if (!noStatus) {
                progress.updateRelative(actualread);
            }
            sha1.update(buf, 0, actualread);
        }
        if (!noStatus) {
            progress.postamble();
        }
        return this.digestHexString(sha1);
    }

    protected String digestHexString(MessageDigest digest) {
        StringWriter sw = new StringWriter(40);
        PrintWriter buf = new PrintWriter(sw);
        for (byte b : digest.digest()) {
            buf.printf("%02x", 0xFF & b);
        }
        buf.flush();
        return sw.toString();
    }
}

