/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.BlockDeviceMappingAttribute;
import com.amazon.aes.webservices.client.InvalidMapping;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazonaws.ec2.doc._2009_04_04.PlacementRequestType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import sun.misc.BASE64Encoder;

public class RunInstances
extends BaseCmd {
    private static final String[] RAMDISK_DESC = new String[]{"Specifies the ramdisk-ID of the ramdisk to launch instances with."};
    private static final String RAMDISK_ARG = "RAMDISK-ID";
    private static final String[] KERNEL_DESC = new String[]{"Specifies the kernel-ID of the kernel to launch instances with."};
    private static final String KERNEL_ARG = "KERNEL-ID";
    private static final String[] AVAILABILITY_ZONE_DESC = new String[]{"Specifies the availability zone to launch the instances in. Run the", "'ec2-describe-availability-zones' command for a list of values, and", "see the latest Developer's Guide for their meanings."};
    private static final String AVAILABILITY_ZONE_ARG = "ZONE";
    private static final String PROFILE_ARG = "PROFILE";
    private static final String[] PROFILE_DESC = new String[]{"Specifies the operating-system profile to launch instances with.", "Please see latest Developer's Guide for acceptable profile values."};
    private static final String[] INSTANCE_TYPE_DESC = new String[]{"Specifies the type of instance to be launched. Refer to the latest", "Developer's Guide for valid values."};
    private static final String INSTANCE_TYPE_ARG = "TYPE";
    private static final String[] ADDRESSING_DESC = new String[]{"Specifies the addressing type to use for the instances. Refer to the", "latest Developer's Guide for valid values."};
    private static final String ADDRESSING_ARG = "ADDRESSING";
    private static final String[] USER_DATA_FILE_DESC = new String[]{"Specifies the file containing user data to be made available to the", "instances in this reservation."};
    private static final String USER_DATA_FILE_ARG = "DATA-FILE";
    private static final String[] USER_DATA_DESC = new String[]{"Specifies the user data to be made available to the instances in this", "reservation."};
    private static final String USER_DATA_ARG = "DATA";
    private static final String[] KEY_ID_DESC = new String[]{"Specifies the key pair to use when launching this instance."};
    private static final String KEY_ID_ARG = "KEY-PAIR";
    private static final String[] GROUP_DESC = new String[]{"Specifies the security group (or groups if specified multiple times)", "within which the instance(s) should be run. Determines the ingress", "firewall rules that will be applied to the launched instances.", "Defaults to the user's default group if not supplied."};
    private static final String GROUP_ARG = "GROUP [--group GROUP...]";
    private static final String[] INSTANCE_COUNT_DESC = new String[]{"The number of instances to attempt to launch. May be specified as a", "single integer or as a range (min-max). This specifies the minumum", "and maximum number of instances to attempt to launch. If a single", "integer is specified min and max are both set to that value."};
    private static final String INSTANCE_COUNT_ARG = "MIN[-MAX]";
    private static final String[] BLOCK_DEVICE_MAPPING_DESC = new String[]{"Specifies one or more block-device-mappings to launch instances with.", "Please see latest Developer's Guide for acceptable mappings."};
    private static final String MONITORING_DESC = "Enables monitoring of the specified instances";
    private static final String BLOCK_DEVICE_MAPPING_ARG = "MAPPING";
    private boolean monitoring = false;

    public RunInstances(String[] args) {
        super("ec2run", "ec2-run-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected void parseOpts(String[] args) {
        super.parseOpts(args);
        if (this.cmd == null) {
            return;
        }
        this.monitoring = this.cmd.hasOption("monitoring");
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"ami");
        OptionBuilder.hasArgs();
        result.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"block-device-mapping");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(BLOCK_DEVICE_MAPPING_DESC));
        OptionBuilder.withArgName((String)BLOCK_DEVICE_MAPPING_ARG);
        result.addOption(OptionBuilder.create((String)"B"));
        OptionBuilder.withLongOpt((String)"instance-count");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(INSTANCE_COUNT_DESC));
        OptionBuilder.withArgName((String)INSTANCE_COUNT_ARG);
        result.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"key");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(KEY_ID_DESC));
        OptionBuilder.withArgName((String)KEY_ID_ARG);
        result.addOption(OptionBuilder.create((String)"k"));
        OptionBuilder.withLongOpt((String)"group");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(GROUP_DESC));
        OptionBuilder.withArgName((String)GROUP_ARG);
        result.addOption(OptionBuilder.create((String)"g"));
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.hasArgs();
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"user-data");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(USER_DATA_DESC));
        OptionBuilder.withArgName((String)USER_DATA_ARG);
        result.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"user-data-file");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(USER_DATA_FILE_DESC));
        OptionBuilder.withArgName((String)USER_DATA_FILE_ARG);
        result.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"addressing");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(ADDRESSING_DESC));
        OptionBuilder.withArgName((String)ADDRESSING_ARG);
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"instance-type");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(INSTANCE_TYPE_DESC));
        OptionBuilder.withArgName((String)INSTANCE_TYPE_ARG);
        result.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"availability-zone");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(AVAILABILITY_ZONE_DESC));
        OptionBuilder.withArgName((String)AVAILABILITY_ZONE_ARG);
        result.addOption(OptionBuilder.create((String)"z"));
        OptionBuilder.withLongOpt((String)"kernel");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(KERNEL_DESC));
        OptionBuilder.withArgName((String)KERNEL_ARG);
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"ramdisk");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)RunInstances.joinDescription(RAMDISK_DESC));
        OptionBuilder.withArgName((String)RAMDISK_ARG);
        result.addOption(OptionBuilder.create());
        result.addOption("m", "monitoring", false, MONITORING_DESC);
        return result;
    }

    protected String getOptionString() {
        return "AMI [SPECIFIC OPTIONS]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Launch a number of instances of a specified AMI.");
        System.out.println("     The AMI parameter is the AMI ID of the AMI to launch.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("block-device-mapping");
        this.printOption("instance-count");
        this.printOption("group");
        this.printOption("key");
        this.printOption("user-data");
        this.printOption("user-data-file");
        this.printOption("addressing");
        this.printOption("instance-type");
        this.printOption("availability-zone");
        this.printOption("kernel");
        this.printOption("ramdisk");
        this.printOption("monitoring");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String props = null;
        if (this.isOptionSet("properties")) {
            props = this.getOptionValue("properties");
        }
        String keyId = null;
        if (this.isOptionSet("key")) {
            keyId = this.getOptionValue("key");
        }
        String userData = null;
        if (this.isOptionSet("user-data") && this.isOptionSet("user-data-file")) {
            throw new InvalidArgumentCombination("You may not specify both user data on the command line (-d) and a file containing user data (-f).");
        }
        if (this.isOptionSet("user-data")) {
            userData = this.getUserData(this.getOptionValue("user-data"));
        } else if (this.isOptionSet("user-data-file")) {
            userData = this.getUserDataFile(this.getOptionValue("user-data-file"));
        }
        PlacementRequestType placement = null;
        if (this.isOptionSet("availability-zone")) {
            placement = new PlacementRequestType();
            placement.setAvailabilityZone(this.getOptionValue("availability-zone"));
        }
        String addressing = this.getOptionValue("addressing");
        this.assertNonOptionSet("AMI");
        this.warnIfTooManyNonOptions();
        String imageId = this.getNonOptions()[0];
        int[] range = this.parseRange(this.getOptionValue("instance-count", "1"));
        List<String> groupIds = Arrays.asList(this.getOptionValues("group"));
        String instanceType = this.getOptionValue("instance-type");
        String kernel = null;
        if (this.isOptionSet("kernel")) {
            kernel = this.getOptionValue("kernel");
        }
        String ramdisk = null;
        if (this.isOptionSet("ramdisk")) {
            ramdisk = this.getOptionValue("ramdisk");
        }
        BlockDeviceMappingAttribute mapping = this.getBlockDeviceMappingAttribute(jec2);
        RequestResultPair rsp = jec2.runInstances(imageId, range[0], range[1], groupIds, props, keyId, userData, addressing, instanceType, placement, kernel, ramdisk, mapping, Boolean.valueOf(this.monitoring));
        out.output(System.out, (ReservationDescription)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected BlockDeviceMappingAttribute getBlockDeviceMappingAttribute(Jec2 jec2) throws InvalidArgument {
        BlockDeviceMappingAttribute mappings = null;
        if (this.isOptionSet("block-device-mapping")) {
            String[] mappingsStrings = this.getOptionValues("block-device-mapping");
            mappings = new BlockDeviceMappingAttribute();
            try {
                for (String mappingsString : mappingsStrings) {
                    mappings.add(mappingsString);
                }
            }
            catch (InvalidMapping e) {
                throw new InvalidArgument("block-device-mapping", mappingsStrings.toString());
            }
        }
        return mappings;
    }

    private String getUserDataFile(String str) throws IOException {
        String base64 = null;
        File file = new File(str);
        if (file.canRead() && file.isFile()) {
            try {
                int content_length = (int)file.length();
                FileInputStream ifs = new FileInputStream(file);
                byte[] contents = new byte[content_length];
                int nread = ifs.read(contents);
                assert (nread == content_length);
                base64 = new BASE64Encoder().encode(contents);
            }
            catch (FileNotFoundException nfe) {
                System.err.println("File not found? This is of course impossible.\n" + nfe.toString());
                throw nfe;
            }
        } else {
            throw new InvalidArgument("user-data-file", str);
        }
        return base64.replaceAll("\\s", "");
    }

    private String getUserData(String str) {
        String base64 = new BASE64Encoder().encodeBuffer(str.getBytes());
        return base64.replaceAll("\\s", "");
    }

    public static void main(String[] args) {
        new RunInstances(args).invoke();
    }
}

