/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeGroups
extends BaseCmd {
    public DescribeGroups(String[] args) {
        super("ec2dgrp", "ec2-describe-group");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "[GROUP [GROUP [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe security groups you've created (or have access to)");
        System.out.println("     The GROUP parameter specifies the group(s) to be described.");
        System.out.println("     If unspecified all groups visible to you will be returned.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] groupIds = this.getNonOptions();
        RequestResultPair rsp = jec2.describeSecurityGroups(groupIds);
        for (SecurityGroupDescription g : (List)rsp.getResponse()) {
            out.output(System.out, g);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeGroups(args).invoke();
    }
}

