/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIVAR1.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	The variables:
		ini -> opened INI file for writing
		appname -> modified application name
		apppath -> modified search path for system INI files
		nlwritten -> the last written line was terminated by '\n'

	They are put together into the same file, because they are
	always used together.

ob(ject): cfgi_fnam
ty: L
su(bsystem): inifile
sy: char *cfgi_fnam
sh(ort description): real name of INI file currently opened for writing
lo: When the write process is finished successfully the temporary file
	\tok{cfgi_ini} is renamed to \tok{cfgi_fnam)
va: != NULL: if \tok{cfgi_ini} != NULL
	\item invalid: if \tok{cfgi_ini} == NULL
re(lated to): cfgi_ini
fi(le): cfgivar1.c
in(itialized by): cfgCreateINI cfgi_wrOpen cfgEraseSection cfgNewSection

ob(ject): cfgi_apppath
ty: L
su(bsystem): inifile
sy: char *cfgi_apppath
sh(ort description): User-specified path where the system INI files are located
va: NULL: use system default: appPathEx()\..\ETC or appPathEx()\
	\item else: use that one
re(lated to): cfgi_appname \subsys{appName}
fi(le): cfgivar1.c
in(itialized by): cfgChangePathINI

ob(ject): cfgi_string
ty: L
su(bsystem): inifile
sy: char *cfgi_string
sh(ort description): Last result of cfgi_quoteString()
lo: Latest cached string returned by cfgi_quoteString(). This string is
	automatically deallocated on next call to cfgi_quoteString() or
	whenever the INI file is closed.
va: may be NULL
re(lated to):
fi(le): cfgivar1.c
in(itialized by): cfgi_quoteString

ob(ject): cfgi_data
ty: L
su(bsystem): inifile
sy: char *cfgi_data
sh(ort description): Last result of cfgi_packData()
lo: Latest cached string returned by cfgi_packData(). This string is
	automatically deallocated on next call to cfgi_packData() or
	whenever the INI file is closed.
va: may be NULL
re(lated to):
fi(le): cfgivar1.c
in(itialized by): cfgi_packData

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIVAR1.C 1.5 2001/02/27 01:27:46 ska Exp ska $";
#endif

FILE *cfgi_ini = 0;		/* INI file for writing */
char *cfgi_fnam = 0;		/* final filename of opened INI file */
char *cfgi_appname = 0;/* name of current application and basename of
									the associated INI file */
char *cfgi_apppath = 0;/* path where to look for system INI file */
FLAG cfgi_nlwritten = 0;

char *cfgi_string = 0;	/* last result of cfgi_quoteString() */
char *cfgi_data = 0;		/* last result of cfgi_packData() */
