/* Macro to convert bytes to paragraphs */
#define topara(x) (((x) + 0xf) >> 4)
#define MAXPATH   128              /* Max length of path name */

/* Make sure the FP_SEG macro is a valid lvalue */
#ifdef FP_SEG
#undef  FP_SEG
#endif

#define FP_SEG(x)  (*(((unsigned short *)&(x))+1))

/* information about this program */
struct PSP    far *myPSP;     /* Pointer to this program's PSP */
char         *myEnv;          /* Pointer to this program's environment */
char          dta[0x30];      /* Disk transfer area */
WORD          myEnvSize;

/* These variables are used to save the DOS malloc strategy
   and UMB link state, to restore it when the program exits */
WORD    old_link, old_strat;
int     umbLink; /* This variable holds the current state of the UMB link */

/* info about the executable file */
WORD    exeHandle;              /* Handle to EXE file */
struct  ExeHeader exeHeader;    /* Header from EXE file */
int     exeType;                /* Type of executable */
DWORD   fileSize;               /* size of the file */
DWORD   prgSize;                /* size of the code within the file */
char    filename[MAXPATH];      /* Complete pathname to EXE file */
int     loadhighFlag = 0;       /* Flag - is this a 'load high' EXE file? */

/* info about the new process */
WORD    envSeg = 0;      /* New environment segment */
WORD    pspSeg;          /* New PSP segment */
struct  PSP far *newPSP; /* Pointer to the new PSP */
WORD    relocFactor;     /* Relocation factor */
WORD    imageSeg;        /* Segment where the contents of the file will be loaded */
BYTE    exitcode;        /* Exit code of the program */
BYTE    exittype;        /* Exit type of the program */
WORD    memNeeded;       /* Paragraphs needed to load the program */
WORD    memWanted;       /* Max number of paragraphs to allocate */
WORD    memSize;         /* Number of paragraphs that was really allocated */
char    newcmdline[0x80];/* New command line */
int     inUMB = 0;       /* Flag: was program successfully loaded in an UMB? */
WORD    envSize;         /* size of the environment copy */
WORD   *regionOrder;     /* contains the loading order of the UMB regions */

/* This structure will hold the new program's initial register values */
struct {
   WORD ip, cs;
   WORD sp, ss;
   WORD ax, bx, cx, dx;
   WORD ds, es;
} init;

/* structure used when searching the MCB chain */
struct freeBlock
{
   WORD   address;
   WORD   size;
};

/* "empty" FCB to use for the default FCB fields in the PSP */
struct FCB dummyFCB =  
{
  0, "        ", "   ", 0, 0
};

/* different types of executables... */
enum exeTypes {
   t_com, t_exe, t_bat
};
 
/* ...and their extensions */
char   *extensions[3] = { ".COM", ".EXE", ".BAT" };

/* characters that delimits the file name */
char   *filename_delimitors = " \t\r\n/;,+=<>|[]\"";

int     rc = 0;      /* internal status code */

/* different types of program termination, as returned by int 21h, func. 4dh */
char   *termName[4]   = { 
  "terminated normally", "aborted",
  "aborted", "terminated resident" 
};

/* This array will contain the memory blocks that the new program can't use */
#define MAX_BLOCKS 256
size_t  allocatedBlocks = 0;
WORD    block[MAX_BLOCKS];

/* This array will contain the memory blocks that the new program can use */
WORD              availBlocks = 0;
struct freeBlock *availBlock;

size_t  newmodNameLen;
char    newModuleName[9];

/* These are the switches used by the program */
#define switchNo 7
int     sw[switchNo]; /* booleans: was the switch present? */

enum    swNames {     /* names for the switches */
  sw_noenv, sw_at, sw_help, sw_verbose, sw_mem, sw_shrink, sw_load
};

char   *swStrings[switchNo] = {   /* The strings of the switches */
 "E", "@", "?", "V", "M", "S", "L"
};

WORD    at_address = 0;          /* address given by the @ switch */
WORD    minMem = 0, maxMem = 0;  /* arguments given by the M switch */

/* UMB region info */
int     umbRegions = 0;          /* How many memory regions are there? */

struct UMBREGION {
  WORD start;      /* start of the region */
  WORD end;        /* end of the region */
  WORD minSize;    /* minimum free size, given by the L switch */
  int  access;     /* does the program have access to this region? */
} *umbRegion;

/* functions... */
int     findUMBRegions(void);
int     readSwitch(char **pc);
int     parseArgs(char far *cmdline);
void    usage(void);
char   *getEnv(char *envp, char *entry);
char   *getNextPath(char *envp, char *buf);
int     findfile(void);
void    error(int errcode);
int     tryFile(char *name);
int     copyEnvironment(char *sourceEnv);
int     checkExe(void);
int     checkCom(void);
int     alloc(void);
int     allocateMemory(void);
int     lfile(void);
int     makeDefaultFCBs(void);
int     loadFile(void);
int     loadProgram(void);
int     createClientPSP(void);
size_t  getModuleName(char *dest, char *src);
void    getnames(void);
int     allocProgMem(WORD strategy, WORD address);
int     findfreeBlock(struct freeBlock *fb);
void    calcRelocs(void);
void    markMCBs(void);
int     expandName(char *dest, char *src);
int     readEnv(WORD env_seg);
long    getnumber(char **pc);
int     allocBlock(WORD minSz, WORD maxSz, WORD region, struct freeBlock *result);
int     alloc(void);
int     initialise(void);
void    cleanup(void);

enum error_codes {
  OK, err_help, err_invalid_cmdline, 
  err_invalid_at_address, err_invalid_name, err_invalid_path, 
  err_not_found, err_invalid_file, err_loading_file, err_reloc_table,
  err_prog_mem, err_psp_create, err_open, err_dos,
  err_invalid_mem, err_bat_file, err_max_too_small, err_alloc_all,
  err_env_create, err_mcb_chain, err_alloc_env
};
