/*
 * Simple utility to capture output to a file while running a command.
 *
 * Copyright 1995-2000 Dave Dunfield
 * All rights reserved.
 *
 * Compile command: cc routput -pof
 * Licensed for personal (non-commercial) use only.
 */
#include <stdio.h>
#include <file.h>

#define	BUFSIZE	50000		/* Size of capture buffer */

char help_message[] = { "\n\
Use: rerror[/C[E]] filename command...\n\n\
Redirects error messages and program output to a file.\n\n\
If /C is NOT specified, RERROR redirects the DOS standard error device\n\
to the indicated file while the command runs.\n\n\
The /C option makes RERROR capture all TTY output via INT10-0Eh into a 50k\n\
buffer which is written to the named file after the command completes.\n\
If the command generates more than 50K of output, the remainder is lost.\n\
If /CE is specified, the output is also echoed on the console.\n\
\nCopyright 1995-2000 Dave Dunfield\n\
All rights reserved.\n" };

/* Capture buffer for "/C" operation */
unsigned bptr = 0;
unsigned char buffer[BUFSIZE];

/* Issue error message (via low-level I/O) and exit */
error(char *s)
{
	lputs(s, L_stderr);
	exit(-1);
}

main(int argc, char *argv[])
{
	int i;
	char command[256], *ptr;
	unsigned fh1, fh2;

	/* Test for filename and at least one command argument */
	if(argc < 3)
		error(help_message);

	if((*argv[1] == '/') && (toupper(argv[1][1]) == 'C')) {
		if(argc < 4)
			error(help_message);

		/* Concatinate multiple arguments into a single command line */
		ptr = stpcpy(command, argv[i = 3]);
		while(++i < argc) {
			*ptr++ = ' ';
			ptr = stpcpy(ptr, argv[i]); }

		/* Install our output handler and execute command */
		grab_int10(toupper(argv[1][2]));
		system(command);
		release_int10();

		/* Write out contents of buffer to file */
		if(!(fh1 = open(argv[2], F_WRITE)))
			error("\nERROR: Unable to open output file.\n");
		write(buffer, bptr, fh1);
		close(fh1);
		return; }

	/* Open the output file - report error if failure */
	if(!(fh1 = open(argv[1], F_WRITE)))
		abort("\nRERROR: Unable to open output file\n");

	/* Concatinate multiple arguments into a single command line */
	ptr = stpcpy(command, argv[i = 2]);
	while(++i < argc) {
		*ptr++ = ' ';
		ptr = stpcpy(ptr, argv[i]); }

	fh2 = dup(stderr.FILE_handle);		/* Make copy of stderr */
	dup2(fh1, stderr.FILE_handle);		/* Redirect stderr to file */
	system(command);					/* Execute a command */
	dup2(fh2, stderr.FILE_handle);		/* Restore original stderr file */
	close(fh1);							/* Close output file */
	close(fh2);							/* Close duplicate handle */
}

/*
 * Grab the int 10 vector & get ready for the fun
 */
grab_int10() asm
{
		MOV		AX,3510h		; Get interrupt 10
		INT		21h				; Call DOS
		MOV		CS:int10o,BX	; Save offset
		MOV		CS:int10s,ES	; Save segment
		MOV		AL,4[BP]		; Get option
		CMP		AL,'E'			; Do we ECHO
		JZ		grin1			; Yes, its OK
		MOV		BYTE PTR CS:int13,0CFh ; Replace with IRET
grin1:	MOV		AX,2510h		; Set interrupt 10
		MOV		DX,OFFSET int10	; Get offset
		INT		21h				; Set the segment
}

/*
 * Release the int10 vector
 */
release_int10() asm
{
		PUSH	DS				; Save DS
		MOV		AX,2510h		; Set interrupt 10
		MOV		DX,CS:int10o	; Get offset
		MOV		DS,CS:int10s	; Get segment
		INT		21h				; Call DOS
		POP		DS				; Restore DS
}

/*
 * Interrupt 10 handler
 */
asm {
int10:	CMP		AH,0Eh			; Write character in TTY
		JZ		int11			; Yes, do it.
		CMP		AH,0Ah			; Write character at cursor
		JZ		int11			; Yes, do it.
		CMP		AH,09h			; Write character & attribute
		JNZ		int13			; No, process normally
int11:	PUSH	BX				; Save BX
		PUSH	DS				; Save DS
		MOV		BX,CS			; Get CS
		MOV		DS,BX			; Set new DS
		MOV		BX,DGRP:_bptr	; Get input pointer
		CMP		BX,BUFSIZE		; In range?
		JAE		int12			; No, ignore
		MOV		DGRP:_buffer[BX],AL; Write character
		INC		BX				; Advance
		MOV		DGRP:_bptr,BX	; Save new pointer
int12:	POP		DS				; Restore DS
		POP		BX				; Restore BX
int13:	DB		0EAh			; Intersegment jummp
int10o	DW		0				; Offset
int10s	DW		0				; Segment
}
