#!/bin/bash
#
# multistation-devices-refresh.sh
#
#
#    Copyright (c) 2002-2007 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
# Description
# 	- Reconfigure multimeida and storage devices when user assigns primary device into a station
#   - Will work for both DM and DST
#
# Called from: USBConfigDaemon
#
# Call: usbaudio-refresh.sh(DST4), multistation-audio-refresh.sh, multistation-storage-refresh.sh

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`

# Call device refresh script for DST4
if [ -x /opt/userful/bin/usbaudio-refresh.sh ]; then
    /opt/userful/bin/usbaudio-refresh.sh
fi

#
# Audio Device refresh
#
if [ -x /opt/userful/bin/multistation-audio-refresh.sh ]; then
	/opt/userful/bin/multistation-audio-refresh.sh
fi

#
# Storage Device
#
if [ -x /opt/userful/bin/multistation-storage-refresh.sh ]; then
	/opt/userful/bin/multistation-storage-refresh.sh
fi
