#!/usr/bin/env python

# Copyright (c) 2002-2005 Userful Corporation. All rights reserved.
# http://www.userful.com/

import gtk 
import gtk.glade
import os
import time
import sys
import signal

import gettext

gtk.glade.bindtextdomain("userful-about-dialog", "/usr/share/locale")
gtk.glade.textdomain("userful-about-dialog")

gettext.bindtextdomain('userful-about-dialog')
gettext.textdomain('userful-about-dialog')

#gettext.bind_textdomain_codeset("userful-about-dialog", "UTF-8")
gettext.bind_textdomain_codeset("userful-about-dialog", "ISO-8859-1")

_ = gettext.gettext

class PyGlade:
    glade_filename = 'progress-dialog.glade'
    paths = []
    paths.append('./')
    paths.append('/usr/share/1box-utils/')

    type = 'error'

    def __init__(self):
        glade_file = self.find_file(self.glade_filename)
        
        if os.access(glade_file, os.R_OK) == 1:
            self.gtk_glade_xml = gtk.glade.XML(glade_file)
        else:
            exit

        widget = self.gtk_glade_xml.get_widget("progress_dialog")
        widget.set_icon_from_file(self.find_file("multi-station-system-64.png"))

        # get a dictionary of all the class' methods
        signal_handlers = {}
        for key in dir(self.__class__):
            signal_handlers[key] = getattr(self, key)

        # this will connect all the signals defined in the glade file to functions
        # witth the same name, this will warn if signals are not handled 
        self.gtk_glade_xml.signal_autoconnect(signal_handlers)

    def set_text (self, text):
        widget = self.gtk_glade_xml.get_widget("progress_label")
        widget.set_text(text)
        return

    def set_type (self, type):
        if type != "error":
            widget = self.gtk_glade_xml.get_widget("error_image")
            if type == "sucess":
                widget.set_from_file(self.find_file("multi-station-system-64.png"))
            if type == "success":
                widget.set_from_file(self.find_file("multi-station-system-64.png"))
        return

    def find_file (self, file_name):
        for path in self.paths:
            file_path = os.path.join(path, file_name)
            if os.path.isfile(file_path):
                break
        return file_path

    def signal_handler (self):
        gtk.main_quit()
        return

    ################ CALLBACKS ################

    def on_progress_dialog_destroy(self, widget):
        gtk.main_quit()
        return 

#    def on_progress_dialog_okbutton_clicked(self, error_dialog_ok_button):
#        gtk.main_quit()
#        return 

def read_args():
   return_dict = {}
   for arg in sys.argv[1:]:
       try:
           (keyname, keyvalue)=arg.split('=',1)
       except:
           break
       keyvalue = keyvalue.strip()
       keyname = keyname.strip()
       return_dict[keyname]=keyvalue
   return return_dict


def main():

    PyGlade_ins = PyGlade()

    arg_dict = read_args()

    if arg_dict.has_key("text") and arg_dict["text"] != "":
        PyGlade_ins.set_text(arg_dict["text"])


    #signal.signal(signal.SIGUSR1, PyGlade_ins.signal_handler)

    gtk.main()

if __name__ == "__main__":
    main()

