#!/bin/bash
#
#  userful-input-command.sh
#
############################


############
# usage()
############
function usage()
{
	echo ""
	echo "Usage: userful input [OPTION]"
	echo ""
	echo -e "\tOPTIONS:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t- Print this help message"
	echo -e "\t\t-reset\t- Reset the configuration of input devices"
	echo -e "\t\t-static\t- Enable/disable static config type"
	echo ""
	exit 1
}

############
# usage()
############
function usageConfigType()
{
	echo ""
	echo "Usage: userful input -static [OPTION]"
	echo ""
	echo -e "\tOPTIONS:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t- Print this help message"
	echo -e "\t\tenable\t- Enable static configuration for input devices"
	echo -e "\t\tdisable\t- Disable static configuration for input devices"
	echo ""
	exit 1
}

#######################
# setInputConfigType()
#######################
function setInputConfigType()
{
	[[ -z $1 ]] && usageConfigType	

	if [[ "$1" == "enable" ]]; then
		# static configuration, make a backup for the /etc/usbinput
		cp -f /etc/usbinput /etc/usbinput.static
		configtype=static
		echo -e "\nEnabled static configuration for input devices.\n"

	elif [[ "$1" == "disable" ]]; then
		rm -f /etc/usbinput.static
		configtype=dynamic
		echo -e "\nDisabled static configuration for input devices.\n"

	else
		usageConfigType
	fi

	# Update dm.conf with configtype
	if grep "^[[:space:]]*DEVCONF=" /etc/userful/dm.conf > /dev/null 2>&1; then
    	sed -i -e "s/^[[:space:]]*DEVCONF=.*/DEVCONF=$configtype/g" /etc/userful/dm.conf
	elif grep "^[[:space:]]*#[[:space:]]*DEVCONF=" /etc/userful/dm.conf > /dev/null 2>&1; then
    	sed -i -e "s/^[[:space:]]*#[[:space:]]*DEVCONF=.*/DEVCONF=$configtype/g" /etc/userful/dm.conf
	else
    	echo "DEVCONF=$configtype" >> /etc/userful/dm.conf
	fi

}

#####################
# inputConfigType ()
#####################
function inputConfigType()
{
	[[ -z $1 ]] && usageConfigType	

	case "$1" in
		-h|-help)
			usageConfigType
			;;

		enable | disable)
			setInputConfigType $1
			;;

		*)
			echo -e "\nError: Invalid option - $1"
			usageConfigType
			;;
	esac
}

#-------------------
# Start from here
#-------------------

# Import functions
source /opt/userful/bin/userful-bash-lib.sh

#
# Check if user has root access..
IsRoot

[[ -z $1 ]] && usage

case "$1" in
	-h|-help)
		usage
		;;

	-reset)
		exec /opt/userful/bin/usbinput-reconf.sh
		;;
	
	-static)
		shift
		inputConfigType $*
		;;

	*)
		echo -e "\nError: Invalid option - $1"
		usage
		;;
esac

