#!/bin/bash
#
# Copyright (c) 2005-2006 by Userful Corporation
#
# Name: userful-input-add.sh
# Author: Jason Kim <jason@userful.com>
# Description:
#    This script is called from udev rule in 99-userful-hotplug.rules. It updates usbinput and
#  sends signal to GUI, daemons and Multi-X.
#
# $1: kernel name of device. (event#)
###################################################################################

logfile="/var/log/userful-start.log"
usbinput_logfile="/var/log/usbinput.log"
ProgramName=`basename $0`
LOCK_FILE="/tmp/usbinput.lock"

# Exit from this hotplug agent program if:
#  - X is not running.
#  - During X startup
if [[ ! -e /var/run/x.pid ]]; then
    exit 1
elif ! kill -0 `cat /var/run/x.pid` > /dev/null 2>&1; then
    exit 1
fi

if [[ -e /tmp/X-start ]]; then
    exit 1
fi

# show message, "New input device detected", on Press F-key GUI program
killall -USR1 userful-usbinput-config

# Exit if USBConfigDaemon is not running
if [ ! -e /var/run/pid.usbconfigdaemon -o ! -d /proc/`cat /var/run/pid.usbconfigdaemon` ]; then
	exit 1
fi

# Exit if normal X is running.
if [ -f /etc/sysconfig/xtype ]; then
	source /etc/sysconfig/xtype
	if [ "$XTYPE" = "SINGLE" -o "$XTYPE" = "single" ]; then
		exit 1
	fi
fi

# Touch input-hotplug file
touch /tmp/input-hotplug

echo "`date +"%b %d %T"` $ProgramName: Add new device $1" >> $usbinput_logfile
echo "`date +"%b %d %T"` $ProgramName: Add new device $1, $PHYSDEVPATH" >> $logfile

##
## /etc/usbinput should be accessed exclusively.
#if [ -f /tmp/usbinput.lock ]; then
#	while [ -f /tmp/usbinput.lock ]; do
#		usleep 200000
#	done
#fi
## create lock file
#touch /tmp/usbinput.lock

while ! (set -C; : > $LOCK_FILE) 2> /dev/null; do
	usleep 200000
done

# Check the device config type.  If it is static, use static configration.
if [[ -f /etc/userful/dm.conf ]]; then
    sed -e "s/^\[/#\[/g" /etc/userful/dm.conf > /tmp/dm.conf.tmp
    source /tmp/dm.conf.tmp
fi
if [ "$DEVCONF" == "static" ]; then
    if [ -f /etc/usbinput.static ]; then
        cp -f /etc/usbinput.static /etc/usbinput
    fi
fi

# update /etc/usbinput
/opt/userful/bin/make-config-file -r
if [[ -e /etc/usbinput ]]; then
    chmod a+r /etc/usbinput
fi

## delete lock file
rm -f $LOCK_FILE

# send signal to X to reopen the input devices
pkill -USR2 MXSigDaemon
#/opt/userful/bin/send_signal

# send USR2 signal to kbd/mse daemons
pkill -USR2 kbd-daemon
pkill -USR2 mse-daemon

killall -HUP userful-usbinput-config
