#!/bin/bash
#
#  userful-driver-command.sh
#
############################


############
# usage()
############
function usage()
{
	echo ""
	echo "Usage: userful driver [OPTION]"
	echo ""
	echo -e "\tOPTIONS:"
	echo -e "\t\t-h"
	echo -e "\t\t-help\t\t- Print this help message"
	echo -e "\t\t-install matrox\t- Install Matrox driver"
	echo ""
	exit 1
}

####################################################
# installDriver()
# 	- This is for installing Matorx driver for now
####################################################
function installDriver()
{
	[[ -z $1 ]] && usage
	[[ "$1" != "matrox" ]] && usage

	exec /opt/userful/bin/userful-install-matrox-driver.sh
}

#-------------------
# Start from here
#-------------------

# Import functions
source /opt/userful/bin/userful-bash-lib.sh

#
# Check if user has root access..
IsRoot

[[ -z $1 ]] && usage

case "$1" in
	-h|-help)
		usage
		;;

	-install)
		shift
		installDriver $*
		;;

	*)
		echo -e "\nError: Invalid option - $1"
		usage
		;;
esac

