#!/bin/bash
#
#   userful-dm.sh
#
#   This is a simple Display Manager using xkeepalive and handles "auto"
#   and "remote" login sessions. Local login sessions are handled by general
#   Display Manager such as GDM and XDM.
#
#   Copyright (c) 2002-2007 Userful Corporation. All rights reserved.
#   Jason Kim <jason@userful.com>
#
# Called from: dm-start-display-manager.sh
# Call: remote-login.sh, auto-login.sh

logfile="/var/log/userful-start.log"
ProgramName=`basename $0`
LOGIN_TYPE=$1
KEEPALIVE=/opt/userful/bin/keepalive

echo "`date +"%b %d %T"` [$ProgramName]: Starting Userful's simple Display Manager. This is a Master process..." >> $logfile

# find the number of station
# /etc/X11/stations - number of all video heads
# /etc/stations - number from the license key
if [ -f /etc/X11/stations ]; then
    ALL_STATIONS=`cat /etc/X11/stations`
else
    echo "`date +"%b %d %T"` [$ProgramName](error): Unable to find /etc/X11/stations" >> $logfile
    exit 1
fi

if [ -f /etc/stations ]; then
    LICENSED_STATIONS=`cat /etc/stations`

    if [ $LICENSED_STATIONS -ge $ALL_STATIONS ]; then
	    STATIONS_NO=$ALL_STATIONS
    else
	    STATIONS_NO=$LICENSED_STATIONS
    fi

else
	STATIONS_NO=$ALL_STATIONS
fi

# delete all pid file for userful-usbinput-config (Press F-Key program)
rm -f /var/run/pid.kbdlink*

if [ "$LOGIN_TYPE" == "auto" -o "$LOGIN_TYPE" == "remote" ]; then

    # Start auto/remote login for each station
    for (( N=0 ; N < $STATIONS_NO ; N++ )) ;  do

	    LOGIN_LOG="$LOGIN_TYPE-login-$N.log"
	    mv --backup=numbered /var/log/$LOGIN_LOG /var/log/$LOGIN_LOG.old
        #delete log files older than 30 days
	    find /var/log/ -name "$LOGIN_LOG.old*" -mtime +30 -exec rm -f \{\} \;

        echo "`date +"%b %d %T"` [$ProgramName]: Starting slave Display Manager for DISPLAY=:$N" >> $logfile
	    $KEEPALIVE /opt/userful/bin/$LOGIN_TYPE-login.sh :$N >> /var/log/$LOGIN_LOG 2>&1 &
        sleep 1

    done

else
    echo "`date +"%b %d %T"` [$ProgramName](error): Unsupport login type: $LOGIN_TYPE" >> $logfile
    exit 1
fi

wait
