#!/bin/bash

# Copyright (c) 2002-2005 Userful Corporation. All rights reserved.
# http://www.userful.com/

# install-license.sh - get some info from the system, submit it via URL, and 
# if we get a vailid license: install it, if not: display a meaningful
# error message

# not necessary for now
#FIND_EXE=/usr/share/1box-utils/find-exe.sh
#if [ ! -x $FIND_EXE ] ; then
#    FIND_EXE=./find-exe.sh
#    if [ ! -x $FIND_EXE ] ; then
#        echo "Can't find required scrips, bailing out"
#    fi
#fi

# check if python is installed, if not, unset the display so we'll use
#if /usr/share/1box-utils/find-exe.sh python > /dev/null ; then
#fi    

# check to see is local versions of the programs exists, 
# if they do, use them, if not, use the default install locations
# if those don't exists use 'echo'

ERR_DLG=/usr/share/1box-utils/error-dialog.py
if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=./error-dialog.py
fi 

if [ ! -x $ERR_DLG ] ; then
    ERR_DLG=echo
fi

ACTIVATION_DLG=./activation-dialog.py
if [ ! -x $ACTIVATION_DLG ] ; then
    ACTIVATION_DLG=/usr/share/1box-utils/activation-dialog.py
fi
if [ ! -x $ACTIVATION_DLG ] ; then
    ACTIVATION_DLG=$ERR_DLG
fi

PROGRESS_DLG=./progress-dialog.py
if [ ! -x $PROGRESS_DLG ] ; then
    PROGRESS_DLG=/usr/share/1box-utils/progress-dialog.py
fi
if [ ! -x $PROGRESS_DLG ] ; then
    PROGRESS_DLG=$ERR_DLG
fi

if [ -z "$DISPLAY" ] ; then
    ERR_DLG=echo
    ACTIVATION_DLG=echo
    PROGRESS_DLG=echo
fi

$PROGRESS_DLG &
PROGRESS_DLG_PID=$!
KILL_PROGRESS="kill -SIGHUP $PROGRESS_DLG_PID"

URL="http://store.userful.com/license/control/GetLicense?"
# for testing
#URL="http://bob.userful.ca/license/control/GetFreeLicense?"


# We always include an activation code even if it is empty because the 
# server requires it
ACTIVATION_CODE="$1"
URL="${URL}activation=$ACTIVATION_CODE"

ETH_NUM=0
MAC=`LANG=C /sbin/ifconfig -a eth$ETH_NUM | grep "HWaddr" | awk '{ print $5 }'`
if [ -z "$MAC" ] || [ ${#MAC} != 17 ] ; then 
    # MAC is no good
    MAC=nomac
fi

# license file order:
# http://sugar.userful.ca:8080/wiki/index.php?title=License_File
# : - _

MAC_COLONS=$MAC
MAC_DASHES=${MAC//:/-}
MAC_UNDERS=${MAC//:/_}

#if false ; then
FILENAME=
if [ -e /etc/X11/$MAC_COLONS.1Box.info ]; then
    FILENAME="/etc/X11/$MAC_COLONS.1Box.info"
elif [ -e /etc/X11/$MAC_DASHES.1Box.info ]; then
    FILENAME=/etc/X11/$MAC_DASHES.1Box.info
elif [ -e /etc/X11/$MAC_UNDERS.1Box.info ]; then
    FILENAME=/etc/X11/$MAC_UNDERS.1Box.info
elif [ -e /etc/X11/1Box.info ] ; then
    FILENAME="/etc/X11/1Box.info"
elif [ -e /etc/X11/1Box.info.trial ]; then
    FILENAME="/etc/X11/1Box.info.trial"
fi

LICENSE_KEY=
if [ -n "$FILENAME" ] ; then
    echo Found license: $FILENAME
    LICENSE_KEY="`/usr/share/1box-utils/b64encode.py $FILENAME`"
    URL="${URL}&"
    URL="${URL}lickey=$LICENSE_KEY"
else
    URL="${URL}&lickey="
fi
#fi # if false

if [ $MAC == nomac ] ; then
    exec $ERR_DLG "text=No valid MAC address found. Please contact Userful: http://store.userful.com/ or 1-(866)-USERFUL."
else
    URL="${URL}&"
    URL="${URL}mac=${MAC//:/}"
fi

# add the language to the url
if [ -n "$LANG" ] ; then
    URL="${URL}&"
	URL="${URL}lang=$LANG"
else
    # if it's empty, send it anyway
    URL="${URL}&"
	URL="${URL}lang="
fi

# add the version to the url
VERSION=unknown
if which rpm &> /dev/null ; then
    VERSION_TMP=`rpm -q --qf '%{VERSION}-%{RELEASE}' 1box-utils-k26`
    RET=$?
    if [ $RET == 0 ] ; then
        VERSION=$VERSION_TMP
    fi
elif which deb ; then
    VERSION=deb-unknown
fi
if [ -n "$VERSION" ] ; then
    URL="${URL}&version=$VERSION"
else
    URL="${URL}&version="
fi

# add the OS version to the URL
FILE=/etc/issue
OS_VERSION=unknown
if [ -f /etc/issue ] ; then
    OS_VERSION=`/usr/share/1box-utils/b64encode.py /etc/issue`
fi
URL="${URL}&"
URL="${URL}osversion=$OS_VERSION"

TMP_DIR=/tmp/install-license-$$
mkdir -p $TMP_DIR

SRC_FILE=$TMP_DIR/1Box.info

echo "Attempting to get license file from $URL"

# Get license file

C=`which curl`
W=`which wget`

RET=1
if [ -x /usr/share/1box-utils/get-url.py ] ; then
	/usr/share/1box-utils/get-url.py "$URL" >  $SRC_FILE 2> /dev/null
	RET=$?
fi
if [ $RET != 0 ] ; then
    if [ -n "$C" ] && [ -x $C ] ; then 
        curl "$URL" > $SRC_FILE 2> /dev/null
    elif [ -n "$w" ] && [ -x $w ] ; then 
        mkdir -p $TMP_DIR/tmp
        cd $TMP_DIR/tmp
        wget "$URL"
        mv * $SRC_FILE
        cd -
        rm -rf $TMP_DIR/tmp
    else
        if [ -d /proc/$PROGRESS_DLG_PID ] ; then
            $KILL_PROGRESS
        fi
        exec $ERR_DLG "Could not use python urllib, find 'wget', or 'curl' to download license file. Go to http://store.userful.com/ to get your license."
    fi
fi

# make the command line version look a little nicer
echo

# verify license file
SIZE=`stat -c "%s" $SRC_FILE`

if [ -d /proc/$PROGRESS_DLG_PID ] ; then
	$KILL_PROGRESS
fi

if [ $SIZE != 256 ] ; then
	# license is bad: it's actually an error message - show the message (or do something else)
    if [ -n "$ACTIVATION_CODE" ] ; then
        exec $ACTIVATION_DLG key="$ACTIVATION_CODE" error_text="`cat $SRC_FILE`" 
    else
        if [ -z "$DISPLAY" ] ; then
            echo "We did not recive a license file from the server."
            echo "Please use go to http://store.userful.com/ to register. After registering, run this script again."
            echo "The text returned from the server was: "
        fi
        exec $ACTIVATION_DLG "error_text=`cat $SRC_FILE`" 
    fi
else
	:
	# license is good
fi

# license is good: install license file
INSTALL_DIR=/etc/X11
if [ ! -w $INSTALL_DIR ] ; then
    mv -f $SRC_FILE /tmp/1Box.info &> /dev/null && SRC_FILE=/tmp/1Box.info
    exec $ERR_DLG "License key downloaded but not installed. You must be root for automatic installation. The file has been saved to $SRC_FILE. Ask your system administrator to copy this file to $INSTALL_DIR or re-run this application as root."
fi

BACKUP_DIR=$INSTALL_DIR/1Box-info-backup
mkdir -p $BACKUP_DIR 

if ls $INSTALL_DIR/*1Box.info* &> /dev/null ; then
    mv -f --backup=numbered $INSTALL_DIR/*1Box.info* $BACKUP_DIR
fi

mv $SRC_FILE $INSTALL_DIR/1Box.info 

exec $ERR_DLG type=sucess text="Successfully installed license file."
