#!/bin/bash
#
# Copyright (c) 2005-2006 by Userful Corporation
#
# Name: userful-input-add.sh
# Author: Jason Kim <jason@userful.com>
# Description:
#    This script is called from udev rule in 99-userful-hotplug.rules. It updates usbinput and
#  sends signal to GUI, daemons and Multi-X.
#
# $1: kernel name of device. (event#)
###################################################################################

logfile="/var/log/usbinput.log"

#echo "#######################" >> $logfile
#echo "run userful-input-add.sh" >> $logfile
#echo "########################" >> $logfile

# show message "New input device detected"
killall -USR1 userful-usbinput-config

if [ ! -e /var/run/x.pid -o ! -d /proc/`cat /var/run/x.pid` ]; then
	# If X is not running, just exit.
	exit 1
fi

if [ -f /etc/sysconfig/xtype ]; then
	source /etc/sysconfig/xtype
	if [ "$XTYPE" = "SINGLE" -o "$XTYPE" = "single" ]; then
		# If normal X is running, just exit.
		exit 1
	fi
fi

date >> $logfile
echo "add Device: $1" >> $logfile

# update /etc/usbinput
/opt/userful/bin/make-config-file -r

# send signal to X to reopen the input devices
pkill -USR2 MXSigDaemon
#/opt/userful/bin/send_signal

# send USR2 signal to kbd/mse daemons
pkill -USR2 kbd-daemon
pkill -USR2 mse-daemon

killall -HUP userful-usbinput-config
