#!/bin/bash
#
# dm-start-display-manager.sh
#
#    Start Display Manager based on distro.
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#

# set OSNAME, OSVER
source /etc/userful/os-info

case "$OSNAME" in
	"fedora"|"redhat"|"centos" )  ### Fedora, Redhat, CentOS ###
		exec /etc/X11/prefdm -nodaemon
		;;

	"mandrake" )  ### Mandrake ###
		exec /etc/X11/prefdm
		;;

	"suse"|"novell"|"jds" )  ### SuSE, Novell, JDS
		exec /etc/init.d/xdm.multi-save start
		;;

	"xandros"|"mepis" )  ### Xandros, Mepis ###
		exec /etc/init.d/kdm.multi-save start
		;;

	"ubuntu"|"linspire"|"debian" )  ### Ubuntu, Linspire, Debian
		exec /etc/init.d/gdm.multi-save start
		;;

	* )
		echo "Unsupported Linux system"
		exit 1
		;;
esac
