#!/bin/bash
#
# dm-start-daemon.sh
#
#	 Start Daemons. ( USBConfigDaemon, kbd-daemon, mse-daemon, MXSigDaemon )
#
#    Copyright (c) 2005-2006 Userful Corporation
#    
#    Jason Kim <jason@userful.com>
#
#

# $1: CURRENTDM

# set KEEPALIVE
if [ -f /opt/userful/bin/xkeepalive ]; then
	KEEPALIVE="/opt/userful/bin/xkeepalive"
elif [ -f /opt/userful/bin/keepalive ]; then
	KEEPALIVE="/opt/userful/bin/keepalive"
fi

# Start USBConfigDaemon
if [ -x /opt/userful/bin/USBConfigDaemon ] ; then
   	if [ -e /var/run/pid.usbconfigdaemon -a \
		 -e /proc/`cat /var/run/pid.usbconfigdaemon` ]; then

       	echo "USBConfigDaemon exist already ..." 
		usleep 100000
	else

		if [ ! -z "$KEEPALIVE" ]; then
       		$KEEPALIVE /opt/userful/bin/USBConfigDaemon -dm $1 &
		else
       		/opt/userful/bin/USBConfigDaemon -dm $1 &
		fi

		mv -f /var/log/usbinput.log /var/log/usbinput.log.old
		echo `date` >> /var/log/usbinput.log
		echo "System boot-up ......." >> /var/log/usbinput.log
	fi
fi

sleep 1

while ! pgrep USBConfigDaemon > /dev/null ; do
	sleep 1
done

# start kbd-daemon
if pgrep kbd-daemon > /dev/null 2>&1; then
	pkill kbd-daemon
else
	cp -f /var/log/kbd-daemon.log /var/log/kbd-daemon.log.old
	$KEEPALIVE /opt/userful/bin/kbd-daemon 2>/var/log/kbd-daemon.log &
fi

# start mse-daemon
if pgrep mse-daemon > /dev/null 2>&1; then
	pkill mse-daemon
else
	cp -f /var/log/mse-daemon.log /var/log/mse-daemon.log.old

	$KEEPALIVE /opt/userful/bin/mse-daemon 2>/var/log/mse-daemon.log &
fi

# start MXSigDaemon
if pgrep MXSigDaemon > /dev/null 2>&1; then
	pkill MXSigDaemon
else
	cp -f /var/log/MXSigDaemon.log /var/log/MXSigDaemon.log.old
	$KEEPALIVE /opt/userful/bin/MXSigDaemon 2>/var/log/MXSigDaemon.log &
fi
