#!/bin/bash
#
# dm-gen-xconfig.sh
#
#	Create X/MX config file. 
#	 - userful.xorg.conf.one
#	 - userful.xorg.conf.all
#	 - userful.Mxorg.conf
#
#	Copyright (c) 2006 Userful Corporation
#
#	Jason Kim <jason@userful.com>
# 
logfile="/var/log/userful-start.log"
XORG_CONF_NEW="/root/xorg.conf.new"
TMPDIR="/tmp"

MXDEVNO=0 # Multiple graphic configuration
SXDEVNO=0 # Single graphic configuration
NUM_OF_HEAD=0
NVIDIA_DRIVER=
CURR_CARD_TYPE=
STATION_TYPE=

H_SYNC=
V_REFRESH=
BUSID=
VENDORNAME=
BOARDNAME=
DRIVER=
HEADNO=
DEVID=

KILLX=1
BADMONITOR=1
LIB="lib"

# diable vidmoe for radeon card
DISABLEXVIDMODE=0

# find available lspci command.
if which lspci > /dev/null 2>&1; then
	LSPCI="lspci"
else
	LSPCI="/opt/userful/bin/listpci"
fi

#
# generate Header 
# $1: config type
function gen_Header()
{
	echo '#######################################' > $TMPDIR/tmpconfig

	if [ "$1" == "-1box" ]; then
		echo '# userful.Mxorg.conf' >> $TMPDIR/tmpconfig
	elif [ "$1" == "-all" ]; then
		echo '# userful.xorg.conf.all' >> $TMPDIR/tmpconfig
	elif [ "$1" == "-one" ]; then
		echo '# userful.xorg.conf.one' >> $TMPDIR/tmpconfig
	elif [ "$1" == "-check" ]; then
		echo '# userful.xorg.conf.check' >> $TMPDIR/tmpconfig
	fi
	echo '# Created by Userful' >> $TMPDIR/tmpconfig
	echo '#######################################' >> $TMPDIR/tmpconfig
	echo >> $TMPDIR/tmpconfig
}

#
# generate Files section
# $1: config type
function gen_section_Files()
{
	cat $TMPDIR/section.Files >> $TMPDIR/tmpconfig
	echo >> $TMPDIR/tmpconfig
}

#
# ServerFlags section
# $1: config type
function gen_section_ServerFlags()
{
	if [ "$1" == "-1box" ]; then
		echo 'Section "ServerFlags"
	Option  "Xinerama"	"off"
   	Option  "Clone"		"off"
   	Option  "RandR"		"off"
	Option	"DontVTSwitch"	"on"
	#Option	"DontZap"	"on"
	Option	"DontZoom"	"on"
	Option  "DisableVidModeExtension"   "on"
EndSection' >> $TMPDIR/tmpconfig 
	echo >> $TMPDIR/tmpconfig
	fi
}

#
# Module section
# $1: config type
function gen_section_Module()
{
	cat $TMPDIR/section.Module >> $TMPDIR/tmpconfig
	echo >> $TMPDIR/tmpconfig
}

#
# Monitor section
# $1: config type
function gen_section_Monitor()
{
	cat $TMPDIR/section.Monitor >> $TMPDIR/tmpconfig
	if grep "HorizSync" $TMPDIR/section.Monitor > /dev/null 2>&1 &&
		grep "VertRefresh" $TMPDIR/section.Monitor > /dev/null 2>&1; then
		BADMONITOR=0 # get correct monitor information
	else
		echo "(WW) can't get Monitor information connected to first head" >> $logfile
	fi

	if [ "$1" == "-one" -o "$1" == "-all" -o "$1" == "-check" ]; then
		H_SYNC="28-78"
		V_REFRESH="43-75"
	else
		if [ "$SYS_RESOLUTION" == "1" ]; then
			H_SYNC="28-78"
			V_REFRESH="43-75"
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			H_SYNC="28-78"
			V_REFRESH="43-75"
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			H_SYNC="28-78"
			V_REFRESH="43-75"
		elif [ "$SYS_RESOLUTION" == "4" ]; then
			H_SYNC="31-82"
			V_REFRESH="56-75"
		else
			H_SYNC="28-78"
			V_REFRESH="43-75"
		fi
	fi		
	echo '
Section "Monitor"
	Identifier "Monitor"
	VendorName "Monitor Vendor"
	ModelName "Monitor Model"
	HorizSync '$H_SYNC'
	VertRefresh '$V_REFRESH'
EndSection' >> $TMPDIR/tmpconfig
	echo >> $TMPDIR/tmpconfig
}

# get card information 
# $1: config type
# $2: information string
function get_card_info()
{
	BUSID=`echo $2 | awk -F'^' '{print $1}'`
	VENDORNAME=`echo $2 | awk -F'^' '{print $2}'`
	BOARDNAME=`echo $2 | awk -F'^' '{print $3}'`
	DRIVER=`echo $2 | awk -F'^' '{print $4}'`

	if [ "$1" == "-1box" ]; then
		HEADNO=`echo $2 | awk -F'^' '{print $5}'`
		DEVID=`echo $2 | awk -F'^' '{print $6}'`
	fi
}

# create Device section for userful.xorg.conf.one
function config_x()
{
  	echo 'Section "Device"
	Identifier "Videocard'$SXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "ColorTiling" "off"
EndSection' >> $TMPDIR/tmpconfig
	echo >> $TMPDIR/tmpconfig

	SXDEVNO=$((SXDEVNO+1))

}

# generate Device configuration for MAG card
function mga_multihead_config() 
{
	# if single-view, laptop or not userful.Moxrg.conf configuration
	if [ "$CURR_CARD_TYPE" == "S" -o "$1" != "-1box" -o "$SYS_TYPE" == "1" ]; then
		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0
	Option "MGASDRAM" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig
		echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1
	Option "MGASDRAM" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig 
		echo >> $TMPDIR/tmpconfig
   		MXDEVNO=$((MXDEVNO+2))

	else # dualview configuration
		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0
	Option "MergedFB"
	Option "Monitor2Position" "RightOf"
	Option "Monitor2HSync" "'$H_SYNC'"
	Option "Monitor2VRefresh" "'$V_REFRESH'"
	Option "MGASDRAM" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"' >> $TMPDIR/tmpconfig

		if [ "$SYS_RESOLUTION" == "1" ]; then
			echo '	Option "MetaModes" "640x480-640x480"' >> $TMPDIR/tmpconfig
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			echo '	Option "MetaModes" "800x600-800x600 640x480-640x480"' >> $TMPDIR/tmpconfig
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			echo '	Option "MetaModes" "1024x768-1024x768 800x600-800x600 640x480-640x480"' >> $TMPDIR/tmpconfig
		elif [ "$SYS_RESOLUTION" == "4" ]; then
			echo '	Option "MetaModes" "1280x1024-1280x1024 1024x768-1024x768 800x600-800x600 640x480-640x480"' >> $TMPDIR/tmpconfig
		fi
		echo 'EndSection' >> $TMPDIR/tmpconfig

		STATION_TYPE[$MXDEVNO]=D # Set the Vitual in Screen section
		SYS_DUALVIEW=$((SYS_DUALVIEW-1))
   		MXDEVNO=$((MXDEVNO+1))
	fi
}

# generate Device configuration for Radeon card
function radeon_multihead_config()
{
	# if single-view, laptop or not userful.Moxrg.conf configuration
	if [ "$CURR_CARD_TYPE" == "S" -o "$1" != "-1box" -o "$SYS_TYPE" == "1" ]; then

		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "radeon"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0' >> $TMPDIR/tmpconfig

		if [ "$SYS_TYPE" == "1" ]; then # Laptop
			echo '	Option "MonitorLayout" "LVDS, CRT"' >> $TMPDIR/tmpconfig
		else
			echo '	Option "MonitorLayout" "CRT, CRT"' >> $TMPDIR/tmpconfig
		fi
		echo '	Option "DisplayPriority" "AUTO"' >> $TMPDIR/tmpconfig
		echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig

   		echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "radeon"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1' >> $TMPDIR/tmpconfig

		if [ "$SYS_TYPE" == "1" ]; then
			echo '	Option "MonitorLayout" "LVDS, CRT"' >> $TMPDIR/tmpconfig
		else
			echo '	Option "MonitorLayout" "CRT, CRT"' >> $TMPDIR/tmpconfig
		fi
		echo '	Option "DisplayPriority" "AUTO"' >> $TMPDIR/tmpconfig
		echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig
		MXDEVNO=$((MXDEVNO+2))

	else # dualview configuration
		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "radeon"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "CRT2ForceOn" "true"
	Option "ForceCRT2Type" "VGA"
	Option "ForceCRT1" "true"
	Option "MergedFB" "true"
	Option "CRT2Position" "RightOf"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> $TMPDIR/tmpconfig
		STATION_TYPE[$MXDEVNO]=D # Set the Virtual in screen section
		SYS_DUALVIEW=$((SYS_DUALVIEW-1))
    	MXDEVNO=$((MXDEVNO+1))
	fi
}

# generate Device configuration for nvidia card
function nvidia_multihead_config()
{
	# if single-view, laptop or not userful.Moxrg.conf configuration
	if [ "$CURR_CARD_TYPE" == "S" -o "$1" != "-1box" -o "$SYS_TYPE" == "1" ]; then

		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "nvidia"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0' >> $TMPDIR/tmpconfig
		if [ "$SYS_TYPE" == "1" ]; then
			echo '	Option "ConnectedMonitor" "DFP, CRT"' >> $TMPDIR/tmpconfig
		else
			echo '	Option "ConnectedMonitor" "CRT, CRT"' >> $TMPDIR/tmpconfig
		fi
		echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig

   		echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "nvidia"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1' >> $TMPDIR/tmpconfig
		if [ "$SYS_TYPE" == "1" ]; then
			echo '	Option "ConnectedMonitor" "DFP, CRT"' >> $TMPDIR/tmpconfig
		else
			echo '	Option "ConnectedMonitor" "CRT, CRT"' >> $TMPDIR/tmpconfig
		fi
		echo '	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig
		MXDEVNO=$((MXDEVNO+2))

	else # dualview configuration
		echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "nvidia"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "TwinView" "on"
	Option "TwinViewOrientation" "RightOf"
	Option "ConnectedMonitor" "CRT,CRT"' >> $TMPDIR/tmpconfig
		if [ "$SYS_RESOLUTION" == "1" ]; then
			echo '	Option "MetaModes" "640x480,640x480"' >> $TMPDIR/tmpconfig
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			echo '	Option "MetaModes" "800x600,800x600; 640x480,640x480"' >> $TMPDIR/tmpconfig
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			echo '	Option "MetaModes" "1024x768,1024x768; 800x600,800x600; 640x480,640x480"' >> $TMPDIR/tmpconfig
		elif [ "$SYS_RESOLUTION" == "4" ]; then
			echo '	Option "MetaModes" "1280x1024,1280x1024; 1024x768,1024x768; 800x600,800x600; 640x480,640x480"' >> $TMPDIR/tmpconfig
		fi
		echo '	Option "NoTwinViewXineramaInfo" "true"  # Dont change this option, otherwise X will crash.
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig
		STATION_TYPE[$MXDEVNO]=S # Do not set the Vitual in Screen section
		SYS_DUALVIEW=$((SYS_DUALVIEW-1))
    	MXDEVNO=$((MXDEVNO+1))
	fi
}

# create Device section for multiple graphic card
function config_mx()
{
	if [ $HEADNO -eq 1 ]; then # Single head configuration
		case "$DRIVER" in
			"savage")
				echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "shadowFB" "on"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig
				echo >> $TMPDIR/tmpconfig
    			MXDEVNO=$((MXDEVNO+1))
				;;

			*)
				echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Option "SWCursor" "on"
	Option "HWCursor" "off"
	Option "ColorTiling" "off"
EndSection' >> $TMPDIR/tmpconfig
    			MXDEVNO=$((MXDEVNO+1))
				echo >> $TMPDIR/tmpconfig
				;;
		esac

	else 	# dual head card
		case "$DRIVER" in
			"mga")
				mga_multihead_config $1
				;;
			"radeon"|"ati")
				DISABLEXVIDMODE=1
				radeon_multihead_config $1
				;;
			"nv")
				nvidia_multihead_config $1
				;;
			*)
				echo 'Section "Device"
	Identifier "Videocard'$MXDEVNO'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 0
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig
				echo >> $TMPDIR/tmpconfig
    			echo 'Section "Device"
	Identifier "Videocard'$((MXDEVNO+1))'"
	Driver "'$DRIVER'"
	VendorName "'$VENDORNAME'"
	BoardName "'$BOARDNAME'"
	BusID "PCI:'$BUSID'"
	Screen 1
	Option "SWCursor" "on"
	Option "HWCursor" "off"
EndSection' >> $TMPDIR/tmpconfig
				echo >> $TMPDIR/tmpconfig
    			MXDEVNO=$((MXDEVNO+2))
				;;
		esac
	fi
}

# generate Screen section
function gen_section_Screen()
{
	if [ "$1" == "-one" ]; then
		NUM_OF_HEAD=$SXDEVNO
	else
		NUM_OF_HEAD=$MXDEVNO
	fi

	if [ "$1" == "-one" -o "$1" == "-all" -o "$1" == "-check" ]; then
		MODES="Modes \"640x480\""
	else
		if [ "$SYS_RESOLUTION" == "1" ]; then
			MODES="Modes \"640x480\""
			VIRTUAL="Virtual 1280 480"
		elif [ "$SYS_RESOLUTION" == "2" ]; then
			MODES="Modes \"800x600\" \"640x480\""
			VIRTUAL="Virtual 1600 600"
		elif [ "$SYS_RESOLUTION" == "3" ]; then
			MODES="Modes \"1024x768\" \"800x600\" \"640x480\""
			VIRTUAL="Virtual 2048 768"
		elif [ "$SYS_RESOLUTION" == "4" ]; then
			MODES="Modes \"1280x1024\" \"1024x768\" \"800x600\" \"640x480\""
			VIRTUAL="Virtual 2560 1024"
		else
			MODES="Modes \"1024x768\" \"800x600\" \"640x480\""
			VIRTUAL="Virtual 2048 768"
		fi
	fi

	for (( i=0; i<$NUM_OF_HEAD; i++ )) ; do
		echo 'Section "Screen"
	Identifier "Screen'$i'"
	Device "Videocard'$i'"' >> $TMPDIR/tmpconfig

		# If "first screen section" and "getting correct monitor info" and
		# "not for the userful.xorg.conf.check"
		# For now use the generic Monitor for every stations
		echo "	Monitor \"Monitor\"" >> $TMPDIR/tmpconfig

		#if [ $i -eq 0 -a $BADMONITOR -eq 0 -a "$1" != "-check" ]; then
		#	echo "	Monitor \"Monitor$i\"" >> $TMPDIR/tmpconfig
		#else
		#	echo "	Monitor \"Monitor\"" >> $TMPDIR/tmpconfig
		#fi

		if [ "${STATION_TYPE[i]}" == S ]; then
			# no Virtual option
			echo '	DefaultDepth 16
	SubSection "Display"
		Depth 8
		'$MODES'
	EndSubSection
	SubSection "Display"
		Depth 15
		'$MODES'
	EndSubSection
	SubSection "Display"
		Depth 16
		'$MODES'
	EndSubSection
	SubSection "Display"
		Depth 24
		'$MODES'
	EndSubSection
EndSection' >> $TMPDIR/tmpconfig
			echo >> $TMPDIR/tmpconfig

		else
			# With Virtual option
			echo '	DefaultDepth 16
	SubSection "Display"
		Depth 8
		'$MODES'
		'$VIRTUAL'
	EndSubSection
	SubSection "Display"
		Depth 15
		'$MODES'
		'$VIRTUAL'
	EndSubSection
	SubSection "Display"
		Depth 16
		'$MODES'
		'$VIRTUAL'
	EndSubSection
	SubSection "Display"
		Depth 24
		'$MODES'
		'$VIRTUAL'
	EndSubSection
EndSection' >> $TMPDIR/tmpconfig
			echo >> $TMPDIR/tmpconfig
		fi
	done
}

# generate InputDevice section for Keyboard
function gen_InputDevice_kbd()
{
	if [ -f /usr/X11R6/bin/XFree86 ]; then
		XKBRULES="xfree86"
	else
		XKBRULES="xorg"
	fi

	if [ -f /etc/sysconfig/keyboard ]; then
		source /etc/sysconfig/keyboard
		KEYTABLE=`echo $KEYTABLE | awk -F'.' '{printf $1}'`
		XKBSTRING=`cat /opt/userful/bin/XKB-KEYTABLE | grep ^$KEYTABLE\^`
		XKBLAYOUT=`echo $XKBSTRING | awk -F'^' '{printf $2}'`
		XKBMODEL=`echo $XKBSTRING | awk -F'^' '{printf $3}'`
		XKBVARIANT=`echo $XKBSTRING | awk -F'^' '{printf $4}'`
		XKBOPTIONS=`echo $XKBSTRING | awk -F'^' '{printf $5}'`
	else
		XKBLAYOUT="us"
		XKBMODEL="pc105"
		XKBVARIANT="NULL"
		XKBOPTIONS="NULL"
	fi

	if [ "$1" == "-1box" ]; then
		# For keyboard
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo 'Section "InputDevice"
	Identifier "Keyboard'$i'"
	Driver "usbkbd"
	Option "Protocol" "usb_event"
	Option "Device" "/etc/X11/Xinput/keyboard'$i'"
	Option "Screen" "'$i'"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> $TMPDIR/tmpconfig

			if [ "$XKBVARIANT" != "NULL" ]; then
				echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> $TMPDIR/tmpconfig
			fi
			if [ "$XKBOPTIONS" != "NULL" ]; then
				echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> $TMPDIR/tmpconfig
			fi
			
			echo 'EndSection' >> $TMPDIR/tmpconfig
			echo >> $TMPDIR/tmpconfig
		done

		# For Barcode scanner
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo 'Section "InputDevice"
	Identifier "Barcode'$i'"
	Driver "usbkbd"
	Option "Protocol" "usb_event"
	Option "Device" "/etc/X11/Xinput/barcode'$i'"
	Option "Screen" "'$i'"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> $TMPDIR/tmpconfig

			if [ "$XKBVARIANT" != "NULL" ]; then
				echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> $TMPDIR/tmpconfig
			fi
			if [ "$XKBOPTIONS" != "NULL" ]; then
				echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> $TMPDIR/tmpconfig
			fi
			
			echo 'EndSection' >> $TMPDIR/tmpconfig
			echo >> $TMPDIR/tmpconfig
		done

		# Margnetic reader
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo 'Section "InputDevice"
	Identifier "Magreader'$i'"
	Driver "usbkbd"
	Option "Protocol" "usb_event"
	Option "Device" "/etc/X11/Xinput/magreader'$i'"
	Option "Screen" "'$i'"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> $TMPDIR/tmpconfig

			if [ "$XKBVARIANT" != "NULL" ]; then
				echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> $TMPDIR/tmpconfig
			fi
			if [ "$XKBOPTIONS" != "NULL" ]; then
				echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> $TMPDIR/tmpconfig
			fi
			
			echo 'EndSection' >> $TMPDIR/tmpconfig
			echo >> $TMPDIR/tmpconfig
		done

	else
		echo 'Section "InputDevice"
	Identifier  "Keyboard0"
	Driver      "kbd"
	Option "XkbRules" "'$XKBRULES'"
	Option "XkbLayout" "'$XKBLAYOUT'"
	Option "XkbModel" "'$XKBMODEL'"' >> $TMPDIR/tmpconfig

		if [ "$XKBVARIANT" != "NULL" ]; then
			echo '	Option "XkbVariant" "'$XKBVARIANT'"' >> $TMPDIR/tmpconfig
		fi
		if [ "$XKBOPTIONS" != "NULL" ]; then
			echo '	Option "XkbOptions" "'$XKBOPTIONS'"' >> $TMPDIR/tmpconfig
		fi
		
		echo 'EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig
	fi
}

# generate InputDevice section for mouse
function gen_InputDevice_mse()
{
	if [ "$1" == "-1box" ]; then
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo 'Section "InputDevice"
	Identifier  "Mouse'$i'"
	Driver      "mouse"
	Option      "Protocol" "IMPS/2"
	Option      "Device" "/etc/X11/Xinput/mouse'$i'"
	Option      "ZAxisMapping" "4 5"
	Option      "Emulate3Buttons" "no"
	Option      "Screen"  "'$i'"
EndSection' >> $TMPDIR/tmpconfig
			echo >> $TMPDIR/tmpconfig
		done

	else
		echo 'Section "InputDevice"
	Identifier  "Mouse0"
	Driver      "mouse"
	Option      "Device" "/dev/input/mice"
	Option      "Protocol" "ImPS/2"
	Option      "Emulate3Buttons" "off"
	Option      "ZAxisMapping" "4 5"
EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig
	fi
}

#
# InputDevice section for TouchScreen
function gen_InputDevice_touch()
{
	if [ "$1" == "-1box" ]; then
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
        	echo 'Section "InputDevice"
	Identifier "Touch'$i'"
	Driver "evtouch"
	#Option "Calibrate" "1"
	Option "Device" "/etc/X11/Xinput/touch'$i'"
	Option "DeviceName" "Touch'$i'"
	Option "MinX" "67"
	Option "MinY" "96"
	Option "MaxX" "4000"
	Option "MaxY" "4003"
	Option "ReportingMode" "Raw"
	Option "SendCoreEvents" "On"
	Option "DragTimer" "300"
	Option "MoveLimit" "500"
	Option "Screen"  "'$i'"
	#Option "SwapX"
	#Option "SwapY"
EndSection' >> $TMPDIR/tmpconfig
		echo >> $TMPDIR/tmpconfig
		done
	fi
}

# Create screen part in the ServerLayout section
function ServerLayout_screen()
{
	if [ "$1" == "-one" ] ; then
		echo '	Screen	"Screen0"' >> $TMPDIR/tmpconfig
	#elif [ "$1" == "-all" ] ; then
	else
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	Screen	"Screen'$i'"' >> $TMPDIR/tmpconfig
		done
	fi
}

# Create Keyboard part in the ServerLayout section
function ServerLayout_kbd()
{
	if [ "$1" == "-one" -o "$1" == "-all" -o "$1" == "-check" ] ; then
		echo '	InputDevice	"Keyboard0"	"CoreKeyboard"' >> $TMPDIR/tmpconfig
	else # -1box
		echo '	InputDevice	"Keyboard0"	"CoreKeyboard"' >> $TMPDIR/tmpconfig
		for (( i=1; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Keyboard'$i'"	"AlwaysCore"' >> $TMPDIR/tmpconfig
		done
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Barcode'$i'"	"AlwaysCore"' >> $TMPDIR/tmpconfig
		done
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Magreader'$i'"	"AlwaysCore"' >> $TMPDIR/tmpconfig
		done
	fi
}

# Create Mouse part in the ServerLayout section
function ServerLayout_mse()
{
	if [ "$1" == "-one" -o "$1" == "-all" -o "$1" == "-check" ]; then
		echo '	InputDevice	"Mouse0"	"CorePointer"' >> $TMPDIR/tmpconfig
	else
		echo '	InputDevice	"Mouse0"	"CorePointer"' >> $TMPDIR/tmpconfig
		for (( i=1; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice	"Mouse'$i'"	"AlwaysCore"' >> $TMPDIR/tmpconfig
		done
	fi
}

# Create MicroTouch TouchScreen part in the ServerLayout section
function ServerLayout_touch()
{
	if [ "$1" == "-1box" ] ; then
		for (( i=0; i<$NUM_OF_HEAD; i++ )); do
			echo '	InputDevice "Touch'$i'"	"AlwaysCore"' >> $TMPDIR/tmpconfig
		done
	fi
}

# generate ServerLayout section
function gen_section_ServerLayout()
{
	echo 'Section "ServerLayout"' >> $TMPDIR/tmpconfig
	if [ "$1" == "-one" ] ; then
		echo '	Identifier     "userful.xorg.conf.one"' >> $TMPDIR/tmpconfig
	elif [ "$1" == "-all" ] ; then
		echo '	Identifier     "userful.xorg.conf.all"' >> $TMPDIR/tmpconfig
	elif [ "$1" == "-check" ] ; then
		echo '	Identifier     "userful.xorg.conf.check"' >> $TMPDIR/tmpconfig
	elif [ "$1" == "-1box" ] ; then
		echo '	Identifier     "userful.Mxorg.conf"' >> $TMPDIR/tmpconfig
	fi

	ServerLayout_screen $1
	ServerLayout_kbd $1
	ServerLayout_mse $1
	if [ -e /etc/usbinput ]; then
		if grep "tch" /etc/usbinput > /dev/null 2>&1 ; then
			ServerLayout_touch $1
		fi
	fi
	echo 'EndSection' >> $TMPDIR/tmpconfig
}

# create Device section
# $1: config type
function gen_section_Device()
{
	if [ "$1" == "-1box" ]; then
		cp -f /etc/mvgainfo $TMPDIR/videolist
	else
		cp -f $TMPDIR/section.Device $TMPDIR/videolist
		if [ "$1" == "-check" ]; then
			rm -f /etc/mvgainfo
			cp -f $TMPDIR/tmpconfig $TMPDIR/base-tmpconfig
		fi
	fi

	while read VIDEOCARD; do
		get_card_info $1 "$VIDEOCARD"

		if [ "$1" == "-1box" ]; then
			if [ "$DRIVER" == "nv" -a $NVIDIA_DRIVER -eq 0 ]; then
				echo "(WW) nvidia driver is not available." >> $logfile
				HEADNO=1
			# need to configure DUALVIEW. 
			elif [ $SYS_DUALVIEW -gt 0 ]; then
				echo "(II) configure dualview if current video card ($BOARDNAME) support it." >> $logfile
				# need to check dualview support for current video card
				if grep "$DEVID" /opt/userful/bin/VGAINFO > /dev/null 2>&1 ; then
					CURR_CARD_TYPE=`grep "$DEVID" /opt/userful/bin/VGAINFO | awk -- '{print $3}'`
				fi
			else
				CURR_CARD_TYPE=S # set to singleview card
			fi

			config_mx $1

		elif [ "$1" == "-one" ]; then
			if [ "$DRIVER" == "" ]; then
				echo "(WW) couldn't find VGA driver for device $BOARDNAME" >> $logfile
				DRIVER=vesa
			fi
			config_x
			break

		elif [ "$1" == "-all" ]; then
			if [ "$DRIVER" == "" ]; then
				echo "(WW) couldn't find VGA driver for device $BOARDNAME" >> $logfile
				DRIVER=vesa
			fi
			HEADNO=1
			config_mx $1

		elif [ "$1" == "-check" ]; then
			BUSNUM=`echo $BUSID | awk -- '{split($1,a,":"); print a[1]}'`
			DEVICENUM=`echo $BUSID | awk -- '{split($1,a,":"); print a[2]}'`
			FUNCTIONNUM=`echo $BUSID | awk -- '{split($1,a,":"); print a[3]}'`

			BUSNUM=`printf %x $BUSNUM`
			DEVICENUM=`printf %x $DEVICENUM`
			FUNCTIONNUM=`printf %x $FUNCTIONNUM`

			VGAID=`$LSPCI -s "$BUSNUM:$DEVICENUM.$FUNCTIONNUM" -n | awk '{print $3}'`
			if [ "$VGAID" == "0300:" ]; then
				DEVID=`$LSPCI -s "$BUSNUM:$DEVICENUM.$FUNCTIONNUM" -n | awk '{print $4}'`
			else # For FC5
				DEVID=`$LSPCI -s "$BUSNUM:$DEVICENUM.$FUNCTIONNUM" -n | awk '{print $3}'`
			fi


			if [ "$DRIVER" == "" ]; then
				echo "(WW) couldn't find VGA driver for device $BOARDNAME" >> $logfile
				HEADNO=1
				DRIVER=vesa
				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^$HEADNO^$DEVID" >> /etc/mvgainfo

			elif grep "$DEVID" /opt/userful/bin/VGAINFO > /dev/null; then
				echo "(II) Found $BOARDNAME($DEVID) in /opt/userful/bin/VGAINFO" >> $logfile
				HEADNO=`grep "$DEVID" /opt/userful/bin/VGAINFO | awk -- '{print $2}'`
				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^$HEADNO^$DEVID" >> /etc/mvgainfo
				
			elif [ "$DRIVER" == "nv" -a $NVIDIA_DRIVER -eq 0 ]; then
				echo "(WW) nvidia driver is not available." >> $logfile
				HEADNO=1
				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^$HEADNO^$DEVID" >> /etc/mvgainfo

			# In Novell 10, multi-head configuration doesn't work with normal X
			elif [ -f /etc/userful/dm-config-processing ] ||
				[ "$OSNAME" == "novell" -a "$OSVER" == "10" ]; then
				echo "(WW) $OSNAME $OSVER doesn't support auto-configuration for your video card: $BOARDNAME 
     If you have dual head cards, please add card information into /opt/userful/bin/VGAINFO." >> $logfile
				HEADNO=1
				echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^$HEADNO^$DEVID" >> /etc/mvgainfo

			else
				#touch flag file 
				touch /etc/userful/dm-config-processing

				cp -f $TMPDIR/base-tmpconfig $TMPDIR/tmpconfig
				MXDEVNO=0
				HEADNO=2
				config_mx $1
				gen_section_Screen $1
				gen_InputDevice_kbd $1
				gen_InputDevice_mse $1
				gen_section_ServerLayout $1

				mv -f $TMPDIR/tmpconfig /etc/X11/userful.xorg.conf.check
				
				echo "(TT) Test VGA card: $BOARDNAME"
				XPATH=`which X`
				/opt/userful/bin/mh-check $XPATH 2> /dev/null

				if [ "$?" == "0" ]; then
					echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^2^$DEVID" >> /etc/mvgainfo
					pkill -SIGTERM X 2> /dev/null
					sleep 5
					# make sure X is not running
					while [ -f /tmp/.X0-lock ] && [ $KILLX -lt 6 ]; do
						sleep 2
						KILLX=$((KILLX+1))
					done
					if [ -f /tmp/.X0-lock ]; then  # if X exist
						pkill -9 X 2> /dev/null
						touch /tmp/mx-config-error
					fi

				else
					echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER^1^$DEVID" >> /etc/mvgainfo
					pkill -SIGTERM X 2> /dev/null
					sleep 5
				fi

				#delete flag file 
				rm -f /etc/userful/dm-config-processing
			fi
		fi

	done < $TMPDIR/videolist
}

function reconf_files()
{
	if [ "$1" == "-one" ] ; then
		cp -f $TMPDIR/tmpconfig /etc/X11/userful.xorg.conf.one
	elif [ "$1" == "-all" ] ; then
		cp -f $TMPDIR/tmpconfig /etc/X11/userful.xorg.conf.all
	elif [ "$1" == "-1box" ] ; then
		echo $NUM_OF_HEAD > /etc/X11/stations
		cp -f $TMPDIR/tmpconfig /etc/X11/userful.Mxorg.conf
		if [ $DISABLEXVIDMODE -eq 0 ]; then
			sed -i -e "/DisableVidModeExtension/d" /etc/X11/userful.Mxorg.conf
		fi
	fi
	
}

function get_section()
{
	# Initialize
	SectionFlag=0
	: > $TMPDIR/section.$1

	while read CONFLINE; do
		if [ "$CONFLINE" == "Section \"$1\"" ]; then
			SectionFlag=1
		elif [ $SectionFlag -eq 1 -a "$CONFLINE" == "EndSection" ]; then
			echo "$CONFLINE" >> $TMPDIR/section.$1
			break
			#SectionFlag=0
		fi

		if [ $SectionFlag -eq 1 ]; then
			if [ "$CONFLINE" == "Section \"$1\"" ]; then
				echo "$CONFLINE" >> $TMPDIR/section.$1
			elif [ "${CONFLINE:0:1}" != "#" ]; then
				echo -e "\t$CONFLINE" >> $TMPDIR/section.$1
			fi
		fi
	done < $XORG_CONF_NEW

	case "$1" in
		"Files")
			if [ "$2" == "-1box" ]; then
				SECTION_FILES="Section \"Files\""
				MODULEPATH="ModulePath\t\"\/opt\/MX11R6\/$LIB\/modules\""
				sed -i -e "s/$SECTION_FILES/$SECTION_FILES\n\t$MODULEPATH/" $TMPDIR/section.$1
			else
				:
			fi

			;;

		"Module")
			SECTION_MODULE="Section \"Module\""
			XFree86_DGA="SubSection \"extmod\"\n\t\tOption \"omit XFree86-DGA\"\n\tEndSubSection"
			sed -i -e "/\"vnc\"/d" $TMPDIR/section.$1
			sed -i -e "/\"dri\"/d" $TMPDIR/section.$1
			sed -i -e "/\"glx\"/d" $TMPDIR/section.$1
			sed -i -e "s/$SECTION_MODULE/$SECTION_MODULE\n\t$XFree86_DGA/" $TMPDIR/section.$1
			;;

		"Monitor")
			sed -i -e "/\"DPMS\"/d" $TMPDIR/section.$1
			;;
		*)
			:
			;;
	esac
}

function get_section_Device()
{
	# Initialize
	SectionFlag=0
	: > $TMPDIR/section.Device

	while read CONFLINE; do
		if [ "$CONFLINE" == "Section \"Device\"" ]; then
			SectionFlag=1
			continue
		elif [ $SectionFlag -eq 1 -a "$CONFLINE" == "EndSection" ]; then
			echo "$BUSID^$VENDORNAME^$BOARDNAME^$DRIVER" >> $TMPDIR/section.Device
			SectionFlag=0
		fi

		if [ $SectionFlag -eq 1 ]; then
			if [ "${CONFLINE:0:1}" != "#" ]; then
				CONFLINE=`echo $CONFLINE` # remove redundent spaces
				CONFLINE=${CONFLINE/[[:space:]]/=}
				
				NAME=`echo $CONFLINE | awk -F'=' '{print $1}'`
				case "$NAME" in
					"Driver")
						DRIVER=`echo $CONFLINE | awk -F'=' '{print $2}'`
						DRIVER=${DRIVER//\"/}  # strip "
						;;
					"VendorName")
						VENDORNAME=`echo $CONFLINE | awk -F'=' '{print $2}'`
						VENDORNAME=${VENDORNAME//\"/} # strip "
						;;
					"BoardName")
						BOARDNAME=`echo $CONFLINE | awk -F'=' '{print $2}'`
						BOARDNAME=${BOARDNAME//\"/} # strip "
						;;
					"BusID")
						BUSID=`echo $CONFLINE | awk -F'=' '{print $2}'`
						BUSID=${BUSID//\"/} # strip "
						BUSID=${BUSID#PCI:} # strip 
						;;
					*)
						:
						;;
				esac
			fi
		fi
	done < $XORG_CONF_NEW
}

function dissect_xorg_conf_new()
{
	# take Files, Module, Monitor section
	for C in Files Module Monitor ; do
		get_section $C $1
	done
	
	# take Device section
	get_section_Device
}

function usage()
{
	echo "Usage:"	
	echo "$0 <config type>"	
	echo "		-1box		create config-file for 1Box-Server"
	echo "		-check		create config-file for checking dual-head"
	echo "		-one		create one head config-file for normal X"
	echo "		-all		create all heads config-file for normal X"
	exit 1
}

################
# start here...
################
echo -e "\n(--) dm-gen-xconfig.sh $1: create X config file  `date`" >> $logfile

if [ $# != 1 ]; then
	echo "(EE) No argument provided for dm-gen-config.sh" >> $logfile
	usage $0
fi

if [ "$1" != "-1box" ] && [ "$1" != "-check" ] && \
	[ "$1" != "-one" ] && [ "$1" != "-all" ]; then
	echo "(EE) Invalid argument for dm-gen-config.sh" >> $logfile
	usage $0
fi

# check LIB
if [ -d /opt/MX11R6/lib64 ]; then
	LIB="lib64"
fi

# set MAXSTATIONS
if [ -e /etc/userful/dm-max-stations ]; then
    source /etc/userful/dm-max-stations
else
    date >> $logfile
	echo "(EE) /etc/userful/dm-max-stations doesn't exist" >> $logfile
    exit 1
fi

# Initialize STATION_TYPE based on MAXSTATIONS
for (( i=0; i<$MAXSTATIONS; i++ )); do
	STATION_TYPE[$i]=S
done

if [ -f /etc/userful/os-info ]; then
	source /etc/userful/os-info
else
	echo "(EE) /etc/userful/os-info is not available" >> $logfile
	exit 1
fi
if [ -f /etc/dm-sys-info ]; then
	source /etc/dm-sys-info # config-message creates this fils.
else

	if [ "$1" == "-1box" ]; then
		echo "(WW) /etc/dm-sys-info is not available. Use default values." >> $logfile
	fi

	# By default: DestkopTop, 1024x768, no dualview
	SYS_TYPE=0
	SYS_RESOLUTION=3
	SYS_DUALVIEW=0
fi

# check if the nvidia driver exist
if [ -f /usr/lib/xorg/modules/drivers/nvidia_drv.o -o \
	-f /usr/lib64/xorg/modules/drivers/nvidia_drv.o -o \
	-f /usr/X11R6/lib/modules/drivers/nvidia_drv.o -o \
	-f /usr/X11R6/lib64/modules/drivers/nvidia_drv.o ]; then 
	NVIDIA_DRIVER=1  #exist
else
	NVIDIA_DRIVER=0
fi

if [ -f $XORG_CONF_NEW ]; then
	dissect_xorg_conf_new $1
else
	echo "(EE) $XORG_CONF_NEW is not available" >> $logfile
	exit 1
fi
 
gen_Header $1
gen_section_Files $1
gen_section_ServerFlags $1
gen_section_Module $1
gen_section_Monitor $1
gen_section_Device $1

if [ "$1" != "-check" ]; then
	gen_section_Screen $1
	gen_InputDevice_kbd $1
	gen_InputDevice_mse $1
	gen_InputDevice_touch $1
	gen_section_ServerLayout $1
	reconf_files $1
fi

# clean all the temp files
rm -f $TMPDIR/tmpconfig $TMPDIR/base-tmpconfig $TMPDIR/videolist
