#
# File:          IntegerContainer_Impl.py
# Symbol:        sort.IntegerContainer-v0.1
# Symbol Type:   class
# Babel Version: 0.8.8
# Description:   Implementation of SIDL class sort.IntegerContainer in Python.
# 
# WARNING: Automatically generated; changes will be lost
# 
# babel-version = 0.8.8
#


"""Integer container.
"""

# DO-NOT-DELETE splicer.begin(_initial)
# Put your code here...
# DO-NOT-DELETE splicer.end(_initial)

import SIDL.BaseInterface
import SIDL.BaseClass
import sort.Comparator
import SIDL.ClassInfo
import sort.IntegerContainer
import sort.Container

# DO-NOT-DELETE splicer.begin(_before_type)
from Numeric import *
import sort.Integer
import random

try:
  # available in 2.0 and later
  shuffle = random.shuffle
except AttributeError:
  def shuffle(x):
    for i in xrange(len(x)-1, 0, -1):
      j = random.randint(0, i)
      x[i], x[j] = x[j], x[i]
# DO-NOT-DELETE splicer.end(_before_type)

class IntegerContainer:
  """\
Integer container.
"""

  # All calls to SIDL methods should use __IORself

  def __init__(self, IORself):
    self.__IORself = IORself
    # DO-NOT-DELETE splicer.begin(__init__)
    self.d_elements = None
    # DO-NOT-DELETE splicer.end(__init__)

  def setLength(self, len):
    #
    # SIDL EXPECTED INCOMING TYPES
    # ============================
    # int len
    #

    #
    # SIDL EXPECTED RETURN VALUE(s)
    # =============================
    # # None
    #

    """\
This sets the container length and pseudo-randomly orders the
Integer elements contained.
"""
    # DO-NOT-DELETE splicer.begin(setLength)
    # create a 1-d Numeric Python array with size objects
    self.d_elements = zeros((len,), PyObject)
    for i in xrange(len):
      self.d_elements[i] = sort.Integer.Integer()
      self.d_elements[i].setValue(i+1)
    shuffle(self.d_elements)
    # DO-NOT-DELETE splicer.end(setLength)

  def getLength(self):
    #
    # SIDL EXPECTED RETURN VALUE(s)
    # =============================
    # int _return
    #

    """\
Return the number of elements in the container.
"""
    # DO-NOT-DELETE splicer.begin(getLength)
    if self.d_elements:
      return self.d_elements.shape[0]
    else:
      return 0
    # DO-NOT-DELETE splicer.end(getLength)

  def compare(self, i, j, comp):
    #
    # SIDL EXPECTED INCOMING TYPES
    # ============================
    # int i
    # int j
    # sort.Comparator comp
    #

    #
    # SIDL EXPECTED RETURN VALUE(s)
    # =============================
    # int _return
    #

    """\
Return -1 if element i is less than element j, 0 if element i
is equal to element j, or otherwise 1.
"""
    # DO-NOT-DELETE splicer.begin(compare)
    size = self.__IORself.getLength()
    result = 0
    if ((0 <= i < size) and (0 <= j < size)):
      i1 = SIDL.BaseInterface.BaseInterface(self.d_elements[i])
      i2 = SIDL.BaseInterface.BaseInterface(self.d_elements[j])
      result = comp.compare(i1, i2)
    return result
    # DO-NOT-DELETE splicer.end(compare)

  def swap(self, i, j):
    #
    # SIDL EXPECTED INCOMING TYPES
    # ============================
    # int i
    # int j
    #

    #
    # SIDL EXPECTED RETURN VALUE(s)
    # =============================
    # # None
    #

    """\
Swap elements i and j.
"""
    # DO-NOT-DELETE splicer.begin(swap)
    size = self.__IORself.getLength()
    if ((0 <= i < size) and (0 <= j < size)):
      self.d_elements[i], self.d_elements[j] = \
           self.d_elements[j], self.d_elements[i]
    # DO-NOT-DELETE splicer.end(swap)

  def output(self, s, e):
    #
    # SIDL EXPECTED INCOMING TYPES
    # ============================
    # int s
    # int e
    #

    #
    # SIDL EXPECTED RETURN VALUE(s)
    # =============================
    # # None
    #

    """\
Print elements s through e-1
"""
    # DO-NOT-DELETE splicer.begin(output)
    size = self.__IORself.getLength()
    print "COMMENT: list",
    for i in xrange(size):
      print " ", self.d_elements[i],
    print "\n"
    # DO-NOT-DELETE splicer.end(output)

# DO-NOT-DELETE splicer.begin(_final)
# Put your code here...
# DO-NOT-DELETE splicer.end(_final)
