// 
// File:          sort_IntegerContainer_Impl.cc
// Symbol:        sort.IntegerContainer-v0.1
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for sort.IntegerContainer
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 
#include "sort_IntegerContainer_Impl.hh"

// DO-NOT-DELETE splicer.begin(sort.IntegerContainer._includes)
#include <iostream>
// DO-NOT-DELETE splicer.end(sort.IntegerContainer._includes)

// user defined constructor
void sort::IntegerContainer_impl::_ctor() {
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer._ctor)
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer._ctor)
}

// user defined destructor
void sort::IntegerContainer_impl::_dtor() {
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer._dtor)
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer._dtor)
}

// user defined static methods: (none)

// user defined non-static methods:
/**
 * This sets the container length and pseudo-randomly orders the
 * Integer elements contained.
 */
void
sort::IntegerContainer_impl::setLength (
  /*in*/ int32_t len ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.setLength)
  int32_t i, j;
  d_elements = SIDL::array<sort::Integer>::create1d(len);
  for(i = 0; i < len; ++i){
    sort::Integer intObj = sort::Integer::_create();
    intObj.setValue(i);
    d_elements.set(i, intObj);
  }
  for(i = len - 1; i > 0; --i) {
    j = random() % (i + 1);
    if (j != i) {
      self.swap(i, j);
    }
  }
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.setLength)
}

/**
 * Return the number of elements in the container.
 */
int32_t
sort::IntegerContainer_impl::getLength () 
throw () 

{
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.getLength)
  return 1 + d_elements.upper(0) - d_elements.lower(0);
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.getLength)
}

/**
 * Return -1 if element i is less than element j, 0 if element i
 * is equal to element j, or otherwise 1.
 */
int32_t
sort::IntegerContainer_impl::compare (
  /*in*/ int32_t i,
  /*in*/ int32_t j,
  /*in*/ ::sort::Comparator comp ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.compare)
  SIDL::BaseInterface i1(d_elements.get(i));
  SIDL::BaseInterface i2(d_elements.get(j));
  return comp.compare(i1, i2);
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.compare)
}

/**
 * Swap elements i and j.
 */
void
sort::IntegerContainer_impl::swap (
  /*in*/ int32_t i,
  /*in*/ int32_t j ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.swap)
  const int32_t len = self.getLength();
  if (i >= 0 && j >= 0 && i < len && j < len) {
    sort::Integer 
      i1(d_elements.get(i)),
      i2(d_elements.get(j));
    d_elements.set(i, i2);
    d_elements.set(j, i1);
  }
  else {
    std::cerr << "sort::IntegerContainer::swap index out of bounds swap ("
	      << i << ", " << j << ") len (" << len << ")" << std::endl;
    exit(2);
  }
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.swap)
}

/**
 * Print elements s through e-1
 */
void
sort::IntegerContainer_impl::output (
  /*in*/ int32_t s,
  /*in*/ int32_t e ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(sort.IntegerContainer.output)
  std::cout << "COMMENT: list";
  while (s < e) {
    std::cout << ' ' << d_elements.get(s++).getValue();
  }
  std::cout << '\n';
  // DO-NOT-DELETE splicer.end(sort.IntegerContainer.output)
}


// DO-NOT-DELETE splicer.begin(sort.IntegerContainer._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.IntegerContainer._misc)

