// 
// File:          Ordering_IntOrderTest_Impl.cc
// Symbol:        Ordering.IntOrderTest-v0.1
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for Ordering.IntOrderTest
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 
#include "Ordering_IntOrderTest_Impl.hh"

// DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._includes)
#include "SIDL_int_IOR.h"
#include <stdlib.h>

static int32_t
iFunc(const int32_t *ind, const int32_t dim)
{
  int32_t result = 0;
  int32_t i;
  for(i = 0; i < dim ; ++i) {
    result += (i+1)*ind[i];
  }
  return result;
}

static int
incIndex(int32_t ind[], const struct SIDL_int__array* A, const int32_t dimen)
{
  int32_t i = 0;
  while (i < dimen) {
    if (++(ind[i]) > SIDLUpper(A, i)) {
      ind[i] = SIDLLower(A, i);
      ++i;
    }
    else {
      return TRUE;
    }
  }
  /* we're all done */
  return FALSE;
}

static SIDL_bool
isIMatrix(const struct SIDL_int__array* A)
{
  if (A) {
    const int32_t dimen = SIDL_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = (int32_t*)malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = SIDLLower(A, i);
      if (SIDLLower(A,i) > SIDLUpper(A,i)) {
        free(cindex);
        return TRUE;
      }
    }
    do {
      if (iFunc(cindex, dimen) != SIDL_int__array_get(A, cindex)) {
        free(cindex);
        return FALSE;
      }
    } while (incIndex(cindex, A, dimen));
    free(cindex);
    return TRUE;
  }
  return FALSE;
}

static void
fillIMatrix(struct SIDL_int__array* A)
{
  if (A) {
    const int32_t dimen = SIDL_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = (int32_t*)malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = SIDLLower(A, i);
      if (SIDLLower(A,i) > SIDLUpper(A,i)){
        free(cindex);
        return;
      }
    }
    do {
      SIDL_int__array_set(A, cindex, iFunc(cindex, dimen));
    } while (incIndex(cindex, A, dimen));
    free(cindex);
  }
}
// DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._includes)

// user defined constructor
void Ordering::IntOrderTest_impl::_ctor() {
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._ctor)
}

// user defined destructor
void Ordering::IntOrderTest_impl::_dtor() {
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._dtor)
}

// user defined static methods:
/**
 * Create a column-major matrix satisfying condition I.
 */
::SIDL::array<int32_t>
Ordering::IntOrderTest_impl::makeColumnIMatrix (
  /*in*/ int32_t size,
  /*in*/ bool useCreateCol ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeColumnIMatrix)
  SIDL::array<int32_t> result;
  if (useCreateCol) {
    result = SIDL::array<int32_t>::create2dCol(size, size);
  }
  else {
    result = SIDL::array<int32_t>::create2dRow(size, size);
  }
  fillIMatrix(result._get_ior());
  return result;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeColumnIMatrix)
}

/**
 * Create a row-major matrix satisfying condition I.
 */
::SIDL::array<int32_t>
Ordering::IntOrderTest_impl::makeRowIMatrix (
  /*in*/ int32_t size,
  /*in*/ bool useCreateRow ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeRowIMatrix)
  SIDL::array<int32_t> result;
  if (useCreateRow) {
    result = SIDL::array<int32_t>::create2dRow(size, size);
  }
  else {
    result = SIDL::array<int32_t>::create2dCol(size, size);
  }
  fillIMatrix(result._get_ior());
  return result;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeRowIMatrix)
}

/**
 * Create a 4-D matrix satisfying condition I.  Each dimension has
 * size elements numbers 0 through size-1.
 */
::SIDL::array<int32_t>
Ordering::IntOrderTest_impl::makeIMatrix (
  /*in*/ int32_t size,
  /*in*/ bool useCreateColumn ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeIMatrix)
  SIDL::array<int32_t> result;
  static const int lower[4] = { 0, 0, 0, 0};
  const int upper[4] = { size - 1, size - 1, size -1, size - 1};
  if (useCreateColumn) {
    result = SIDL::array<int32_t>::createCol(4, lower, upper);
  }
  else {
    result = SIDL::array<int32_t>::createRow(4, lower, upper);
  }
  fillIMatrix(result._get_ior());
  return result;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeIMatrix)
}

/**
 * Create a column-major matrix satisfying condition I.
 */
void
Ordering::IntOrderTest_impl::createColumnIMatrix (
  /*in*/ int32_t size,
  /*in*/ bool useCreateCol,
  /*out*/ ::SIDL::array<int32_t>& result ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createColumnIMatrix)
  if (useCreateCol){
    result = Ordering::IntOrderTest::makeColumnIMatrix(size, true);
  }
  else {
    result = Ordering::IntOrderTest::makeRowIMatrix(size, true);
  }
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createColumnIMatrix)
}

/**
 * Create a row-major matrix satisfying condition I.
 */
void
Ordering::IntOrderTest_impl::createRowIMatrix (
  /*in*/ int32_t size,
  /*in*/ bool useCreateRow,
  /*out*/ ::SIDL::array<int32_t>& result ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createRowIMatrix)
  if (useCreateRow){
    result = Ordering::IntOrderTest::makeRowIMatrix(size, true);
  }
  else {
    result = Ordering::IntOrderTest::makeColumnIMatrix(size, true);
  }
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createRowIMatrix)
}

/**
 * Make sure an array is column-major.  No changes to the dimension or
 * values in a are made.
 */
void
Ordering::IntOrderTest_impl::ensureColumn (
  /*inout*/ ::SIDL::array<int32_t>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureColumn)
  /* no action required */
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureColumn)
}

/**
 * Make sure an array is row-major.  No changes to the dimension or
 * values in a are made.
 */
void
Ordering::IntOrderTest_impl::ensureRow (
  /*inout*/ ::SIDL::array<int32_t>& a ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureRow)
  /* no action required */
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureRow)
}

/**
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isIMatrixOne (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixOne)
  return isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixOne)
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isColumnIMatrixOne (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixOne)
  return A.isColumnOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixOne)
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isRowIMatrixOne (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixOne)
  bool i = A.isRowOrder();
  bool j = isIMatrix(A._get_ior());
  return (i && j);
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixOne)
}

/**
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isIMatrixTwo (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixTwo)
  return isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixTwo)
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isColumnIMatrixTwo (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixTwo)
  return A.isColumnOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixTwo)
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isRowIMatrixTwo (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixTwo)
  bool i = A.isRowOrder();
  bool j = isIMatrix(A._get_ior());
  return (i && j);
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixTwo)
}

/**
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isIMatrixFour (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixFour)
  return isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixFour)
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isColumnIMatrixFour (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixFour)
  return A.isColumnOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixFour)
}

/**
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */
bool
Ordering::IntOrderTest_impl::isRowIMatrixFour (
  /*in*/ ::SIDL::array<int32_t> A ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixFour)
  return A.isRowOrder() && isIMatrix(A._get_ior());
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixFour)
}

/**
 * Return <code>true</code> iff the implementation of slice
 * and smart copy is correct.
 */
bool
Ordering::IntOrderTest_impl::isSliceWorking (
  /*in*/ bool useCreateCol ) 
throw () 
{
  // DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isSliceWorking)
  bool result = true;
  const int32_t maxDim = 16;
  const int32_t halfDim = maxDim >> 1;
  SIDL::array<int32_t> A, B;
  int32_t ind[2];
  int32_t stride[2] = {2, 2};
  int32_t numElem[2] = {halfDim, halfDim};
  int32_t newIndex[2];
  if (useCreateCol) {
    A = Ordering::IntOrderTest::makeColumnIMatrix(maxDim,false);
  }
  else {
    A = Ordering::IntOrderTest::makeRowIMatrix(maxDim,FALSE);
  }
  B = A.slice(2, numElem, 0, stride);
  if (!(B._not_nil() && B.dimen() == 2)) {
    result = false;
  }
  for(ind[1] = newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((B.get(newIndex) != iFunc(ind,2)) ||
          (SIDLArrayAddr2(B._get_ior(), newIndex[0], newIndex[1]) !=
           SIDLArrayAddr2(A._get_ior(), ind[0], ind[1]))) {
        result = false;
      }
    }
  }

  ind[0] = ind[1] = 1;
  newIndex[0] = newIndex[1] = 0;
  B = A.slice(2, numElem, ind, stride, newIndex);
  if (!(B._not_nil() && B.dimen() == 2)) {
    result = false;
  }
  for(newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((B.get(newIndex) != iFunc(ind,2)) ||
          (SIDLArrayAddr2(B._get_ior(), newIndex[0], newIndex[1]) !=
           SIDLArrayAddr2(A._get_ior(), ind[0], ind[1]))) {
        result = FALSE;
      }
    }
  }

  ind[0] = ind[1] = 1;
  newIndex[1] = newIndex[0] = 1;
  B= A.slice(2, numElem, ind, stride, newIndex);
  if (!(B._not_nil() && B.dimen() == 2)) {
    result = false;
  }
  for(newIndex[1] = 1; newIndex[1] <= halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 1; newIndex[0] <= halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((B.get(newIndex) != iFunc(ind,2)) ||
          (SIDLArrayAddr2(B._get_ior(), newIndex[0], newIndex[1]) != 
           SIDLArrayAddr2(A._get_ior(), ind[0], ind[1]))){
        result = false;
      }
    }
  }

  numElem[0] = 0;
  numElem[1] = maxDim;
  B = A.slice(1, numElem);
  if (!(B._not_nil() && B.dimen() == 1)) {
    result = false;
  }
  ind[0] = newIndex[0] = 0;
  for(ind[1] = newIndex[1] = 0; newIndex[1] < maxDim; 
      ++newIndex[1], ++ind[1]) {
    if (SIDLArrayAddr1(B._get_ior(), newIndex[1]) != 
        SIDLArrayAddr2(A._get_ior(), ind[0], ind[1])) {
      result = false;
    }
  }
  
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 8;
  newIndex[0] = newIndex[1] = 0;
  B = A.slice(1, numElem, ind, NULL, newIndex);
  if (!(B._not_nil() && (B.dimen() == 1))) {
    result = false;
  }
  for(ind[0] = newIndex[0] = 0; newIndex[0] < maxDim; 
      ++newIndex[0], ++ind[0]) {
    if (SIDLArrayAddr1(B._get_ior(), newIndex[0]) != 
        SIDLArrayAddr2(A._get_ior(), ind[0], ind[1])) {
      result = false;
    }
  }
  
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 0;
  B = A.slice(1, numElem, ind);
  if (!(B._not_nil() && (B.dimen() == 1))) {
    result = false;
  }
  if (!(Ordering::IntOrderTest::isIMatrixOne(B) &&
        Ordering::IntOrderTest::isColumnIMatrixOne(B) &&
        Ordering::IntOrderTest::isRowIMatrixOne(B))) {
    result = false;
  }
        
  
  if (B._not_nil()) B.deleteRef();
  if (A._not_nil()) A.deleteRef();
  return result;
  // DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isSliceWorking)
}


// user defined non-static methods: (none)

// DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._misc)

