// 
// File:          objarg_Employee_Impl.hh
// Symbol:        objarg.Employee-v0.5
// Symbol Type:   class
// Babel Version: 0.8.8
// Description:   Server-side implementation for objarg.Employee
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.8.8
// 

#ifndef included_objarg_Employee_Impl_hh
#define included_objarg_Employee_Impl_hh

#ifndef included_SIDL_cxx_hh
#include "SIDL_cxx.hh"
#endif
#ifndef included_objarg_Employee_IOR_h
#include "objarg_Employee_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_SIDL_BaseInterface_hh
#include "SIDL_BaseInterface.hh"
#endif
#ifndef included_SIDL_ClassInfo_hh
#include "SIDL_ClassInfo.hh"
#endif
#ifndef included_objarg_Employee_hh
#include "objarg_Employee.hh"
#endif


// DO-NOT-DELETE splicer.begin(objarg.Employee._includes)
// Put additional includes or other arbitrary code here...
// DO-NOT-DELETE splicer.end(objarg.Employee._includes)

namespace objarg { 

  /**
   * Symbol "objarg.Employee" (version 0.5)
   * 
   * This object type holds the basic information about an employee:
   * name, age, salary and marital status.  This object exists purely
   * to serve as a test case for SIDL.  It is not intended for serious
   * use.
   */
  class Employee_impl
  // DO-NOT-DELETE splicer.begin(objarg.Employee._inherits)
  // Put additional inheritance here...
  // DO-NOT-DELETE splicer.end(objarg.Employee._inherits)
  {

  private:
    // Pointer back to IOR.
    // Use this to dispatch back through IOR vtable.
    Employee self;

    // DO-NOT-DELETE splicer.begin(objarg.Employee._implementation)
    int32_t d_age;
    std::string d_name;
    float d_salary;
    char d_status;
    // DO-NOT-DELETE splicer.end(objarg.Employee._implementation)

  private:
    // private default constructor (required)
    Employee_impl() {} 

  public:
    // SIDL constructor (required)
    // Note: alternate Skel constructor doesn't call addref()
    // (fixes bug #275)
    Employee_impl( struct objarg_Employee__object * s ) : self(s,
      true) { _ctor(); }

    // user defined construction
    void _ctor();

    // virtual destructor (required)
    virtual ~Employee_impl() { _dtor(); }

    // user defined destruction
    void _dtor();

  public:


    /**
     * Provide the data for the employee object to hold.
     * <code>false</code> is returned when the data was unacceptable.
     * <code>true</code> means the employee object was successfully
     * initialized.
     */
    bool
    init (
      /*in*/ const ::std::string& name,
      /*in*/ int32_t age,
      /*in*/ float salary,
      /*in*/ char status
    )
    throw () 
    ;


    /**
     * Change the name of an employee.
     */
    void
    setName (
      /*in*/ const ::std::string& name
    )
    throw () 
    ;


    /**
     * Return the name of an employee.
     */
    ::std::string
    getName() throw () 
    ;

    /**
     * Change the age of an employee.
     */
    void
    setAge (
      /*in*/ int32_t age
    )
    throw () 
    ;


    /**
     * Return the age of an employee.
     */
    int32_t
    getAge() throw () 
    ;

    /**
     * Set an employee's salary.
     */
    void
    setSalary (
      /*in*/ float salary
    )
    throw () 
    ;


    /**
     * Return an employee's salary.
     */
    float
    getSalary() throw () 
    ;

    /**
     * Set an employee's marital status.
     */
    void
    setStatus (
      /*in*/ char status
    )
    throw () 
    ;


    /**
     * Return an employee's marital status.
     */
    char
    getStatus() throw () 
    ;
  };  // end class Employee_impl

} // end namespace objarg

// DO-NOT-DELETE splicer.begin(objarg.Employee._misc)
// Put miscellaneous things here...
// DO-NOT-DELETE splicer.end(objarg.Employee._misc)

#endif
