/*
 * File:          objarg_Employee_Impl.c
 * Symbol:        objarg.Employee-v0.5
 * Symbol Type:   class
 * Babel Version: 0.8.8
 * Description:   Server-side implementation for objarg.Employee
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.8.8
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "objarg.Employee" (version 0.5)
 * 
 * This object type holds the basic information about an employee:
 * name, age, salary and marital status.  This object exists purely
 * to serve as a test case for SIDL.  It is not intended for serious
 * use.
 */

#include "objarg_Employee_Impl.h"

/* DO-NOT-DELETE splicer.begin(objarg.Employee._includes) */
#include <stdlib.h>
#include "SIDL_String.h"
/* DO-NOT-DELETE splicer.end(objarg.Employee._includes) */

/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee__ctor"

void
impl_objarg_Employee__ctor(
  objarg_Employee self)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee._ctor) */
  struct objarg_Employee__data *dptr = 
    malloc(sizeof(struct objarg_Employee__data));
  if (dptr) {
    dptr->d_name = NULL;
    dptr->d_salary = 0;
    dptr->d_status = '\0';
    dptr->d_age = 0;
  }
  objarg_Employee__set_data(self, dptr);
  /* DO-NOT-DELETE splicer.end(objarg.Employee._ctor) */
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee__dtor"

void
impl_objarg_Employee__dtor(
  objarg_Employee self)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee._dtor) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    SIDL_String_free((char *)dptr->d_name);
    dptr->d_name = NULL;
    free((void*)dptr);
    objarg_Employee__set_data(self, NULL);
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee._dtor) */
}

/*
 * Provide the data for the employee object to hold.
 * <code>false</code> is returned when the data was unacceptable.
 * <code>true</code> means the employee object was successfully
 * initialized.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_init"

SIDL_bool
impl_objarg_Employee_init(
  objarg_Employee self, const char* name, int32_t age, float salary,
    char status)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.init) */
  objarg_Employee_setName(self, name);
  objarg_Employee_setAge(self, age);
  objarg_Employee_setSalary(self, salary);
  objarg_Employee_setStatus(self, status);
  return TRUE;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.init) */
}

/*
 * Change the name of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setName"

void
impl_objarg_Employee_setName(
  objarg_Employee self, const char* name)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setName) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_name = SIDL_String_strdup(name);
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setName) */
}

/*
 * Return the name of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getName"

char*
impl_objarg_Employee_getName(
  objarg_Employee self)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getName) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? SIDL_String_strdup(dptr->d_name) : 0;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getName) */
}

/*
 * Change the age of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setAge"

void
impl_objarg_Employee_setAge(
  objarg_Employee self, int32_t age)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setAge) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_age = age;
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setAge) */
}

/*
 * Return the age of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getAge"

int32_t
impl_objarg_Employee_getAge(
  objarg_Employee self)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getAge) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? dptr->d_age : 0;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getAge) */
}

/*
 * Set an employee's salary.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setSalary"

void
impl_objarg_Employee_setSalary(
  objarg_Employee self, float salary)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setSalary) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_salary = salary;
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setSalary) */
}

/*
 * Return an employee's salary.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getSalary"

float
impl_objarg_Employee_getSalary(
  objarg_Employee self)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getSalary) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? dptr->d_salary : 0;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getSalary) */
}

/*
 * Set an employee's marital status.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setStatus"

void
impl_objarg_Employee_setStatus(
  objarg_Employee self, char status)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setStatus) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_status = status;
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setStatus) */
}

/*
 * Return an employee's marital status.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getStatus"

char
impl_objarg_Employee_getStatus(
  objarg_Employee self)
{
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getStatus) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? dptr->d_status : '\0';
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getStatus) */
}
