#
# File:          ArrayOps_Impl.py
# Symbol:        ArrayTest.ArrayOps-v1.2
# Symbol Type:   class
# Babel Version: 0.8.8
# Description:   Implementation of SIDL class ArrayTest.ArrayOps in Python.
# 
# WARNING: Automatically generated; changes will be lost
# 
# babel-version = 0.8.8
#


# DO-NOT-DELETE splicer.begin(_initial)
import Numeric
print "Hello world"
stringData = ( "I'd", "rather", "write", "programs", "to", "write",
               "programs", "than", "write", "programs." )
stringDataLen = len(stringData)
              

charData = "I'd rather write programs to write programs than write programs."
charDataLen = len(charData)

def powTwo(i):
    result = 1.0
    if (i >= 0):
      while (i):
        result = result *2
        i = i - 1
    else:
      while (i):
        result = result * 0.5
        i = i + 1
    return result

def powTwoF(i):
  result = Numeric.zeros((1,), Numeric.Float32)
  result.savespace(1)
  result[0] = powTwo(i)
  return result[0]

def isEven(num):
  return (num & 1) == 0

def isPrime(num):
  i = 3l
  while (i*i <= num):
    if ((num % i) == 0):
      return 0
    i = i + 1
  return 1

def nextPrime(prev):
  if (prev <= 1l):
    return 2l
  else:
    if (prev == 2l):
      return 3l
    else:
      prev = prev + 2l
      while (not isPrime(prev)):
        prev = prev + 2l
  return prev

def reverseArray(array, newArray):
  if (newArray):
    copy = Numeric.zeros(array.shape, array.typecode())
    copy.savespace(1)
    for i in range(array.shape[0]):
      copy[-(i+1)] = array[i]
  else:
    for i in range(array.shape[0] >> 1):
      array[-(i+1)], array[i] =  array[i], array[-(i+1)]
    copy = array
  return 1, copy

def arrayValue(l):
  result = 1
  add = 1
  for i in l:
    result = result * (i + add)
    add = add + 1
  return result
# DO-NOT-DELETE splicer.end(_initial)

import ArrayTest.ArrayOps
import SIDL.BaseInterface
import SIDL.BaseClass
import SIDL.ClassInfo

# DO-NOT-DELETE splicer.begin(_before_static)
# Put your code here...
# DO-NOT-DELETE splicer.end(_before_static)

def checkBool(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<bool> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  """\
Return <code>true</code> iff the even elements are true and
the odd elements are false.
"""
  # DO-NOT-DELETE splicer.begin(checkBool)
  if (a and len(a.shape) == 1):
    for i in range(a.shape[0]):
      if (a[i] != isEven(i)):
        return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkBool)

def checkChar(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<char> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkChar)
  if (a and len(a.shape) == 1):
    for i in range(a.shape[0]):
      if (a[i] != charData[i % charDataLen]):
        return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkChar)

def checkInt(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkInt)
  if (a and (len(a.shape) == 1)):
    prime = nextPrime(0)
    for i in range(a.shape[0]):
      if (a[i] != prime):
        return 0
      prime = nextPrime(prime)
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkInt)

def checkLong(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<long> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkLong)
  if (a and (len(a.shape) == 1)):
    prime = nextPrime(0)
    for i in range(a.shape[0]):
      if (a[i] != prime):
        return 0
      prime = nextPrime(prime)
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkLong)

def checkString(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<string> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkString)
  if (a and len(a.shape) == 1):
    for i in range(a.shape[0]):
      if (a[i] != stringData[i % stringDataLen]):
        return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkString)

def checkDouble(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<double> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkDouble)
  if (a and len(a.shape) == 1):
    for i in range(a.shape[0]):
      if (a[i] != powTwo(-i)):
        return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkDouble)

def checkFloat(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<float> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkFloat)
  if (a and len(a.shape) == 1):
    for i in range(a.shape[0]):
      if (a[i] != powTwoF(-i)):
        return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkFloat)

def checkFcomplex(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<fcomplex> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkFcomplex)
  if (a and len(a.shape) == 1):
    for i in range(a.shape[0]):
      if (not ((a[i].real == powTwoF(i)) and (a[i].imag == powTwoF(-i)))):
        return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkFcomplex)

def checkDcomplex(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<dcomplex> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(checkDcomplex)
  if (a and len(a.shape) == 1):
    for i in range(a.shape[0]):
      if (not ((a[i].real == powTwo(i)) and (a[i].imag == powTwo(-i)))):
        return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(checkDcomplex)

def check2Int(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,2> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(check2Int)
  if (a and len(a.shape) == 2):
    for i in range(a.shape[0]):
      for j in range(a.shape[1]):
        if (a[i,j] != powTwo(abs(i-j))):
          return 0
    return 1
  return 0
  # DO-NOT-DELETE splicer.end(check2Int)

def check2Double(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<double,2> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(check2Double)
  if (a and (len(a.shape) == 2)):
    for i in range(a.shape[0]):
      for j in range(a.shape[1]):
        if (a[i,j] != powTwo(i-j)):
            return 0
  else:
    return 0
  return 1
  # DO-NOT-DELETE splicer.end(check2Double)

def check2Float(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<float,2> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(check2Float)
  if (a and (len(a.shape) == 2)):
    for i in range(a.shape[0]):
      for j in range(a.shape[1]):
        if (a[i,j] != powTwoF(i-j)):
            return 0
  else:
    return 0
  return 1
  # DO-NOT-DELETE splicer.end(check2Float)

def check2Fcomplex(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<fcomplex,2> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(check2Fcomplex)
  if (a and (len(a.shape) == 2)):
      for i in range(a.shape[0]):
          for j in range(a.shape[1]):
              if ((a[i,j].real != powTwoF(i)) or
                  (a[i,j].imag != powTwoF(-j))):
                return 0
  else:
    return 0
  return 1
  # DO-NOT-DELETE splicer.end(check2Fcomplex)

def check2Dcomplex(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<dcomplex,2> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(check2Dcomplex)
  if (a and (len(a.shape) == 2)):
      for i in range(a.shape[0]):
          for j in range(a.shape[1]):
              if ((a[i,j].real != powTwo(i)) or
                  (a[i,j].imag != powTwo(-j))):
                return 0
  else:
    return 0
  return 1
  # DO-NOT-DELETE splicer.end(check2Dcomplex)

def check3Int(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,3> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(check3Int)
  if (a and (len(a.shape) == 3)):
    for i in range(a.shape[0]):
      for j in range(a.shape[1]):
        for k in range(a.shape[2]):
          if (a[i,j,k] != arrayValue((i,j,k))):
            return 0
  else:
    return 0
  return 1
  # DO-NOT-DELETE splicer.end(check3Int)

def check4Int(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,4> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # bool _return
  #

  # DO-NOT-DELETE splicer.begin(check4Int)
  if (a and (len(a.shape) == 4)):
    for i in range(a.shape[0]):
      for j in range(a.shape[1]):
        for k in range(a.shape[2]):
          for l in range(a.shape[3]):
            if (a[i,j,k,l] != arrayValue((i,j,k,l))):
              return 0
  else:
    return 0
  return 1
  # DO-NOT-DELETE splicer.end(check4Int)

def checkObject(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<ArrayTest.ArrayOps> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # int _return
  #

  # DO-NOT-DELETE splicer.begin(checkObject)
  count = 0
  if (a and (len(a.shape) == 1)):
    for i in range(a.shape[0]):
      obj = a[i]
      if (obj and ArrayTest.ArrayOps.ArrayOps(obj)):
        count = count + 1
  return count
  # DO-NOT-DELETE splicer.end(checkObject)

def reverseBool(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<bool> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<bool> a
  #

  # DO-NOT-DELETE splicer.begin(reverseBool)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseBool)

def reverseChar(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<char> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<char> a
  #

  # DO-NOT-DELETE splicer.begin(reverseChar)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseChar)

def reverseInt(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<int> a
  #

  # DO-NOT-DELETE splicer.begin(reverseInt)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseInt)

def reverseLong(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<long> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<long> a
  #

  # DO-NOT-DELETE splicer.begin(reverseLong)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseLong)

def reverseString(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<string> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<string> a
  #

  # DO-NOT-DELETE splicer.begin(reverseString)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseString)

def reverseDouble(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<double> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<double> a
  #

  # DO-NOT-DELETE splicer.begin(reverseDouble)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseDouble)

def reverseFloat(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<float> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<float> a
  #

  # DO-NOT-DELETE splicer.begin(reverseFloat)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseFloat)

def reverseFcomplex(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<fcomplex> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<fcomplex> a
  #

  # DO-NOT-DELETE splicer.begin(reverseFcomplex)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseFcomplex)

def reverseDcomplex(a, newArray):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<dcomplex> a
  # bool newArray
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # (_return, a)
  # bool _return
  # array<dcomplex> a
  #

  # DO-NOT-DELETE splicer.begin(reverseDcomplex)
  return reverseArray(a, newArray)
  # DO-NOT-DELETE splicer.end(reverseDcomplex)

def createBool(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<bool> _return
  #

  # DO-NOT-DELETE splicer.begin(createBool)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), Numeric.Int32)
      result.savespace(1)
      for i in range(len):
          result[i] = isEven(i)
  return result
  # DO-NOT-DELETE splicer.end(createBool)

def createChar(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<char> _return
  #

  # DO-NOT-DELETE splicer.begin(createChar)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), 'c')
      result.savespace(1)
      for i in range(len):
          result[i] = charData[i % charDataLen]
  return result
  # DO-NOT-DELETE splicer.end(createChar)

def createInt(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int> _return
  #

  # DO-NOT-DELETE splicer.begin(createInt)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), Numeric.Int32)
      result.savespace(1)
      prime = 0
      for i in range(len):
          prime = nextPrime(prime)
          result[i] = prime
  return result
  # DO-NOT-DELETE splicer.end(createInt)

def createLong(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<long> _return
  #

  # DO-NOT-DELETE splicer.begin(createLong)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), Numeric.Int32)
      result.savespace(1)
      prime = 0
      for i in range(len):
          prime = nextPrime(prime)
          result[i] = prime
  return result
  # DO-NOT-DELETE splicer.end(createLong)

def createString(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<string> _return
  #

  # DO-NOT-DELETE splicer.begin(createString)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), Numeric.PyObject)
      result.savespace(1)
      for i in range(len):
          result[i] = stringData[i % stringDataLen]
  return result
  # DO-NOT-DELETE splicer.end(createString)

def createDouble(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<double> _return
  #

  # DO-NOT-DELETE splicer.begin(createDouble)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), Numeric.Float64)
      result.savespace(1)
      for i in range(len):
          result[i] = powTwo(-i)
  return result
  # DO-NOT-DELETE splicer.end(createDouble)

def createFloat(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<float> _return
  #

  # DO-NOT-DELETE splicer.begin(createFloat)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), Numeric.Float32)
      result.savespace(1)
      for i in range(len):
          result[i] = powTwo(-i)
  return result
  # DO-NOT-DELETE splicer.end(createFloat)

def createFcomplex(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<fcomplex> _return
  #

  # DO-NOT-DELETE splicer.begin(createFcomplex)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len,), Numeric.Complex32)
      result.savespace(1)
      for i in range(result.shape[0]):
          result[i] = powTwo(i) + powTwo(-i)*1j
  return result
  # DO-NOT-DELETE splicer.end(createFcomplex)

def createDcomplex(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<dcomplex> _return
  #

  # DO-NOT-DELETE splicer.begin(createDcomplex)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len,), Numeric.Complex)
      result.savespace(1)
      for i in range(result.shape[0]):
          result[i] = powTwo(i) + powTwo(-i)*1j
  return result
  # DO-NOT-DELETE splicer.end(createDcomplex)

def createObject(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<ArrayTest.ArrayOps> _return
  #

  # DO-NOT-DELETE splicer.begin(createObject)
  result = None
  if (len >= 0):
      result = Numeric.zeros((len, ), Numeric.PyObject)
      result.savespace(1)
      for i in range(len):
          result[i] = ArrayTest.ArrayOps.ArrayOps()
  return result
  # DO-NOT-DELETE splicer.end(createObject)

def create2Int(d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2> _return
  #

  # DO-NOT-DELETE splicer.begin(create2Int)
  result = None
  if (d1 >= 0 and d2 >= 0):
      result = Numeric.zeros((d1, d2, ), Numeric.Int32)
      result.savespace(1)
      for i in range(d1):
          for j in range(d2):
              result[i,j] = powTwo(abs(i-j))
  return result
  # DO-NOT-DELETE splicer.end(create2Int)

def create2Double(d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<double,2> _return
  #

  # DO-NOT-DELETE splicer.begin(create2Double)
  result = None
  if (d1 >= 0 and d2 >= 0):
      result = Numeric.zeros((d1, d2, ), Numeric.Float64)
      result.savespace(1)
      for i in range(d1):
          for j in range(d2):
              result[i,j] = powTwo(i-j)
  return result
  # DO-NOT-DELETE splicer.end(create2Double)

def create2Float(d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<float,2> _return
  #

  # DO-NOT-DELETE splicer.begin(create2Float)
  result = None
  if (d1 >= 0 and d2 >= 0):
      result = Numeric.zeros((d1, d2, ), Numeric.Float32)
      result.savespace(1)
      for i in range(d1):
          for j in range(d2):
              result[i,j] = powTwoF(i-j)
  return result
  # DO-NOT-DELETE splicer.end(create2Float)

def create2Dcomplex(d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<dcomplex,2> _return
  #

  # DO-NOT-DELETE splicer.begin(create2Dcomplex)
  result = None
  if (d1 >= 0 and d2 >= 0):
      result = Numeric.zeros((d1, d2, ), Numeric.Complex)
      result.savespace(1)
      for i in range(d1):
          for j in range(d2):
              result[i,j] = complex(powTwo(i), powTwo(-j))
  return result
  # DO-NOT-DELETE splicer.end(create2Dcomplex)

def create2Fcomplex(d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<fcomplex,2> _return
  #

  # DO-NOT-DELETE splicer.begin(create2Fcomplex)
  result = None
  if (d1 >= 0 and d2 >= 0):
      result = Numeric.zeros((d1, d2, ), Numeric.Complex32)
      result.savespace(1)
      for i in range(d1):
          for j in range(d2):
              result[i,j] = complex(powTwoF(i), powTwoF(-j))
  return result
  # DO-NOT-DELETE splicer.end(create2Fcomplex)

def create3Int():
  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,3> _return
  #

  # DO-NOT-DELETE splicer.begin(create3Int)
  result = Numeric.zeros((3, 3, 2, ), Numeric.Int32)
  result.savespace(1)
  for i in range(3):
    for j in range(3):
      for k in range(2):
        result[i,j,k] = arrayValue((i,j,k))
  return result
  # DO-NOT-DELETE splicer.end(create3Int)

def create4Int():
  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,4> _return
  #

  # DO-NOT-DELETE splicer.begin(create4Int)
  result = Numeric.zeros((3, 3, 2, 2, ), Numeric.Int32)
  result.savespace(1)
  for i in range(3):
    for j in range(3):
      for k in range(2):
        for l in range(2):
          result[i,j,k,l] = arrayValue((i,j,k,l))
  return result
  # DO-NOT-DELETE splicer.end(create4Int)

def makeBool(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<bool> a
  #

  # DO-NOT-DELETE splicer.begin(makeBool)
  return ArrayTest.ArrayOps.createBool(len)
  # DO-NOT-DELETE splicer.end(makeBool)

def makeChar(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<char> a
  #

  # DO-NOT-DELETE splicer.begin(makeChar)
  return ArrayTest.ArrayOps.createChar(len)
  # DO-NOT-DELETE splicer.end(makeChar)

def makeInt(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int> a
  #

  # DO-NOT-DELETE splicer.begin(makeInt)
  return ArrayTest.ArrayOps.createInt(len)
  # DO-NOT-DELETE splicer.end(makeInt)

def makeLong(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<long> a
  #

  # DO-NOT-DELETE splicer.begin(makeLong)
  return ArrayTest.ArrayOps.createLong(len)
  # DO-NOT-DELETE splicer.end(makeLong)

def makeString(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<string> a
  #

  # DO-NOT-DELETE splicer.begin(makeString)
  return ArrayTest.ArrayOps.createString(len)
  # DO-NOT-DELETE splicer.end(makeString)

def makeDouble(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<double> a
  #

  # DO-NOT-DELETE splicer.begin(makeDouble)
  return ArrayTest.ArrayOps.createDouble(len)
  # DO-NOT-DELETE splicer.end(makeDouble)

def makeFloat(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<float> a
  #

  # DO-NOT-DELETE splicer.begin(makeFloat)
  return ArrayTest.ArrayOps.createFloat(len)
  # DO-NOT-DELETE splicer.end(makeFloat)

def makeFcomplex(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<fcomplex> a
  #

  # DO-NOT-DELETE splicer.begin(makeFcomplex)
  return ArrayTest.ArrayOps.createFcomplex(len)
  # DO-NOT-DELETE splicer.end(makeFcomplex)

def makeDcomplex(len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<dcomplex> a
  #

  # DO-NOT-DELETE splicer.begin(makeDcomplex)
  return ArrayTest.ArrayOps.createDcomplex(len)
  # DO-NOT-DELETE splicer.end(makeDcomplex)

def makeInOutBool(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<bool> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<bool> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutBool)
  return ArrayTest.ArrayOps.createBool(len)
  # DO-NOT-DELETE splicer.end(makeInOutBool)

def makeInOutChar(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<char> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<char> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutChar)
  return ArrayTest.ArrayOps.createChar(len)
  # DO-NOT-DELETE splicer.end(makeInOutChar)

def makeInOutInt(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutInt)
  return ArrayTest.ArrayOps.createInt(len)
  # DO-NOT-DELETE splicer.end(makeInOutInt)

def makeInOutLong(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<long> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<long> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutLong)
  return ArrayTest.ArrayOps.createLong(len)
  # DO-NOT-DELETE splicer.end(makeInOutLong)

def makeInOutString(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<string> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<string> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutString)
  return ArrayTest.ArrayOps.createString(len)
  # DO-NOT-DELETE splicer.end(makeInOutString)

def makeInOutDouble(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<double> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<double> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutDouble)
  return ArrayTest.ArrayOps.createDouble(len)
  # DO-NOT-DELETE splicer.end(makeInOutDouble)

def makeInOutFloat(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<float> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<float> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutFloat)
  return ArrayTest.ArrayOps.createFloat(len)
  # DO-NOT-DELETE splicer.end(makeInOutFloat)

def makeInOutDcomplex(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<dcomplex> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<dcomplex> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutDcomplex)
  return ArrayTest.ArrayOps.createDcomplex(len)
  # DO-NOT-DELETE splicer.end(makeInOutDcomplex)

def makeInOutFcomplex(a, len):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<fcomplex> a
  # int len
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<fcomplex> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOutFcomplex)
  return ArrayTest.ArrayOps.createFcomplex(len)
  # DO-NOT-DELETE splicer.end(makeInOutFcomplex)

def makeInOut2Int(a, d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,2> a
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,2> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOut2Int)
  return ArrayTest.ArrayOps.create2Int(d1,d2)
  # DO-NOT-DELETE splicer.end(makeInOut2Int)

def makeInOut2Double(a, d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<double,2> a
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<double,2> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOut2Double)
  return ArrayTest.ArrayOps.create2Double(d1,d2)
  # DO-NOT-DELETE splicer.end(makeInOut2Double)

def makeInOut2Float(a, d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<float,2> a
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<float,2> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOut2Float)
  return ArrayTest.ArrayOps.create2Float(d1,d2)
  # DO-NOT-DELETE splicer.end(makeInOut2Float)

def makeInOut2Dcomplex(a, d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<dcomplex,2> a
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<dcomplex,2> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOut2Dcomplex)
  return ArrayTest.ArrayOps.create2Dcomplex(d1,d2)
  # DO-NOT-DELETE splicer.end(makeInOut2Dcomplex)

def makeInOut2Fcomplex(a, d1, d2):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<fcomplex,2> a
  # int d1
  # int d2
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<fcomplex,2> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOut2Fcomplex)
  return ArrayTest.ArrayOps.create2Fcomplex(d1,d2)
  # DO-NOT-DELETE splicer.end(makeInOut2Fcomplex)

def makeInOut3Int(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,3> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,3> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOut3Int)
  return ArrayTest.ArrayOps.create3Int()
  # DO-NOT-DELETE splicer.end(makeInOut3Int)

def makeInOut4Int(a):
  #
  # SIDL EXPECTED INCOMING TYPES
  # ============================
  # array<int,4> a
  #

  #
  # SIDL EXPECTED RETURN VALUE(s)
  # =============================
  # array<int,4> a
  #

  # DO-NOT-DELETE splicer.begin(makeInOut4Int)
  return ArrayTest.ArrayOps.create4Int()
  # DO-NOT-DELETE splicer.end(makeInOut4Int)

# DO-NOT-DELETE splicer.begin(_before_type)
# Put your code here...
# DO-NOT-DELETE splicer.end(_before_type)

class ArrayOps:

  # All calls to SIDL methods should use __IORself

  def __init__(self, IORself):
    self.__IORself = IORself
    # DO-NOT-DELETE splicer.begin(__init__)
    # Put your code here...
    # DO-NOT-DELETE splicer.end(__init__)

# DO-NOT-DELETE splicer.begin(_final)
# Put your code here...
# DO-NOT-DELETE splicer.end(_final)
