#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Args.h"

void test_bool( int * part_no, int * final_result );
void test_char( int * part_no, int * final_result );
void test_int( int * part_no, int * final_result );
void test_float( int * part_no, int * final_result );
void test_double( int * part_no, int * final_result );
void test_fcomplex( int * part_no, int * final_result );
void test_dcomplex( int * part_no, int * final_result );
void declare_part( int *part_no );
void end_part( int part_no, int result, int *final_result );


char * result_string[] = { "FAIL", "XFAIL", "PASS", "XPASS", "UNSUPPORTED" };
const int unsupported = 4;
const int xpass = 3;
const int pass = 2;
const int xfail = 1;
const int fail = 0;

/**
 * Fill the stack with random junk.
 */
int clearstack(int magicNumber) {
  int chunk[2048], i;
  for(i = 0; i < 2048; i++){
    chunk[i] = rand() + magicNumber;
  }
  for(i = 0; i < 16; i++){
    magicNumber += chunk[rand() & 2047];
  }
  return magicNumber;
}

#define MYASSERT( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = pass; \
  else result = fail;  \
  end_part( part_no, result, &final_result );

#define MYXFAIL( AAA ) \
  declare_part( &part_no ); \
  magicNumber = clearstack(magicNumber); \
  printf("COMMENT: %s\n", #AAA ); \
  if ( AAA ) result = xpass; \
  else result = xfail;  \
  end_part( part_no, result, &final_result );

#define MYBROKEN( AAA ) \
  declare_part( &part_no ); \
  printf("COMMENT: %s\n", #AAA ); \
  end_part( part_no, unsupported, &final_result );

int main(int argc, char** argv) { 
  int result = pass; 
  int final_result = pass;
  int magicNumber = 1;
  int part_no = 0;
  const char *language = "";
  printf("NPARTS -1\n");
  if (argc == 2){
    language = argv[1];
  }
  
  { /* bool */
    int out;
    int inout = TRUE;
    Args_Cbool obj = Args_Cbool__create();;
 
    MYASSERT( Args_Cbool_returnback( obj ) == TRUE );
    MYASSERT( Args_Cbool_passin( obj, TRUE ) == TRUE );
    MYASSERT( Args_Cbool_passout( obj, &out ) == TRUE && out == TRUE );
    MYASSERT( Args_Cbool_passinout( obj, &inout ) == TRUE && inout == FALSE );
    MYASSERT( Args_Cbool_passeverywhere( obj, TRUE, &out, &inout ) == TRUE &&
	      out == TRUE && inout == TRUE );
    
    Args_Cbool_deleteRef( obj );
  } 

  { /* char */
    char out;
    char inout = 'A';
    Args_Cchar obj = Args_Cchar__create();;
 
    MYASSERT( Args_Cchar_returnback( obj ) == '3' );
    MYASSERT( Args_Cchar_passin( obj, '3' ) == TRUE );
    MYASSERT( Args_Cchar_passout( obj, &out ) == TRUE && out == '3' );
    MYASSERT( Args_Cchar_passinout( obj, &inout ) == TRUE && inout == 'a' );
    MYASSERT( Args_Cchar_passeverywhere( obj, '3', &out, &inout ) == '3' &&
	     out == '3' && inout == 'A' );

    Args_Cchar_deleteRef( obj );
  }


  { /* int */
    int32_t out;
    int32_t inout = 3;
    Args_Cint obj = Args_Cint__create();;
 
    MYASSERT( Args_Cint_returnback( obj ) == 3 );
    MYASSERT( Args_Cint_passin( obj, 3 ) == TRUE );
    MYASSERT( Args_Cint_passout( obj, &out ) == TRUE && out == 3 );
    MYASSERT( Args_Cint_passinout( obj, &inout ) == TRUE && inout == -3 );
    MYASSERT( Args_Cint_passeverywhere( obj, 3, &out, &inout ) == 3 &&
	      out == 3 && inout == 3 );
    
    Args_Cint_deleteRef( obj );
  }

  { /* long */
    int64_t out;
    int64_t inout = 3;
    Args_Clong obj = Args_Clong__create();;
 
    MYASSERT( Args_Clong_returnback( obj ) == 3 );
    MYASSERT( Args_Clong_passin( obj, 3 ) == TRUE );
    MYASSERT( Args_Clong_passout( obj, &out ) == TRUE && out == 3 );
    MYASSERT( Args_Clong_passinout( obj, &inout ) == TRUE && inout == -3 );
    MYASSERT( Args_Clong_passeverywhere( obj, 3, &out, &inout ) == 3 &&
	      out == 3 && inout == 3 );
    
    Args_Clong_deleteRef( obj );
  }

  { /* float */
    float out;
    float inout = 3.1F;
    Args_Cfloat obj = Args_Cfloat__create();;
 
    MYASSERT( Args_Cfloat_returnback( obj ) == 3.1F );
    MYASSERT( Args_Cfloat_passin( obj, 3.1F ) == TRUE );
    MYASSERT( Args_Cfloat_passout( obj, &out ) == TRUE && out == 3.1F );
    MYASSERT( Args_Cfloat_passinout( obj, &inout ) == TRUE && inout == -3.1F
              );
    MYASSERT( Args_Cfloat_passeverywhere( obj, 3.1F, &out, &inout ) ==
              3.1F && out == 3.1F && inout == 3.1F );
    
    Args_Cfloat_deleteRef( obj );
  }


  { /* double */
    double out;
    double inout = 3.14;
    Args_Cdouble obj = Args_Cdouble__create();;
 
    MYASSERT( Args_Cdouble_returnback( obj ) == 3.14 );
    MYASSERT( Args_Cdouble_passin( obj, 3.14 ) == TRUE );
    MYASSERT( Args_Cdouble_passout( obj, &out ) == TRUE && out == 3.14 );
    MYASSERT( Args_Cdouble_passinout( obj, &inout ) == TRUE && inout == -3.14 );
    MYASSERT( Args_Cdouble_passeverywhere( obj, 3.14, &out, &inout ) == 3.14 &&
	      out == 3.14 && inout == 3.14 );
    
    Args_Cdouble_deleteRef( obj );
  }


  { /* fcomplex */
    struct SIDL_fcomplex retval;
    struct SIDL_fcomplex in = { 3.1F, 3.1F };
    struct SIDL_fcomplex out;
    struct SIDL_fcomplex inout = { 3.1F, 3.1F };
    Args_Cfcomplex obj = Args_Cfcomplex__create();;
 
    printf("COMMENT: retval = Args_Cfcomplex_returnback( obj );\n");
    retval = Args_Cfcomplex_returnback( obj );
    MYASSERT( retval.real == 3.1F && retval.imaginary == 3.1F);
    MYASSERT( Args_Cfcomplex_passin( obj, in ) == TRUE );
    
    MYASSERT( Args_Cfcomplex_passout( obj, &out ) == TRUE && 
	      out.real == 3.1F && out.imaginary == 3.1F );
    MYASSERT( Args_Cfcomplex_passinout( obj, &inout ) == TRUE && 
	      inout.real == 3.1F && inout.imaginary == -3.1F );
    printf("COMMENT: retval = Args_Cfcomplex_passeverywhere( obj, in, &out, &inout );\n");
    retval = Args_Cfcomplex_passeverywhere( obj, in, &out, &inout );
    MYASSERT( retval.real == 3.1F && retval.imaginary == 3.1F &&
              out.real == 3.1F && out.imaginary == 3.1F && 
              inout.real == 3.1F && inout.imaginary == 3.1F );
    
    Args_Cfcomplex_deleteRef( obj );
  }

  
  { /* dcomplex */
    struct SIDL_dcomplex retval;
    struct SIDL_dcomplex in = { 3.14, 3.14 };
    struct SIDL_dcomplex out;
    struct SIDL_dcomplex inout = { 3.14, 3.14 };
    Args_Cdcomplex obj = Args_Cdcomplex__create();;

    printf("COMMENT: retval = Args_Cdcomplex_returnback( obj );\n");
    retval = Args_Cdcomplex_returnback( obj ); 
    MYASSERT( retval.real == 3.14 && retval.imaginary == 3.14);
    MYASSERT( Args_Cdcomplex_passin( obj, in ) == TRUE );
    MYASSERT( Args_Cdcomplex_passout( obj, &out ) == TRUE && 
	      out.real == 3.14 && out.imaginary == 3.14 );
    MYASSERT( Args_Cdcomplex_passinout( obj, &inout ) == TRUE && 
	      inout.real == 3.14 && inout.imaginary == -3.14 );
    printf("COMMENT: retval = Args_Cdcomplex_passeverywhere( obj, in, &out, &inout );\n");
    retval = Args_Cdcomplex_passeverywhere( obj, in, &out, &inout ); 
    MYASSERT( retval.real == 3.14 && retval.imaginary == 3.14 &&
	      out.real == 3.14 && out.imaginary == 3.14 && 
	      inout.real == 3.14 && inout.imaginary == 3.14 );
    
    Args_Cdcomplex_deleteRef( obj );
  }

  printf("TEST_RESULT %s\n", result_string[ final_result ] );
  return 0;
}

void declare_part( int * part_no ) {
  ++(*part_no);
  printf("PART %d\n", *part_no );
}

void end_part( int part_no, int result, int *final_result ) {
  printf("RESULT %d %s\n", part_no, result_string[ result ] );
  if ( result == xpass ) {
    *final_result = fail;
  } else if ( result == unsupported && *final_result == pass ) { 
    *final_result = xfail;
  } else if ( result < *final_result ) { 
    *final_result = result;
  }
}

