/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Version;

public class SymbolID
implements Comparable {
    private String d_full_name;
    private Version d_version;

    public SymbolID(String fully_qualified_name, Version version) {
        this.d_full_name = fully_qualified_name;
        this.d_version = version;
    }

    public String getFullName() {
        return this.d_full_name;
    }

    public String getShortName() {
        return SymbolUtilities.getShortName(this.d_full_name);
    }

    public Version getVersion() {
        return this.d_version;
    }

    public String getSymbolName() {
        return this.d_full_name + "-v" + this.d_version.getVersionString();
    }

    public int hashCode() {
        return this.d_full_name.hashCode() + this.d_version.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof SymbolID) {
            SymbolID id = (SymbolID)obj;
            return this.d_full_name.equals(id.d_full_name) && this.d_version.isSame(id.d_version);
        }
        return false;
    }

    public int compareTo(Object o) {
        SymbolID id = (SymbolID)o;
        return this.d_full_name.compareTo(id.d_full_name);
    }
}

