/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.jdk;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.jdk.Java;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ClientJNI {
    private LanguageWriterForC d_writer;

    public static void generateCode(Extendable symbol, LanguageWriterForC writer) throws CodeGenerationException {
        ClientJNI jni = new ClientJNI(writer);
        jni.generateCode(symbol);
    }

    public ClientJNI(LanguageWriterForC writer) {
        this.d_writer = writer;
    }

    private int countMethods(Extendable ext) {
        int count;
        boolean isInterface = ext.isInterface();
        Collection methods = ext.getMethods(isInterface);
        if (isInterface) {
            count = methods.size();
        } else {
            count = 0;
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                Method m = (Method)i.next();
                if (m.isAbstract()) continue;
                ++count;
            }
        }
        return count;
    }

    public void generateCode(Extendable ext) throws CodeGenerationException {
        if (ext == null) {
            throw new CodeGenerationException("Unexpected null extendable object");
        }
        SymbolID id = ext.getSymbolID();
        String file = Java.getClientJNIFile(id);
        this.d_writer.writeBanner(ext, file, false, "Client-side JNI glue code for " + id.getFullName());
        this.d_writer.generateInclude("SIDL_Java.h", false);
        this.d_writer.generateInclude("SIDL_Loader.h", false);
        this.d_writer.generateInclude("SIDL_String.h", false);
        this.d_writer.generateInclude(IOR.getHeaderFile(id), false);
        this.d_writer.generateInclude("babel_config.h", false);
        this.d_writer.println();
        this.d_writer.writeComment("Convert between jlong and void* pointers.", false);
        this.d_writer.disableLineBreak();
        this.d_writer.println("#if (SIZEOF_VOID_P == 8)");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(x))");
        this.d_writer.println("#else");
        this.d_writer.println("#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))");
        this.d_writer.println("#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.println("#ifndef NULL");
        this.d_writer.println("#define NULL 0");
        this.d_writer.println("#endif");
        this.d_writer.println();
        this.d_writer.enableLineBreak();
        boolean need_ior_function = ext.isInterface();
        if (!need_ior_function) {
            Iterator m = ext.getMethods(false).iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (method.isAbstract() || method.isStatic()) continue;
                need_ior_function = true;
                break;
            }
        }
        if (need_ior_function) {
            this.d_writer.writeComment("Function to extract IOR reference from the Java object.", false);
            this.d_writer.println("static " + IOR.getObjectName(id) + "* _get_ior(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("JNIEnv* env,");
            this.d_writer.println("jobject obj)");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("void* ptr = NULL;");
            this.d_writer.println("static jmethodID mid = (jmethodID) NULL;");
            this.d_writer.println();
            this.d_writer.println("if (mid == (jmethodID) NULL) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("jclass cls = (*env)->GetObjectClass(env, obj);");
            this.d_writer.println("mid = (*env)->GetMethodID(env, cls, \"_get_ior\", \"()J\");");
            this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
            this.d_writer.println("ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));");
            this.d_writer.println("return (" + IOR.getObjectName(id) + "*) ptr;");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("External reference to IOR methods.", false);
            this.d_writer.println("static const " + IOR.getExternalName(id) + "* s_external = NULL;");
            this.d_writer.println();
        }
        if (ext.hasStaticMethod(false)) {
            this.d_writer.writeComment("External reference to static EPV.", false);
            this.d_writer.println("static const " + IOR.getSEPVName(id) + "* s_sepv = NULL;");
            this.d_writer.println();
        }
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("Create object instance and return reference.", false);
            this.d_writer.println("static jlong jni__create_ior(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("JNIEnv* env,");
            this.d_writer.println("jclass  cls)");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("{");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("(void) env;");
            this.d_writer.println("(void) cls;");
            this.d_writer.println("return POINTER_TO_JLONG((*s_external->createObject)());");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        List methods = (List)ext.getMethods(ext.isInterface());
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            if (!ext.isInterface() && method.isAbstract()) continue;
            this.generateMethod(id, method);
            this.d_writer.println();
        }
        int nmethods = this.countMethods(ext) + (ext.isAbstract() ? 0 : 1);
        this.d_writer.writeComment("Register JNI methods with the Java JVM.", false);
        this.d_writer.println("void " + Java.getRegisterFunction(id) + "(JNIEnv* env)");
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        if (nmethods > 0) {
            this.d_writer.println("JNINativeMethod methods[" + Integer.toString(nmethods) + "];");
            this.d_writer.println("jclass cls;");
            this.d_writer.println();
            if (!ext.isAbstract()) {
                if (BabelConfiguration.isSIDLBaseClass(id)) {
                    this.d_writer.println("s_external = " + IOR.getExternalFunc(id) + "();");
                } else {
                    this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
                    this.d_writer.println("s_external = " + IOR.getExternalFunc(id) + "();");
                    this.d_writer.printlnUnformatted("#else");
                    this.d_writer.println("void* address = SIDL_Loader_lookupSymbol(\"" + IOR.getExternalFunc(id) + "\");");
                    this.d_writer.println("if (address != NULL) {");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("s_external = (*((" + IOR.getExternalName(id) + "* (*)(void)) address))();");
                    this.d_writer.decreaseTabLevel();
                    this.d_writer.println("} else {");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.println("jclass e = (*env)->FindClass(env, \"java/lang/UnsatisfiedLinkError\");");
                    this.d_writer.println("if (e != NULL) {");
                    this.d_writer.increaseTabLevel();
                    this.d_writer.disableLineBreak();
                    this.d_writer.println("(*env)->ThrowNew(env, e, \"Could not find implementation for SIDL class " + id.getFullName() + "\");");
                    this.d_writer.enableLineBreak();
                    this.d_writer.println("(*env)->DeleteLocalRef(env, e);");
                    this.d_writer.decreaseTabLevel();
                    this.d_writer.println("}");
                    this.d_writer.decreaseTabLevel();
                    this.d_writer.println("}");
                    this.d_writer.printlnUnformatted("#endif");
                    this.d_writer.println();
                }
            }
            if (ext.hasStaticMethod(false)) {
                this.d_writer.println("s_sepv = (*(s_external->getStaticEPV))();");
                this.d_writer.println();
            }
            int idx = 0;
            if (!ext.isAbstract()) {
                this.d_writer.println("methods[0].name      = \"_create_ior\";");
                this.d_writer.println("methods[0].signature = \"()J\";");
                this.d_writer.println("methods[0].fnPtr     = (void *)jni__create_ior;");
                ++idx;
            }
            Iterator m2 = methods.iterator();
            while (m2.hasNext()) {
                Method method = (Method)m2.next();
                if (!ext.isInterface() && method.isAbstract()) continue;
                String prefix = "methods[" + Integer.toString(idx) + "].";
                this.d_writer.println(prefix + "name      = \"" + method.getShortMethodName() + "\";");
                this.d_writer.disableLineBreak();
                this.d_writer.println(prefix + "signature = \"" + Java.getJavaSignature(method) + "\";");
                this.d_writer.enableLineBreak();
                this.d_writer.println(prefix + "fnPtr     = (void *)" + Java.getJNIFunction(method) + ";");
                ++idx;
            }
            this.d_writer.println();
            String lookup_name = Java.getFullJavaSymbolName(id).replace('.', '/');
            if (ext.isInterface()) {
                lookup_name = lookup_name + "$Wrapper";
            }
            this.d_writer.println("cls = (*env)->FindClass(env, \"" + lookup_name + "\");");
            this.d_writer.println("if (cls) {");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("(*env)->RegisterNatives(env, cls, methods, " + String.valueOf(nmethods) + ");");
            this.d_writer.println("(*env)->DeleteLocalRef(env, cls);");
            this.d_writer.decreaseTabLevel();
            this.d_writer.println("}");
        } else {
            this.d_writer.writeComment("Intentionally empty: no methods to register", false);
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }

    private void generateMethod(SymbolID id, Method method) throws CodeGenerationException {
        Argument arg;
        Iterator a;
        boolean throws_exception = !method.getThrows().isEmpty();
        this.d_writer.writeComment(method, false);
        Type return_type = method.getReturnType();
        this.d_writer.println("static " + Java.getJNIReturnType(return_type));
        this.d_writer.println(Java.getJNIFunction(method) + "(");
        this.d_writer.increaseTabLevel();
        this.d_writer.println("JNIEnv* env,");
        if (!method.isStatic()) {
            this.d_writer.print("jobject obj");
        } else {
            this.d_writer.print("jclass  cls");
        }
        ArrayList args = method.getArgumentList();
        this.d_writer.println(args.isEmpty() ? ")" : ",");
        Iterator a2 = args.iterator();
        while (a2.hasNext()) {
            Argument arg2 = (Argument)a2.next();
            this.d_writer.print(Java.getJNIFormalArgument(arg2));
            this.d_writer.println(a2.hasNext() ? "," : ")");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("{");
        this.d_writer.increaseTabLevel();
        this.d_writer.writeComment("Declare return and temporary variables.", false);
        if (!method.isStatic()) {
            this.d_writer.println(IOR.getObjectName(id) + "* _ior = NULL;");
        }
        Iterator a3 = args.iterator();
        while (a3.hasNext()) {
            Argument arg3 = (Argument)a3.next();
            Java.declareIORVariable(this.d_writer, arg3, "_tmp_");
        }
        if (return_type.getType() != 0) {
            Java.declareIORVariable(this.d_writer, return_type, "_ior_res");
            Java.declareJavaVariable(this.d_writer, return_type, "_res");
        }
        if (throws_exception) {
            this.d_writer.println("struct SIDL_BaseException__object* _ex = NULL;");
        }
        this.d_writer.println();
        this.d_writer.writeComment("Preprocess Java types and convert into IOR.", false);
        if (!method.isStatic()) {
            this.d_writer.println("_ior = _get_ior(env, obj);");
        }
        Iterator a4 = args.iterator();
        while (a4.hasNext()) {
            Argument arg4 = (Argument)a4.next();
            Java.preprocessJNIArgument(this.d_writer, arg4, "_tmp_");
        }
        this.d_writer.println();
        this.d_writer.writeComment("Call the IOR method through the EPV.", false);
        if (return_type.getType() != 0) {
            this.d_writer.print("_ior_res = ");
        }
        this.d_writer.print("(*(");
        this.d_writer.print(method.isStatic() ? "s_sepv" : "_ior->d_epv");
        this.d_writer.print("->f_" + method.getLongMethodName() + "))(");
        if (method.isStatic() && args.isEmpty() && !throws_exception) {
            this.d_writer.println(");");
        } else {
            this.d_writer.println();
            this.d_writer.increaseTabLevel();
            if (!method.isStatic()) {
                this.d_writer.print(method.isAbstract() ? "_ior->d_object" : "_ior");
                this.d_writer.println(args.isEmpty() && !throws_exception ? ");" : ",");
            }
            a = args.iterator();
            while (a.hasNext()) {
                arg = (Argument)a.next();
                if (arg.getMode() != 0) {
                    this.d_writer.print("&");
                }
                this.d_writer.print("_tmp_" + arg.getFormalName());
                this.d_writer.println(a.hasNext() || throws_exception ? "," : ");");
            }
            if (throws_exception) {
                this.d_writer.println("&_ex);");
            }
            this.d_writer.decreaseTabLevel();
        }
        this.d_writer.println();
        this.d_writer.writeComment("Postprocess OUT, INOUT, returns, and exceptions.", false);
        a = args.iterator();
        while (a.hasNext()) {
            arg = (Argument)a.next();
            Java.postprocessJNIArgument(this.d_writer, arg, "_tmp_");
        }
        if (return_type.getType() != 0) {
            Java.postprocessJNIReturn(this.d_writer, return_type, "_ior_res", "_res");
        }
        if (throws_exception) {
            this.d_writer.println("SIDL_Java_CheckException(");
            this.d_writer.increaseTabLevel();
            this.d_writer.println("env,");
            this.d_writer.println("_ex,");
            Iterator t = method.getThrows().iterator();
            while (t.hasNext()) {
                this.d_writer.println("\"" + ((SymbolID)t.next()).getFullName() + "\",");
            }
            this.d_writer.println("NULL);");
            this.d_writer.decreaseTabLevel();
        }
        if (return_type.getType() != 0) {
            this.d_writer.println();
            this.d_writer.println("return _res;");
        }
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("}");
    }
}

