/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.CommandLineDriver;
import gov.llnl.babel.ResourceLoader;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.fortran.AbbrevHeader;
import gov.llnl.babel.backend.fortran.ArrayModule;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.ModuleSource;
import gov.llnl.babel.backend.fortran.StubDoc;
import gov.llnl.babel.backend.fortran.StubSource;
import gov.llnl.babel.backend.fortran.TypeModule;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.backend.writers.LanguageWriterForFortran;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateClient
implements CodeGenerator {
    private static final int[] s_basic_array_types = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyArrayStub(String typeName, Writer out) throws CodeGenerationException {
        boolean isF90 = "f90".equals(BabelConfiguration.getInstance().getTargetLanguage());
        String context = "gov/llnl/babel/backend/fortran/" + (isF90 ? "f90" : "f77");
        ResourceLoader rl = new ResourceLoader();
        InputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            try {
                int count;
                in = rl.getResourceStream(context + "/SIDL_" + typeName + "_fStub.c");
                while ((count = in.read(buffer)) >= 0) {
                    void var8_8;
                    String str = new String(buffer, 0, (int)var8_8);
                    out.write(str);
                }
                Object var11_11 = null;
                if (in == null) return;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (IOException ioe) {
            throw new CodeGenerationException(ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copyArrayAbbrev(String typeName, Writer out) throws CodeGenerationException {
        String context = "gov/llnl/babel/backend/fortran/f90";
        ResourceLoader rl = new ResourceLoader();
        InputStream in = null;
        byte[] buffer = new byte[1024];
        try {
            try {
                int count;
                in = rl.getResourceStream("gov/llnl/babel/backend/fortran/f90/SIDL_" + typeName + "_fAbbrev.h");
                while ((count = in.read(buffer)) >= 0) {
                    void var7_7;
                    String str = new String(buffer, 0, (int)var7_7);
                    out.write(str);
                }
                Object var10_10 = null;
                if (in == null) return;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (IOException ioe) {
            throw new CodeGenerationException(ioe.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void generateBasicArrayStubs() throws CodeGenerationException {
        PrintWriter pw = null;
        Writer w = null;
        LanguageWriterForFortran forWriter = null;
        boolean isF90 = "f90".equals(BabelConfiguration.getInstance().getTargetLanguage());
        try {
            try {
                int i = 0;
                while (i < s_basic_array_types.length) {
                    int type = s_basic_array_types[i];
                    String typeName = new Type(type).getTypeString();
                    SymbolID id = new SymbolID("SIDL." + typeName, new Version());
                    String filename = Fortran.getArrayFile(id);
                    if (CommandLineDriver.notExcluded(id) && isF90) {
                        pw = FileManager.getInstance().createFile(id, type, "ARRAYMODULESRCS", filename);
                        forWriter = new LanguageWriterForFortran(pw);
                        ArrayModule am = new ArrayModule(id, type, forWriter);
                        am.generateStub();
                        forWriter.close();
                    }
                    w = FileManager.getInstance().createFile(id, type, "STUBSRCS", Fortran.getStubFile(id));
                    this.copyArrayStub(typeName, w);
                    w.close();
                    if (isF90) {
                        w = FileManager.getInstance().createFile(id, type, "STUBHDRS", Fortran.getStubNameFile(id));
                        this.copyArrayAbbrev(typeName, w);
                    }
                    ++i;
                }
            }
            catch (IOException ioe) {
                throw new CodeGenerationException(ioe.getMessage());
            }
            Object var12_12 = null;
            try {
                block14: {
                    try {
                        if (w == null) break block14;
                        w.close();
                    }
                    catch (IOException ioe) {
                        throw new CodeGenerationException(ioe.getMessage());
                    }
                }
                Object var15_14 = null;
                if (pw == null) return;
                pw.close();
                return;
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (pw == null) throw throwable;
                pw.close();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {}
            catch (Throwable throwable2) {
                Object var15_17 = null;
                if (pw == null) throw throwable2;
                pw.close();
                throw throwable2;
            }
            try {}
            catch (IOException ioe) {
                throw new CodeGenerationException(ioe.getMessage());
            }
            if (w != null) {
                w.close();
            }
            Object var15_16 = null;
            if (pw == null) throw throwable;
            pw.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateStubSource(Symbol symbol) throws CodeGenerationException {
        PrintWriter pw = null;
        PrintWriter dw = null;
        PrintWriter nw = null;
        PrintWriter mw = null;
        SymbolID id = symbol.getSymbolID();
        int type = symbol.getSymbolType();
        boolean isF90 = "f90".equals(BabelConfiguration.getInstance().getTargetLanguage());
        boolean writeBasicArrayStubs = false;
        switch (type) {
            case 12: 
            case 13: {
                try {
                    String f = Fortran.getStubFile(id);
                    pw = FileManager.getInstance().createFile(id, type, "STUBSRCS", f);
                    LanguageWriterForC writer = new LanguageWriterForC(pw);
                    StubSource.generateCode(symbol, writer);
                    writeBasicArrayStubs = true;
                    if (isF90) {
                        String nf = Fortran.getStubNameFile(id);
                        nw = FileManager.getInstance().createFile(id, type, "STUBHDRS", nf);
                        writer = new LanguageWriterForC(nw);
                        AbbrevHeader.generateCode(symbol, writer);
                        String mf = Fortran.getModuleFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "STUBMODULESRCS", mf);
                        LanguageWriterForFortran forWriter = new LanguageWriterForFortran(mw);
                        ModuleSource.generateCode(symbol, forWriter);
                        forWriter.close();
                        String amf = Fortran.getArrayFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "ARRAYMODULESRCS", amf);
                        forWriter = new LanguageWriterForFortran(mw);
                        ArrayModule am = new ArrayModule(id, type, forWriter);
                        forWriter.writeBanner(symbol, amf, false, "Client-side module for " + symbol.getFullName());
                        am.generateStub();
                        forWriter.close();
                        String tf = Fortran.getTypeFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "TYPEMODULESRCS", tf);
                        forWriter = new LanguageWriterForFortran(mw);
                        TypeModule.generateCode(symbol, forWriter);
                    } else {
                        String df = Fortran.getStubDocFile(id);
                        dw = FileManager.getInstance().createFile(id, type, "STUBDOCS", df);
                        LanguageWriterForFortran forWriter = new LanguageWriterForFortran(dw);
                        StubDoc.generateCode(symbol, forWriter);
                    }
                    Object var19_29 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (dw != null) {
                        dw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw == null) break;
                    mw.close();
                    break;
                }
                catch (Throwable throwable) {
                    Object var19_30 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (dw != null) {
                        dw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw != null) {
                        mw.close();
                    }
                    throw throwable;
                }
            }
            case 11: {
                try {
                    String nf = Fortran.getStubNameFile(id);
                    String f = Fortran.getEnumStubImpl(id);
                    pw = FileManager.getInstance().createFile(id, type, "STUBSRCS", f);
                    writeBasicArrayStubs = true;
                    LanguageWriterForC clw = new LanguageWriterForC(pw);
                    StubSource.generateCode(symbol, clw);
                    if (isF90) {
                        nw = FileManager.getInstance().createFile(id, type, "STUBHDRS", nf);
                        clw = new LanguageWriterForC(nw);
                        AbbrevHeader.generateCode(symbol, clw);
                        String mf = Fortran.getModuleFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "STUBMODULESRCS", mf);
                        LanguageWriterForFortran forWriter = new LanguageWriterForFortran(mw);
                        ModuleSource.generateCode(symbol, forWriter);
                        forWriter.close();
                        String amf = Fortran.getArrayFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "ARRAYMODULESRCS", amf);
                        forWriter = new LanguageWriterForFortran(mw);
                        ArrayModule am = new ArrayModule(id, type, forWriter);
                        forWriter.writeBanner(symbol, amf, false, "Client-side module for " + symbol.getFullName());
                        am.generateStub();
                        forWriter.close();
                        String tf = Fortran.getTypeFile(id);
                        mw = FileManager.getInstance().createFile(id, type, "TYPEMODULESRCS", tf);
                        forWriter = new LanguageWriterForFortran(mw);
                        TypeModule.generateCode(symbol, forWriter);
                    } else {
                        f = Fortran.getEnumStubFile(id);
                        pw = FileManager.getInstance().createFile(id, type, "STUBFORTRANINC", f);
                        LanguageWriterForFortran writer = new LanguageWriterForFortran(pw);
                        StubSource.generateCode(symbol, writer);
                        writer.close();
                    }
                    Object var21_32 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw == null) break;
                    mw.close();
                    break;
                }
                catch (Throwable throwable) {
                    Object var21_33 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    if (nw != null) {
                        nw.close();
                    }
                    if (mw != null) {
                        mw.close();
                    }
                    throw throwable;
                }
            }
        }
        if (writeBasicArrayStubs) {
            this.generateBasicArrayStubs();
        }
    }

    public void generateCode(Set symbols) throws CodeGenerationException {
        Iterator i = symbols.iterator();
        SymbolTable table = SymbolTable.getInstance();
        while (i.hasNext()) {
            SymbolID id = (SymbolID)i.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            this.generateStubSource(symbol);
        }
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return false;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("f77");
        result.add("f90");
        return result;
    }
}

