/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.cxx;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.cxx.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.io.IOException;
import java.util.Iterator;

public class CxxImplHeader {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private CodeSplicer d_splicer = null;

    public CxxImplHeader(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generateCode() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Cxx.generateFilename(id, 1, 1);
        try {
            block4: {
                try {
                    this.d_splicer = FileManager.getInstance().getCodeSplicer(id, type, filename);
                    this.d_writer = Cxx.createHeader(this.d_ext, 1, "IMPLHDRS");
                    this.d_splicer.setLineRedirector(this.d_writer);
                    this.d_writer.println();
                    this.d_writer.openHeaderGuard(filename);
                    Cxx.generateDependencyIncludes(this.d_writer, this.d_ext, false);
                    this.spliceIncludes();
                    Cxx.nestPackagesInNamespaces(this.d_writer, this.d_ext);
                    this.writeClassBeginning();
                    this.writeSIDLDefinedMethods();
                    this.writeClassEnd();
                    Cxx.unnestPackagesInNamespaces(this.d_writer, this.d_ext);
                    this.writeMiscStuff();
                    this.d_writer.closeHeaderGuard();
                    if (!this.d_splicer.hasUnusedSymbolEdits()) break block4;
                    this.d_writer.println();
                    this.d_writer.beginBlockComment(true);
                    this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
                    this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
                    this.d_writer.println("This can result from a method rename/removal in the SIDL file.");
                    this.d_writer.println("Move or remove the code in order to compile cleanly.");
                    this.d_writer.println("================== END UNREFERENCED METHOD(S) =================");
                    this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
                    this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
                }
                catch (IOException ex) {
                    throw new CodeGenerationException("IOException : " + ex.getMessage());
                }
            }
            Object var6_4 = null;
            if (this.d_writer == null) return;
            this.d_writer.close();
            this.d_writer = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
    }

    private void spliceIncludes() {
        this.d_writer.println();
        String includes = this.d_ext.getSymbolID().getFullName() + "." + "_includes";
        this.d_splicer.splice(includes, this.d_writer, "Put additional includes or other arbitrary code here...");
        this.d_writer.println();
    }

    private void writeClassBeginning() {
        String name = this.d_ext.getSymbolID().getShortName();
        SymbolID id = this.d_ext.getSymbolID();
        String splicer_symbol_impl = this.d_ext.getSymbolID().getFullName() + "._implementation";
        String splicer_symbol_inherit = this.d_ext.getSymbolID().getFullName() + "._inherits";
        this.d_writer.writeComment(this.d_ext, true);
        this.d_writer.println("class " + name + "_impl");
        this.d_splicer.splice(splicer_symbol_inherit, this.d_writer, "Put additional inheritance here...");
        this.d_writer.println("{");
        this.d_writer.println();
        this.d_writer.println("private:");
        this.d_writer.increaseTabLevel();
        this.d_writer.writeCommentLine("Pointer back to IOR.");
        this.d_writer.writeCommentLine("Use this to dispatch back through IOR vtable.");
        this.d_writer.println(name + " self;");
        this.d_writer.println();
        this.d_splicer.splice(splicer_symbol_impl, this.d_writer, "Put additional implementation details here...");
        this.d_writer.println();
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("private:");
        this.d_writer.increaseTabLevel();
        this.d_writer.writeCommentLine("private default constructor (required)");
        this.d_writer.println(name + "_impl() {} ");
        this.d_writer.println();
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("public:");
        this.d_writer.increaseTabLevel();
        this.d_writer.writeCommentLine("SIDL constructor (required)");
        this.d_writer.writeCommentLine("Note: alternate Skel constructor doesn't call addref()");
        this.d_writer.writeCommentLine("(fixes bug #275)");
        this.d_writer.println(name + "_impl( " + IOR.getObjectName(id) + " * s ) : self(s,true) { _ctor(); }");
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined construction");
        this.d_writer.println("void _ctor();");
        this.d_writer.println();
        this.d_writer.writeCommentLine("virtual destructor (required)");
        this.d_writer.println("virtual ~" + name + "_impl() { _dtor(); }");
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined destruction");
        this.d_writer.println("void _dtor();");
        this.d_writer.println();
    }

    private void writeClassEnd() {
        String name = this.d_ext.getSymbolID().getShortName();
        this.d_writer.decreaseTabLevel();
        this.d_writer.print("};  ");
        this.d_writer.writeCommentLine("end class " + name + "_impl");
        this.d_writer.println();
    }

    private void writeMiscStuff() {
        String splicer_symbol = this.d_ext.getSymbolID().getFullName() + "._misc";
        this.d_splicer.splice(splicer_symbol, this.d_writer, "Put miscellaneous things here...");
        this.d_writer.println();
    }

    private void writeSIDLDefinedMethods() throws CodeGenerationException {
        Method method;
        this.d_writer.decreaseTabLevel();
        this.d_writer.println("public:");
        this.d_writer.increaseTabLevel();
        Iterator m = null;
        m = this.d_ext.getStaticMethods(false).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            Cxx.generateMethodSignature(this.d_writer, method, "user defined static method", 1);
        }
        this.d_writer.println();
        m = this.d_ext.getNonstaticMethods(false).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            if (method.isAbstract()) continue;
            Cxx.generateMethodSignature(this.d_writer, method, "user defined non-static method.", 1);
        }
    }
}

