/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.sidl;

public abstract class BaseArray {
    protected long d_array;
    protected boolean d_owner;

    protected BaseArray() {
        this.d_array = 0L;
        this.d_owner = true;
    }

    protected BaseArray(long array, boolean owner) {
        this.d_array = array;
        this.d_owner = owner;
    }

    protected void reset(long array, boolean owner) {
        this.destroy();
        this.d_array = array;
        this.d_owner = owner;
    }

    public boolean isNull() {
        return this.d_array == 0L;
    }

    public abstract int _dim();

    public abstract int _lower(int var1);

    public abstract int _upper(int var1);

    protected abstract void _destroy();

    protected abstract void _reallocate(int var1, int[] var2, int[] var3);

    public void destroy() {
        if (this.d_owner && this.d_array != 0L) {
            this._destroy();
        }
        this.d_array = 0L;
        this.d_owner = true;
    }

    protected void finalize() throws Throwable {
        this.destroy();
    }

    public void reallocate(int dim, int[] lower, int[] upper) {
        this.destroy();
        if (lower == null || upper == null) {
            throw new ArrayIndexOutOfBoundsException("Null array index argument");
        }
        if (dim != lower.length || dim != upper.length) {
            throw new ArrayIndexOutOfBoundsException("Array dimension mismatch");
        }
        int d = 0;
        while (d < dim) {
            if (upper[d] < lower[d]) {
                throw new ArrayIndexOutOfBoundsException("Upper bound less than lower");
            }
            ++d;
        }
        this._reallocate(dim, lower, upper);
    }

    public int dim() {
        return this.isNull() ? 0 : this._dim();
    }

    protected void checkNullArray() {
        if (this.isNull()) {
            throw new NullPointerException("Array data has not been allocated");
        }
    }

    protected void checkDimension(int d) {
        if (d != this._dim()) {
            throw new ArrayIndexOutOfBoundsException("Illegal array dimension : " + d);
        }
    }

    protected void checkIndexBounds(int i, int d) {
        if (i < this._lower(d) || i > this._upper(d)) {
            throw new ArrayIndexOutOfBoundsException("Index " + d + " out of bounds: " + i);
        }
    }

    protected void checkBounds(int i) {
        this.checkNullArray();
        this.checkDimension(1);
        this.checkIndexBounds(i, 0);
    }

    protected void checkBounds(int i, int j) {
        this.checkNullArray();
        this.checkDimension(2);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
    }

    protected void checkBounds(int i, int j, int k) {
        this.checkNullArray();
        this.checkDimension(3);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
        this.checkIndexBounds(k, 2);
    }

    protected void checkBounds(int i, int j, int k, int l) {
        this.checkNullArray();
        this.checkDimension(4);
        this.checkIndexBounds(i, 0);
        this.checkIndexBounds(j, 1);
        this.checkIndexBounds(k, 2);
        this.checkIndexBounds(l, 3);
    }

    public int lower(int dim) {
        this.checkNullArray();
        this.checkDimension(dim);
        return this._lower(dim);
    }

    public int upper(int dim) {
        this.checkNullArray();
        this.checkDimension(dim);
        return this._upper(dim);
    }
}

