#include <stdio.h>
#include <unistd.h>

/* language independent interfaces */
#include "conway_TimeStepper.h"
#include "conway_Ruleset.h"
#include "conway_Environment.h"

/*
 * Static linking requires the actual classes to be declared at compile
 * time. Dynamic linking can defer this decision to run-time. We'll do
 * static for now.
 */
#include "c_Ruleset.h"
#include "cxx_Environment.h"
/* EDIT HERE: add the include for cxx.TimeStepper or f90.TimeStepper */
#include 

/* Create a 20x50 grid, where live cells appear as runs of five on the
 * middle row 
 */
int32_t init_grid( conway_Environment env) {
  const int32_t height=20, width=50, i = 10;
  int32_t j, k;                 /* loop indices */
  int32_t population = 0;
  struct sidl_int__array *grid=NULL;
  conway_Environment_init(env, height, width);
  grid = conway_Environment_getGrid(env);
  for (j = 0; j < 45; j+=6) {
    for(k = 0; k < 5; ++k) {
      /* ADVANCED: change this function call into a macro */
      sidl_int__array_set2(grid, i, j + k, 1);
      ++population;
    }
  }
  conway_Environment_setGrid( env, grid);
  /* EDIT HERE: call deleteRef on grid here */
  
  return population;
}

void print_grid( conway_Environment env) {
  static const char icon[] = { '.', '0' };
  /* EDIT HERE: declare an array of integers name grid */
  struct ???? grid = 
    conway_Environment_getGrid(env);
  const int32_t
    low0 = sidl_int__array_lower(grid, 0),
    up0 = sidl_int__array_upper(grid, 0),
    low1 = sidl_int__array_lower(grid, 1),
    up1 = sidl_int__array_upper(grid, 1);
  int32_t i, j;                 /* array indices */
  for(i = low0; i <= up0; ++i) {
    for(j = low1; j <= up1; ++j) {
      putchar(icon[sidl_int__array_get2(grid, i, j)]);
    }
    putchar('\n');
  }
}

void main_loop(conway_Ruleset     rs,
               /* EDIT HERE: add an argument env of type conway.Environment */
               conway.Environment env,
               /* EDIT HERE: add an argument ts of type conway.TimeStepper */
               conway.TimeStepper ts) {
  /* int32_t corresponds to a sidl integer */
  int32_t population = init_grid( env );
  int32_t step = 0;
  
  conway_TimeStepper_init(ts, env, rs);

  while (population > 0) {
    /* EDIT HERE: make a call to conway.TimeStepper.step
       (here is its sidl "int step();") */
    population = 
    /* EDIT HERE: followed by a call to conway.TimeStepper.nStepsTaken
       (here is its sidl "int nStepsTaken();") */
    
    printf("step %d:  population %d\n", step, population);
    print_grid(env);
    sleep(1);
  }
}

int main(int argc, char **argv) {
  /* create concrete classes but immediately cast them to their parent
   * interfaces */
  conway_Ruleset rs = 
    conway_Ruleset__cast(c_Ruleset__create());
  /* EDIT HERE: create a cxx.Environment and cast it to conway.Environment */
  conway_Environment env =  ;
  /* EDIT HERE: create a cxx.TimeStepper or f90.TimeStepper and cast it to
     a conway.TimeStepper */
  conway_TimeStepper ts = ;

  main_loop(rs, env, ts);

  /* delete references when done */
  conway_Ruleset_deleteRef(rs);
  /* EDIT HERE: add deleteRef calls for the env and ts interfaces */

  return 0; /* indicate success */
}

