/*
 * File:          sidl_rmi_Response_jniStub.c
 * Symbol:        sidl.rmi.Response-v0.9.1
 * Symbol Type:   interface
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.rmi.Response
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_rmi_Response_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_rmi_Response__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_rmi_Response__object*) ptr;
}

/*
 * <p>
 * Add one to the intrinsic reference count in the underlying object.
 * Object in <code>sidl</code> have an intrinsic reference count.
 * Objects continue to exist as long as the reference count is
 * positive. Clients should call this method whenever they
 * create another ongoing reference to an object or interface.
 * </p>
 * <p>
 * This does not have a return value because there is no language
 * independent type that can refer to an interface or a
 * class.
 * </p>
 */

static void
jni_addRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Decrease by one the intrinsic reference count in the underlying
 * object, and delete the object if the reference is non-positive.
 * Objects in <code>sidl</code> have an intrinsic reference count.
 * Clients should call this method whenever they remove a
 * reference to an object or interface.
 */

static void
jni_deleteRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_deleteRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */

static jboolean
jni_isSame(
  JNIEnv* env,
  jobject obj,
  jobject _arg_iobj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  struct sidl_BaseInterface__object* _tmp_iobj = (struct 
    sidl_BaseInterface__object*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_iobj = (struct sidl_BaseInterface__object*) sidl_Java_J2I_ifc(env,
    _arg_iobj, "sidl.BaseInterface");

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isSame))(
    _ior->d_object,
    _tmp_iobj);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */

static jobject
jni_queryInt(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  struct sidl_BaseInterface__object* _ior_res = (struct 
    sidl_BaseInterface__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_queryInt))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.BaseInterface");

  return _res;
}

/*
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */

static jboolean
jni_isType(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isType))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Return the meta-data about the class implementing this interface.
 */

static jobject
jni_getClassInfo(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  struct sidl_ClassInfo__object* _ior_res = (struct sidl_ClassInfo__object*) 
    NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getClassInfo))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.ClassInfo");

  return _res;
}

/*
 * Method:  unpackBool[]
 */

static void
jni_unpackBool(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  sidl_bool _tmp_value = FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackBool))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_boolean_holder(env, _arg_value, _tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackChar[]
 */

static void
jni_unpackChar(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  char _tmp_value = (char) 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackChar))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_character_holder(env, _arg_value, _tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackInt[]
 */

static void
jni_unpackInt(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  int32_t _tmp_value = 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackInt))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_int_holder(env, _arg_value, _tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackLong[]
 */

static void
jni_unpackLong(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  int64_t _tmp_value = 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackLong))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_long_holder(env, _arg_value, _tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackFloat[]
 */

static void
jni_unpackFloat(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  float _tmp_value = 0.0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackFloat))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_float_holder(env, _arg_value, _tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackDouble[]
 */

static void
jni_unpackDouble(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  double _tmp_value = 0.0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackDouble))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_double_holder(env, _arg_value, _tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackFcomplex[]
 */

static void
jni_unpackFcomplex(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  struct sidl_fcomplex _tmp_value = { 0.0, 0.0 };
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackFcomplex))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_fcomplex_holder(env, _arg_value, &_tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackDcomplex[]
 */

static void
jni_unpackDcomplex(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  struct sidl_dcomplex _tmp_value = { 0.0, 0.0 };
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackDcomplex))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_dcomplex_holder(env, _arg_value, &_tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  unpackString[]
 */

static void
jni_unpackString(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  char* _tmp_value = (char*) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  if(_arg_value== NULL) {
    jclass newExcCls = (*env)->FindClass(env, "java/lang/RuntimeException");
    (*env)->ThrowNew(env, newExcCls, "Null Holder Sent as OUT Argument");
    return;
    }

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_unpackString))(
    _ior->d_object,
    _tmp_key,
    &_tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_I2J_string_holder(env, _arg_value, _tmp_value);
  sidl_String_free(_tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * returns true iff RMI hasn't timed out 
 */

static jboolean
jni_timedOut(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_timedOut))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * if returns null, then safe to unpack arguments 
 */

static jobject
jni_getExceptionThrown(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  struct sidl_BaseException__object* _ior_res = (struct 
    sidl_BaseException__object*) NULL;
  jobject _res = (jobject) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getExceptionThrown))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.BaseException");
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * signal that all is complete 
 */

static jboolean
jni_done(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_rmi_Response__object* _ior = NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_done))(
    _ior->d_object,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_rmi_Response__register(JNIEnv* env)
{
  JNINativeMethod methods[18];
  jclass cls;

  methods[0].name      = "addRef";
  methods[0].signature = "()V";
  methods[0].fnPtr     = (void *)jni_addRef;
  methods[1].name      = "deleteRef";
  methods[1].signature = "()V";
  methods[1].fnPtr     = (void *)jni_deleteRef;
  methods[2].name      = "isSame";
  methods[2].signature = "(Lsidl/BaseInterface;)Z";
  methods[2].fnPtr     = (void *)jni_isSame;
  methods[3].name      = "queryInt";
  methods[3].signature = "(Ljava/lang/String;)Lsidl/BaseInterface;";
  methods[3].fnPtr     = (void *)jni_queryInt;
  methods[4].name      = "isType";
  methods[4].signature = "(Ljava/lang/String;)Z";
  methods[4].fnPtr     = (void *)jni_isType;
  methods[5].name      = "getClassInfo";
  methods[5].signature = "()Lsidl/ClassInfo;";
  methods[5].fnPtr     = (void *)jni_getClassInfo;
  methods[6].name      = "unpackBool";
  methods[6].signature = "(Ljava/lang/String;Lsidl/Boolean$Holder;)V";
  methods[6].fnPtr     = (void *)jni_unpackBool;
  methods[7].name      = "unpackChar";
  methods[7].signature = "(Ljava/lang/String;Lsidl/Character$Holder;)V";
  methods[7].fnPtr     = (void *)jni_unpackChar;
  methods[8].name      = "unpackInt";
  methods[8].signature = "(Ljava/lang/String;Lsidl/Integer$Holder;)V";
  methods[8].fnPtr     = (void *)jni_unpackInt;
  methods[9].name      = "unpackLong";
  methods[9].signature = "(Ljava/lang/String;Lsidl/Long$Holder;)V";
  methods[9].fnPtr     = (void *)jni_unpackLong;
  methods[10].name      = "unpackFloat";
  methods[10].signature = "(Ljava/lang/String;Lsidl/Float$Holder;)V";
  methods[10].fnPtr     = (void *)jni_unpackFloat;
  methods[11].name      = "unpackDouble";
  methods[11].signature = "(Ljava/lang/String;Lsidl/Double$Holder;)V";
  methods[11].fnPtr     = (void *)jni_unpackDouble;
  methods[12].name      = "unpackFcomplex";
  methods[12].signature = "(Ljava/lang/String;Lsidl/FloatComplex$Holder;)V";
  methods[12].fnPtr     = (void *)jni_unpackFcomplex;
  methods[13].name      = "unpackDcomplex";
  methods[13].signature = "(Ljava/lang/String;Lsidl/DoubleComplex$Holder;)V";
  methods[13].fnPtr     = (void *)jni_unpackDcomplex;
  methods[14].name      = "unpackString";
  methods[14].signature = "(Ljava/lang/String;Lsidl/String$Holder;)V";
  methods[14].fnPtr     = (void *)jni_unpackString;
  methods[15].name      = "timedOut";
  methods[15].signature = "()Z";
  methods[15].fnPtr     = (void *)jni_timedOut;
  methods[16].name      = "getExceptionThrown";
  methods[16].signature = "()Lsidl/BaseException;";
  methods[16].fnPtr     = (void *)jni_getExceptionThrown;
  methods[17].name      = "done";
  methods[17].signature = "()Z";
  methods[17].fnPtr     = (void *)jni_done;


  cls = (*env)->FindClass(env, "sidl/rmi/Response$Wrapper");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 18);
    (*env)->DeleteLocalRef(env, cls);
  }
}
