/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class VersionUptodate
extends Task {
    private String buildVersion;
    private File versionSource;
    private File versionTagFile;

    public void setVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }

    public void setVersionSourceFile(File versionSource) {
        this.versionSource = versionSource;
    }

    public void setVersionTagFile(File versionTagFile) {
        this.versionTagFile = versionTagFile;
    }

    public void execute() throws BuildException {
        if (null == this.buildVersion) {
            throw new BuildException("require buildVersion");
        }
        if (null == this.versionSource || !this.versionSource.canRead()) {
            throw new BuildException("require versionSource");
        }
        if (null == this.versionTagFile) {
            throw new BuildException("require versionTagFile");
        }
        if (this.sameVersion(this.versionSource, this.buildVersion)) {
            if (!this.versionTagFile.exists()) {
                this.createFile(this.versionTagFile, this.buildVersion);
            }
        } else {
            if (null == this.versionTagFile) {
                throw new BuildException("no tag file, and version out of date");
            }
            if (this.versionTagFile.exists() && !this.versionTagFile.delete()) {
                throw new BuildException("version out of date, but cannot delete " + this.versionTagFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameVersion(File versionSource, String buildVersion) {
        FileReader fileReader = null;
        try {
            int loc;
            String line;
            fileReader = new FileReader(versionSource);
            BufferedReader reader = new BufferedReader(fileReader);
            while (null != (line = reader.readLine())) {
                loc = line.indexOf("static final String text = ");
                if (-1 == loc) continue;
                boolean bl = -1 != line.indexOf(buildVersion, loc);
                return bl;
            }
            loc = 0;
            return loc != 0;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != fileReader) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void createFile(File versionTagFile, String contents) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(versionTagFile);
            char[] buf = new char[contents.length()];
            contents.getChars(0, buf.length, buf, 0);
            writer.write(contents);
        }
        catch (IOException e) {
            throw new BuildException("writing " + versionTagFile, (Throwable)e);
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

