/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class QualifiedNameReference
extends NameReference {
    public char[][] tokens;
    public long[] sourcePositions;
    public FieldBinding[] otherBindings;
    public FieldBinding[] otherCodegenBindings;
    int[] otherDepths;
    public int indexOfFirstFieldBinding;
    SyntheticMethodBinding syntheticWriteAccessor;
    SyntheticMethodBinding[] syntheticReadAccessors;
    public TypeBinding genericCast;
    public TypeBinding[] otherGenericCasts;

    public QualifiedNameReference(char[][] sources, long[] positions, int sourceStart, int sourceEnd) {
        this.tokens = sources;
        this.sourcePositions = positions;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        TypeBinding lastReceiverType;
        int otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 || !this.otherBindings[0].isStatic();
        FieldBinding lastFieldBinding = null;
        switch (this.bits & 7) {
            case 1: {
                lastFieldBinding = (FieldBinding)this.binding;
                if (needValue) {
                    this.manageSyntheticAccessIfNecessary(currentScope, lastFieldBinding, this.actualReceiverType, 0, flowInfo);
                }
                if (!lastFieldBinding.isBlankFinal() || this.otherBindings == null || !currentScope.allowBlankFinalFieldAssignment(lastFieldBinding) || flowInfo.isDefinitelyAssigned(lastFieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(lastFieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if (flowInfo.isReachable()) {
                    localBinding.useFlag = 1;
                } else if (localBinding.useFlag == 0) {
                    localBinding.useFlag = 2;
                }
                this.checkNullStatus(currentScope, flowContext, flowInfo, -1);
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount - 1) {
                lastFieldBinding = this.otherBindings[i];
                boolean bl = needValue = !this.otherBindings[i + 1].isStatic();
                if (needValue) {
                    this.manageSyntheticAccessIfNecessary(currentScope, lastFieldBinding, i == 0 ? ((VariableBinding)this.binding).type : this.otherBindings[i - 1].type, i + 1, flowInfo);
                }
                ++i;
            }
            lastFieldBinding = this.otherBindings[otherBindingsCount - 1];
        }
        if (isCompound) {
            if (this.binding == lastFieldBinding && lastFieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(lastFieldBinding) && !flowInfo.isDefinitelyAssigned(lastFieldBinding)) {
                currentScope.problemReporter().uninitializedBlankFinalField(lastFieldBinding, this);
            }
            lastReceiverType = lastFieldBinding == this.binding ? this.actualReceiverType : (otherBindingsCount == 1 ? ((VariableBinding)this.binding).type : this.otherBindings[otherBindingsCount - 2].type);
            this.manageSyntheticAccessIfNecessary(currentScope, lastFieldBinding, lastReceiverType, lastFieldBinding == this.binding ? 0 : otherBindingsCount, flowInfo);
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        if (lastFieldBinding.isFinal()) {
            if (lastFieldBinding.isBlankFinal() && !isCompound && currentScope.allowBlankFinalFieldAssignment(lastFieldBinding) && this.indexOfFirstFieldBinding == 1) {
                if (flowInfo.isPotentiallyAssigned(lastFieldBinding)) {
                    currentScope.problemReporter().duplicateInitializationOfBlankFinalField(lastFieldBinding, this);
                } else {
                    flowContext.recordSettingFinal(lastFieldBinding, this, flowInfo);
                }
                flowInfo.markAsDefinitelyAssigned(lastFieldBinding);
            } else {
                currentScope.problemReporter().cannotAssignToFinalField(lastFieldBinding, this);
                if (currentScope.allowBlankFinalFieldAssignment(lastFieldBinding)) {
                    flowInfo.markAsDefinitelyAssigned(lastFieldBinding);
                }
            }
        }
        lastReceiverType = lastFieldBinding == this.binding ? this.actualReceiverType : (otherBindingsCount == 1 ? ((VariableBinding)this.binding).type : this.otherBindings[otherBindingsCount - 2].type);
        this.manageSyntheticAccessIfNecessary(currentScope, lastFieldBinding, lastReceiverType, -1, flowInfo);
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        int otherBindingsCount;
        int n = otherBindingsCount = this.otherBindings == null ? 0 : this.otherBindings.length;
        boolean needValue = otherBindingsCount == 0 ? valueRequired : !this.otherBindings[0].isStatic();
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding;
                if (needValue) {
                    this.manageSyntheticAccessIfNecessary(currentScope, (FieldBinding)this.binding, this.actualReceiverType, 0, flowInfo);
                }
                if (!(fieldBinding = (FieldBinding)this.binding).isBlankFinal() || this.indexOfFirstFieldBinding != 1 || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if (flowInfo.isReachable()) {
                    localBinding.useFlag = 1;
                } else if (localBinding.useFlag == 0) {
                    localBinding.useFlag = 2;
                }
                this.checkNullStatus(currentScope, flowContext, flowInfo, -1);
            }
        }
        if (needValue) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        if (this.otherBindings != null) {
            int i = 0;
            while (i < otherBindingsCount) {
                boolean bl = i < otherBindingsCount - 1 ? !this.otherBindings[i + 1].isStatic() : (needValue = valueRequired);
                if (needValue) {
                    this.manageSyntheticAccessIfNecessary(currentScope, this.otherBindings[i], i == 0 ? ((VariableBinding)this.binding).type : this.otherBindings[i - 1].type, i + 1, flowInfo);
                }
                ++i;
            }
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        MethodScope methodScope = scope.methodScope();
        if (methodScope.enclosingSourceType() == fieldBinding.declaringClass && methodScope.lastVisibleFieldID >= 0 && fieldBinding.id >= methodScope.lastVisibleFieldID && (!fieldBinding.isStatic() || methodScope.isStatic) && this.indexOfFirstFieldBinding == 1) {
            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
        }
        this.bits &= 0xFFFFFFF8;
        this.bits |= 1;
        return this.getOtherFieldBindings(scope);
    }

    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
        FieldBinding originalBinding;
        int length;
        if (runtimeTimeType == null || compileTimeType == null) {
            return;
        }
        FieldBinding field = null;
        int n = length = this.otherBindings == null ? 0 : this.otherBindings.length;
        if (length == 0) {
            if ((this.bits & 1) != 0 && this.binding != null && this.binding.isValidBinding()) {
                field = (FieldBinding)this.binding;
            }
        } else {
            field = this.otherBindings[length - 1];
        }
        if (field != null && (originalBinding = field.original()) != field && (originalBinding.type.tagBits & 0x20000000L) != 0L && runtimeTimeType.id != 1) {
            this.setGenericCast(length, originalBinding.type.genericCast(scope.boxing(runtimeTimeType)));
        }
        super.computeConversion(scope, runtimeTimeType, compileTimeType);
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        FieldBinding lastFieldBinding = this.generateReadSequence(currentScope, codeStream);
        assignment.expression.generateCode(currentScope, codeStream, true);
        this.fieldStore(codeStream, lastFieldBinding, this.syntheticWriteAccessor, valueRequired);
        if (valueRequired) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != ASTNode.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            FieldBinding lastFieldBinding = this.generateReadSequence(currentScope, codeStream);
            if (valueRequired) {
                if (lastFieldBinding.declaringClass == null) {
                    codeStream.arraylength();
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else if (lastFieldBinding.isConstantValue()) {
                    if (!lastFieldBinding.isStatic()) {
                        codeStream.invokeObjectGetClass();
                        codeStream.pop();
                    }
                    codeStream.generateConstant(lastFieldBinding.constant(), this.implicitConversion);
                } else {
                    SyntheticMethodBinding accessor;
                    SyntheticMethodBinding syntheticMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[this.syntheticReadAccessors.length - 1];
                    if (accessor == null) {
                        if (lastFieldBinding.isStatic()) {
                            codeStream.getstatic(lastFieldBinding);
                        } else {
                            codeStream.getfield(lastFieldBinding);
                        }
                    } else {
                        codeStream.invokestatic(accessor);
                    }
                    TypeBinding requiredGenericCast = this.getGenericCast(this.otherCodegenBindings == null ? 0 : this.otherCodegenBindings.length);
                    if (requiredGenericCast != null) {
                        codeStream.checkcast(requiredGenericCast);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                }
            } else if (lastFieldBinding != null && !lastFieldBinding.isStatic()) {
                codeStream.invokeObjectGetClass();
                codeStream.pop();
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        SyntheticMethodBinding accessor;
        FieldBinding lastFieldBinding = this.generateReadSequence(currentScope, codeStream);
        SyntheticMethodBinding syntheticMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[this.syntheticReadAccessors.length - 1];
        if (lastFieldBinding.isStatic()) {
            if (accessor == null) {
                codeStream.getstatic(lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        } else {
            codeStream.dup();
            if (accessor == null) {
                codeStream.getfield(lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        }
        int operationTypeID = (this.implicitConversion & 0xFF) >> 4;
        switch (operationTypeID) {
            case 0: 
            case 1: 
            case 11: {
                codeStream.generateStringConcatenationAppend(currentScope, null, expression);
                break;
            }
            default: {
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(currentScope, codeStream, true);
                }
                codeStream.sendOperator(operator, operationTypeID);
                codeStream.generateImplicitConversion(assignmentImplicitConversion);
            }
        }
        this.fieldStore(codeStream, lastFieldBinding, this.syntheticWriteAccessor, valueRequired);
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        SyntheticMethodBinding accessor;
        FieldBinding lastFieldBinding = this.generateReadSequence(currentScope, codeStream);
        SyntheticMethodBinding syntheticMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[this.syntheticReadAccessors.length - 1];
        if (lastFieldBinding.isStatic()) {
            if (accessor == null) {
                codeStream.getstatic(lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        } else {
            codeStream.dup();
            if (accessor == null) {
                codeStream.getfield(lastFieldBinding);
            } else {
                codeStream.invokestatic(accessor);
            }
        }
        if (valueRequired) {
            if (lastFieldBinding.isStatic()) {
                if (lastFieldBinding.type == BaseTypes.LongBinding || lastFieldBinding.type == BaseTypes.DoubleBinding) {
                    codeStream.dup2();
                } else {
                    codeStream.dup();
                }
            } else if (lastFieldBinding.type == BaseTypes.LongBinding || lastFieldBinding.type == BaseTypes.DoubleBinding) {
                codeStream.dup2_x1();
            } else {
                codeStream.dup_x1();
            }
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
        codeStream.sendOperator(postIncrement.operator, this.implicitConversion & 0xF);
        codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
        this.fieldStore(codeStream, lastFieldBinding, this.syntheticWriteAccessor, false);
    }

    public FieldBinding generateReadSequence(BlockScope currentScope, CodeStream codeStream) {
        int otherBindingsCount = this.otherCodegenBindings == null ? 0 : this.otherCodegenBindings.length;
        boolean needValue = otherBindingsCount == 0 || !this.otherBindings[0].isStatic();
        FieldBinding lastFieldBinding = null;
        TypeBinding lastGenericCast = null;
        switch (this.bits & 7) {
            case 1: {
                lastFieldBinding = (FieldBinding)this.codegenBinding;
                lastGenericCast = this.genericCast;
                if (lastFieldBinding.isConstantValue() || !needValue || lastFieldBinding.isStatic()) break;
                if ((this.bits & 0x1FE0) != 0) {
                    ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                    codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                    break;
                }
                this.generateReceiver(codeStream);
                break;
            }
            case 2: {
                if (!needValue) break;
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.isConstantValue()) {
                    codeStream.generateConstant(localBinding.constant(), 0);
                    break;
                }
                if ((this.bits & 0x1FE0) != 0) {
                    Object[] path = currentScope.getEmulationPath(localBinding);
                    codeStream.generateOuterAccess(path, this, localBinding, currentScope);
                    break;
                }
                codeStream.load(localBinding);
            }
        }
        if (this.otherCodegenBindings != null) {
            int i = 0;
            while (i < otherBindingsCount) {
                TypeBinding nextGenericCast;
                FieldBinding nextField = this.otherCodegenBindings[i];
                TypeBinding typeBinding = nextGenericCast = this.otherGenericCasts == null ? null : this.otherGenericCasts[i];
                if (lastFieldBinding != null) {
                    boolean bl = needValue = !nextField.isStatic();
                    if (needValue) {
                        SyntheticMethodBinding accessor;
                        SyntheticMethodBinding syntheticMethodBinding = accessor = this.syntheticReadAccessors == null ? null : this.syntheticReadAccessors[i];
                        if (accessor == null) {
                            if (lastFieldBinding.isConstantValue()) {
                                if (lastFieldBinding != this.codegenBinding && !lastFieldBinding.isStatic()) {
                                    codeStream.invokeObjectGetClass();
                                    codeStream.pop();
                                }
                                codeStream.generateConstant(lastFieldBinding.constant(), 0);
                            } else if (lastFieldBinding.isStatic()) {
                                codeStream.getstatic(lastFieldBinding);
                            } else {
                                codeStream.getfield(lastFieldBinding);
                            }
                        } else {
                            codeStream.invokestatic(accessor);
                        }
                        if (lastGenericCast != null) {
                            codeStream.checkcast(lastGenericCast);
                        }
                    } else if (this.codegenBinding != lastFieldBinding && !lastFieldBinding.isStatic()) {
                        codeStream.invokeObjectGetClass();
                        codeStream.pop();
                    }
                }
                lastFieldBinding = nextField;
                lastGenericCast = nextGenericCast;
                ++i;
            }
        }
        return lastFieldBinding;
    }

    public void generateReceiver(CodeStream codeStream) {
        codeStream.aload_0();
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    protected FieldBinding getCodegenBinding(int index) {
        if (index == 0) {
            return (FieldBinding)this.codegenBinding;
        }
        return this.otherCodegenBindings[index - 1];
    }

    protected TypeBinding getGenericCast(int index) {
        if (index == 0) {
            return this.genericCast;
        }
        if (this.otherGenericCasts == null) {
            return null;
        }
        return this.otherGenericCasts[index - 1];
    }

    public TypeBinding getOtherFieldBindings(BlockScope scope) {
        FieldBinding field;
        int length = this.tokens.length;
        if ((this.bits & 1) != 0) {
            field = (FieldBinding)this.binding;
            if (!field.isStatic()) {
                if (this.indexOfFirstFieldBinding > 1 || scope.methodScope().isStatic) {
                    scope.problemReporter().staticFieldAccessToNonStaticVariable(this, field);
                    return null;
                }
            } else if (this.indexOfFirstFieldBinding > 1 && field.declaringClass != this.actualReceiverType) {
                scope.problemReporter().indirectAccessToStaticField(this, field);
            }
            if (this.isFieldUseDeprecated(field, scope, (this.bits & 0x2000) != 0 && this.indexOfFirstFieldBinding == length)) {
                scope.problemReporter().deprecatedField(field, this);
            }
        } else {
            field = null;
        }
        TypeBinding type = ((VariableBinding)this.binding).type;
        int index = this.indexOfFirstFieldBinding;
        if (index == length) {
            this.constant = FieldReference.getConstantFor((FieldBinding)this.binding, this, false, scope);
            return type;
        }
        int otherBindingsLength = length - index;
        this.otherBindings = new FieldBinding[otherBindingsLength];
        this.otherCodegenBindings = this.otherBindings;
        this.otherDepths = new int[otherBindingsLength];
        this.constant = field != null ? FieldReference.getConstantFor((FieldBinding)this.binding, this, false, scope) : ((VariableBinding)this.binding).constant();
        int firstDepth = (this.bits & 0x1FE0) >> 5;
        while (index < length) {
            FieldBinding originalBinding;
            char[] token = this.tokens[index];
            if (type == null) {
                return null;
            }
            if (field != null && (originalBinding = field.original()) != field && (originalBinding.type.tagBits & 0x20000000L) != 0L && type.id != 1) {
                this.setGenericCast(index - 1, originalBinding.type.genericCast(type));
            }
            this.bits &= 0xFFFFE01F;
            field = scope.getField(type, token, this);
            int place = index - this.indexOfFirstFieldBinding;
            this.otherBindings[place] = field;
            this.otherDepths[place] = (this.bits & 0x1FE0) >> 5;
            if (field.isValidBinding()) {
                if (this.isFieldUseDeprecated(field, scope, (this.bits & 0x2000) != 0 && index + 1 == length)) {
                    scope.problemReporter().deprecatedField(field, this);
                }
                Constant someConstant = FieldReference.getConstantFor(field, this, false, scope);
                if (this.constant != ASTNode.NotAConstant) {
                    this.constant = someConstant;
                }
                if (field.isStatic()) {
                    scope.problemReporter().nonStaticAccessToStaticField(this, field);
                    if (field.declaringClass != type) {
                        scope.problemReporter().indirectAccessToStaticField(this, field);
                    }
                }
                type = field.type;
                ++index;
                continue;
            }
            this.constant = ASTNode.NotAConstant;
            scope.problemReporter().invalidField(this, field, index, type);
            this.setDepth(firstDepth);
            return null;
        }
        this.setDepth(firstDepth);
        return this.otherBindings[otherBindingsLength - 1].type;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if ((this.bits & 0x1FE0) == 0 || this.constant != ASTNode.NotAConstant) {
            return;
        }
        if ((this.bits & 7) == 2) {
            currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FieldBinding fieldBinding, TypeBinding lastReceiverType, int index, FlowInfo flowInfo) {
        if (index < 0) {
            if (fieldBinding.alwaysNeedsAccessMethod(false)) {
                SyntheticMethodBinding newBinding = fieldBinding.getAccessMethod(false);
                this.setSyntheticAccessor(fieldBinding, index, newBinding);
                FieldBinding originalField = fieldBinding.original();
                if (originalField != fieldBinding) {
                    this.setCodegenBinding(index < 0 ? (this.otherBindings == null ? 0 : this.otherBindings.length) : index, originalField);
                }
                return;
            }
        } else if (fieldBinding.alwaysNeedsAccessMethod(true)) {
            SyntheticMethodBinding newBinding = fieldBinding.getAccessMethod(true);
            this.setSyntheticAccessor(fieldBinding, index, newBinding);
            FieldBinding originalField = fieldBinding.original();
            if (originalField != fieldBinding) {
                this.setCodegenBinding(index < 0 ? (this.otherBindings == null ? 0 : this.otherBindings.length) : index, originalField);
            }
            return;
        }
        if (!flowInfo.isReachable()) {
            return;
        }
        if (fieldBinding.isConstantValue()) {
            return;
        }
        FieldBinding originalField = fieldBinding.original();
        if (originalField != fieldBinding) {
            this.setCodegenBinding(index < 0 ? (this.otherBindings == null ? 0 : this.otherBindings.length) : index, originalField);
        }
        if (fieldBinding.isPrivate()) {
            FieldBinding someCodegenBinding = this.getCodegenBinding(index < 0 ? (this.otherBindings == null ? 0 : this.otherBindings.length) : index);
            if (someCodegenBinding.declaringClass != currentScope.enclosingSourceType()) {
                this.setSyntheticAccessor(fieldBinding, index, ((SourceTypeBinding)someCodegenBinding.declaringClass).addSyntheticMethod(someCodegenBinding, index >= 0));
                currentScope.problemReporter().needToEmulateFieldAccess(someCodegenBinding, this, index >= 0);
                return;
            }
        } else if (fieldBinding.isProtected()) {
            int depth;
            int n = fieldBinding == this.binding ? (this.bits & 0x1FE0) >> 5 : (depth = this.otherDepths[index < 0 ? this.otherDepths.length - 1 : index - 1]);
            if (depth > 0 && fieldBinding.declaringClass.getPackage() != currentScope.enclosingSourceType().getPackage()) {
                FieldBinding someCodegenBinding = this.getCodegenBinding(index < 0 ? (this.otherBindings == null ? 0 : this.otherBindings.length) : index);
                this.setSyntheticAccessor(fieldBinding, index, ((SourceTypeBinding)currentScope.enclosingSourceType().enclosingTypeAt(depth)).addSyntheticMethod(someCodegenBinding, index >= 0));
                currentScope.problemReporter().needToEmulateFieldAccess(someCodegenBinding, this, index >= 0);
                return;
            }
        }
        if (!(fieldBinding.declaringClass == lastReceiverType || lastReceiverType.isArrayType() || fieldBinding.declaringClass == null || fieldBinding.isConstantValue() || (currentScope.environment().options.targetJDK < 0x2E0000L || fieldBinding == this.binding && this.indexOfFirstFieldBinding <= 1 && fieldBinding.isStatic() || fieldBinding.declaringClass.id == 1) && fieldBinding.declaringClass.canBeSeenBy(currentScope))) {
            this.setCodegenBinding(index < 0 ? (this.otherBindings == null ? 0 : this.otherBindings.length) : index, currentScope.enclosingSourceType().getUpdatedFieldBinding(this.getCodegenBinding(index < 0 ? (this.otherBindings == null ? 0 : this.otherBindings.length) : index), (ReferenceBinding)lastReceiverType.erasure()));
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        int i = 0;
        while (i < this.tokens.length) {
            if (i > 0) {
                output.append('.');
            }
            output.append(this.tokens[i]);
            ++i;
        }
        return output;
    }

    public TypeBinding reportError(BlockScope scope) {
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.actualReceiverType = scope.enclosingSourceType();
        this.constant = Constant.NotAConstant;
        this.codegenBinding = this.binding = scope.getBinding(this.tokens, this.bits & 7, (InvocationSite)this, true);
        if (this.binding.isValidBinding()) {
            switch (this.bits & 7) {
                case 3: 
                case 7: {
                    if (this.binding instanceof LocalVariableBinding) {
                        if (!((LocalVariableBinding)this.binding).isFinal() && (this.bits & 0x1FE0) != 0) {
                            scope.problemReporter().cannotReferToNonFinalOuterLocal((LocalVariableBinding)this.binding, this);
                        }
                        this.bits &= 0xFFFFFFF8;
                        this.bits |= 2;
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    if (this.binding instanceof FieldBinding) {
                        FieldBinding fieldBinding = (FieldBinding)this.binding;
                        MethodScope methodScope = scope.methodScope();
                        if (methodScope.enclosingSourceType() == fieldBinding.declaringClass && methodScope.lastVisibleFieldID >= 0 && fieldBinding.id >= methodScope.lastVisibleFieldID && (!fieldBinding.isStatic() || methodScope.isStatic) && this.indexOfFirstFieldBinding == 1) {
                            scope.problemReporter().forwardReference(this, 0, scope.enclosingSourceType());
                        }
                        if (!fieldBinding.isStatic() && this.indexOfFirstFieldBinding == 1 && scope.environment().options.getSeverity(0x400000L) != -1) {
                            scope.problemReporter().unqualifiedFieldAccess(this, fieldBinding);
                        }
                        this.bits &= 0xFFFFFFF8;
                        this.bits |= 1;
                        if (this.indexOfFirstFieldBinding > 1 && this.isTypeUseDeprecated(this.actualReceiverType, scope)) {
                            scope.problemReporter().deprecatedType(this.actualReceiverType, this);
                        }
                        this.resolvedType = this.getOtherFieldBindings(scope);
                        return this.resolvedType;
                    }
                    this.bits &= 0xFFFFFFF8;
                    this.bits |= 4;
                }
                case 4: {
                    TypeBinding type = (TypeBinding)this.binding;
                    if (this.isTypeUseDeprecated(type, scope)) {
                        scope.problemReporter().deprecatedType(type, this);
                    }
                    this.resolvedType = scope.convertToRawType(type);
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    protected void setCodegenBinding(int index, FieldBinding someCodegenBinding) {
        if (index == 0) {
            this.codegenBinding = someCodegenBinding;
        } else {
            int length = this.otherBindings.length;
            if (this.otherCodegenBindings == this.otherBindings) {
                this.otherCodegenBindings = new FieldBinding[length];
                System.arraycopy(this.otherBindings, 0, this.otherCodegenBindings, 0, length);
            }
            this.otherCodegenBindings[index - 1] = someCodegenBinding;
        }
    }

    protected void setGenericCast(int index, TypeBinding someGenericCast) {
        if (index == 0) {
            this.genericCast = someGenericCast;
        } else {
            if (this.otherGenericCasts == null) {
                this.otherGenericCasts = new TypeBinding[this.otherBindings.length];
            }
            this.otherGenericCasts[index - 1] = someGenericCast;
        }
    }

    protected void setSyntheticAccessor(FieldBinding fieldBinding, int index, SyntheticMethodBinding syntheticAccessor) {
        if (index < 0) {
            this.syntheticWriteAccessor = syntheticAccessor;
        } else {
            if (this.syntheticReadAccessors == null) {
                this.syntheticReadAccessors = new SyntheticMethodBinding[this.otherBindings == null ? 1 : this.otherBindings.length + 1];
            }
            this.syntheticReadAccessors[index] = syntheticAccessor;
        }
    }

    public void setFieldIndex(int index) {
        this.indexOfFirstFieldBinding = index;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public String unboundReferenceErrorName() {
        return new String(this.tokens[0]);
    }
}

